/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediatailor.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.mediatailor.MediaTailorAsyncClient;
import software.amazon.awssdk.services.mediatailor.model.ListSourceLocationsRequest;
import software.amazon.awssdk.services.mediatailor.model.ListSourceLocationsResponse;
import software.amazon.awssdk.services.mediatailor.model.SourceLocation;

public class ListSourceLocationsPublisher
implements SdkPublisher<ListSourceLocationsResponse> {
    private final MediaTailorAsyncClient client;
    private final ListSourceLocationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListSourceLocationsPublisher(MediaTailorAsyncClient client, ListSourceLocationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListSourceLocationsPublisher(MediaTailorAsyncClient client, ListSourceLocationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListSourceLocationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListSourceLocationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<SourceLocation> items() {
        Function<ListSourceLocationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListSourceLocationsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListSourceLocationsResponseFetcher
    implements AsyncPageFetcher<ListSourceLocationsResponse> {
        private ListSourceLocationsResponseFetcher() {
        }

        public boolean hasNextPage(ListSourceLocationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListSourceLocationsResponse> nextPage(ListSourceLocationsResponse previousPage) {
            if (previousPage == null) {
                return ListSourceLocationsPublisher.this.client.listSourceLocations(ListSourceLocationsPublisher.this.firstRequest);
            }
            return ListSourceLocationsPublisher.this.client.listSourceLocations((ListSourceLocationsRequest)((Object)ListSourceLocationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

