/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediatailor.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.mediatailor.MediaTailorClient;
import software.amazon.awssdk.services.mediatailor.model.Alert;
import software.amazon.awssdk.services.mediatailor.model.ListAlertsRequest;
import software.amazon.awssdk.services.mediatailor.model.ListAlertsResponse;

public class ListAlertsIterable
implements SdkIterable<ListAlertsResponse> {
    private final MediaTailorClient client;
    private final ListAlertsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListAlertsIterable(MediaTailorClient client, ListAlertsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListAlertsResponseFetcher();
    }

    public Iterator<ListAlertsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Alert> items() {
        Function<ListAlertsResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListAlertsResponseFetcher
    implements SyncPageFetcher<ListAlertsResponse> {
        private ListAlertsResponseFetcher() {
        }

        public boolean hasNextPage(ListAlertsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListAlertsResponse nextPage(ListAlertsResponse previousPage) {
            if (previousPage == null) {
                return ListAlertsIterable.this.client.listAlerts(ListAlertsIterable.this.firstRequest);
            }
            return ListAlertsIterable.this.client.listAlerts((ListAlertsRequest)((Object)ListAlertsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

