/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediatailor.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.mediatailor.model.___listOf__stringCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Alert
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Alert> {
    private static final SdkField<String> ALERT_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AlertCode").getter(Alert.getter(Alert::alertCode)).setter(Alert.setter(Builder::alertCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlertCode").build()}).build();
    private static final SdkField<String> ALERT_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AlertMessage").getter(Alert.getter(Alert::alertMessage)).setter(Alert.setter(Builder::alertMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlertMessage").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModifiedTime").getter(Alert.getter(Alert::lastModifiedTime)).setter(Alert.setter(Builder::lastModifiedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.UNIX_TIMESTAMP)}).build();
    private static final SdkField<List<String>> RELATED_RESOURCE_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RelatedResourceArns").getter(Alert.getter(Alert::relatedResourceArns)).setter(Alert.setter(Builder::relatedResourceArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RelatedResourceArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceArn").getter(Alert.getter(Alert::resourceArn)).setter(Alert.setter(Builder::resourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALERT_CODE_FIELD, ALERT_MESSAGE_FIELD, LAST_MODIFIED_TIME_FIELD, RELATED_RESOURCE_ARNS_FIELD, RESOURCE_ARN_FIELD));
    private static final long serialVersionUID = 1L;
    private final String alertCode;
    private final String alertMessage;
    private final Instant lastModifiedTime;
    private final List<String> relatedResourceArns;
    private final String resourceArn;

    private Alert(BuilderImpl builder) {
        this.alertCode = builder.alertCode;
        this.alertMessage = builder.alertMessage;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.relatedResourceArns = builder.relatedResourceArns;
        this.resourceArn = builder.resourceArn;
    }

    public final String alertCode() {
        return this.alertCode;
    }

    public final String alertMessage() {
        return this.alertMessage;
    }

    public final Instant lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public final boolean hasRelatedResourceArns() {
        return this.relatedResourceArns != null && !(this.relatedResourceArns instanceof SdkAutoConstructList);
    }

    public final List<String> relatedResourceArns() {
        return this.relatedResourceArns;
    }

    public final String resourceArn() {
        return this.resourceArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.alertCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.alertMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRelatedResourceArns() ? this.relatedResourceArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Alert)) {
            return false;
        }
        Alert other = (Alert)obj;
        return Objects.equals(this.alertCode(), other.alertCode()) && Objects.equals(this.alertMessage(), other.alertMessage()) && Objects.equals(this.lastModifiedTime(), other.lastModifiedTime()) && this.hasRelatedResourceArns() == other.hasRelatedResourceArns() && Objects.equals(this.relatedResourceArns(), other.relatedResourceArns()) && Objects.equals(this.resourceArn(), other.resourceArn());
    }

    public final String toString() {
        return ToString.builder((String)"Alert").add("AlertCode", (Object)this.alertCode()).add("AlertMessage", (Object)this.alertMessage()).add("LastModifiedTime", (Object)this.lastModifiedTime()).add("RelatedResourceArns", this.hasRelatedResourceArns() ? this.relatedResourceArns() : null).add("ResourceArn", (Object)this.resourceArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AlertCode": {
                return Optional.ofNullable(clazz.cast(this.alertCode()));
            }
            case "AlertMessage": {
                return Optional.ofNullable(clazz.cast(this.alertMessage()));
            }
            case "LastModifiedTime": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTime()));
            }
            case "RelatedResourceArns": {
                return Optional.ofNullable(clazz.cast(this.relatedResourceArns()));
            }
            case "ResourceArn": {
                return Optional.ofNullable(clazz.cast(this.resourceArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Alert, T> g) {
        return obj -> g.apply((Alert)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String alertCode;
        private String alertMessage;
        private Instant lastModifiedTime;
        private List<String> relatedResourceArns = DefaultSdkAutoConstructList.getInstance();
        private String resourceArn;

        private BuilderImpl() {
        }

        private BuilderImpl(Alert model) {
            this.alertCode(model.alertCode);
            this.alertMessage(model.alertMessage);
            this.lastModifiedTime(model.lastModifiedTime);
            this.relatedResourceArns(model.relatedResourceArns);
            this.resourceArn(model.resourceArn);
        }

        public final String getAlertCode() {
            return this.alertCode;
        }

        public final void setAlertCode(String alertCode) {
            this.alertCode = alertCode;
        }

        @Override
        @Transient
        public final Builder alertCode(String alertCode) {
            this.alertCode = alertCode;
            return this;
        }

        public final String getAlertMessage() {
            return this.alertMessage;
        }

        public final void setAlertMessage(String alertMessage) {
            this.alertMessage = alertMessage;
        }

        @Override
        @Transient
        public final Builder alertMessage(String alertMessage) {
            this.alertMessage = alertMessage;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        @Transient
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final Collection<String> getRelatedResourceArns() {
            if (this.relatedResourceArns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.relatedResourceArns;
        }

        public final void setRelatedResourceArns(Collection<String> relatedResourceArns) {
            this.relatedResourceArns = ___listOf__stringCopier.copy(relatedResourceArns);
        }

        @Override
        @Transient
        public final Builder relatedResourceArns(Collection<String> relatedResourceArns) {
            this.relatedResourceArns = ___listOf__stringCopier.copy(relatedResourceArns);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder relatedResourceArns(String ... relatedResourceArns) {
            this.relatedResourceArns(Arrays.asList(relatedResourceArns));
            return this;
        }

        public final String getResourceArn() {
            return this.resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        @Transient
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public Alert build() {
            return new Alert(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Alert> {
        public Builder alertCode(String var1);

        public Builder alertMessage(String var1);

        public Builder lastModifiedTime(Instant var1);

        public Builder relatedResourceArns(Collection<String> var1);

        public Builder relatedResourceArns(String ... var1);

        public Builder resourceArn(String var1);
    }
}

