/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediatailor.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum RelativePosition {
    BEFORE_PROGRAM("BEFORE_PROGRAM"),
    AFTER_PROGRAM("AFTER_PROGRAM"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private RelativePosition(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static RelativePosition fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(RelativePosition.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<RelativePosition> knownValues() {
        return Stream.of(RelativePosition.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

