/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediatailor.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.mediatailor.MediaTailorClient;
import software.amazon.awssdk.services.mediatailor.model.ListSourceLocationsRequest;
import software.amazon.awssdk.services.mediatailor.model.ListSourceLocationsResponse;
import software.amazon.awssdk.services.mediatailor.model.SourceLocation;

public class ListSourceLocationsIterable
implements SdkIterable<ListSourceLocationsResponse> {
    private final MediaTailorClient client;
    private final ListSourceLocationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListSourceLocationsIterable(MediaTailorClient client, ListSourceLocationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListSourceLocationsResponseFetcher();
    }

    public Iterator<ListSourceLocationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<SourceLocation> items() {
        Function<ListSourceLocationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListSourceLocationsResponseFetcher
    implements SyncPageFetcher<ListSourceLocationsResponse> {
        private ListSourceLocationsResponseFetcher() {
        }

        public boolean hasNextPage(ListSourceLocationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListSourceLocationsResponse nextPage(ListSourceLocationsResponse previousPage) {
            if (previousPage == null) {
                return ListSourceLocationsIterable.this.client.listSourceLocations(ListSourceLocationsIterable.this.firstRequest);
            }
            return ListSourceLocationsIterable.this.client.listSourceLocations((ListSourceLocationsRequest)((Object)ListSourceLocationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

