/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediatailor.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.mediatailor.model.AdBreak;
import software.amazon.awssdk.services.mediatailor.model.MediaTailorResponse;
import software.amazon.awssdk.services.mediatailor.model.___listOfAdBreakCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateProgramResponse
extends MediaTailorResponse
implements ToCopyableBuilder<Builder, CreateProgramResponse> {
    private static final SdkField<List<AdBreak>> AD_BREAKS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AdBreaks").getter(CreateProgramResponse.getter(CreateProgramResponse::adBreaks)).setter(CreateProgramResponse.setter(Builder::adBreaks)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdBreaks").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AdBreak::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(CreateProgramResponse.getter(CreateProgramResponse::arn)).setter(CreateProgramResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> CHANNEL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ChannelName").getter(CreateProgramResponse.getter(CreateProgramResponse::channelName)).setter(CreateProgramResponse.setter(Builder::channelName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChannelName").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(CreateProgramResponse.getter(CreateProgramResponse::creationTime)).setter(CreateProgramResponse.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.UNIX_TIMESTAMP)}).build();
    private static final SdkField<String> PROGRAM_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProgramName").getter(CreateProgramResponse.getter(CreateProgramResponse::programName)).setter(CreateProgramResponse.setter(Builder::programName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProgramName").build()}).build();
    private static final SdkField<Instant> SCHEDULED_START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ScheduledStartTime").getter(CreateProgramResponse.getter(CreateProgramResponse::scheduledStartTime)).setter(CreateProgramResponse.setter(Builder::scheduledStartTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduledStartTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.UNIX_TIMESTAMP)}).build();
    private static final SdkField<String> SOURCE_LOCATION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceLocationName").getter(CreateProgramResponse.getter(CreateProgramResponse::sourceLocationName)).setter(CreateProgramResponse.setter(Builder::sourceLocationName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceLocationName").build()}).build();
    private static final SdkField<String> VOD_SOURCE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VodSourceName").getter(CreateProgramResponse.getter(CreateProgramResponse::vodSourceName)).setter(CreateProgramResponse.setter(Builder::vodSourceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VodSourceName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AD_BREAKS_FIELD, ARN_FIELD, CHANNEL_NAME_FIELD, CREATION_TIME_FIELD, PROGRAM_NAME_FIELD, SCHEDULED_START_TIME_FIELD, SOURCE_LOCATION_NAME_FIELD, VOD_SOURCE_NAME_FIELD));
    private final List<AdBreak> adBreaks;
    private final String arn;
    private final String channelName;
    private final Instant creationTime;
    private final String programName;
    private final Instant scheduledStartTime;
    private final String sourceLocationName;
    private final String vodSourceName;

    private CreateProgramResponse(BuilderImpl builder) {
        super(builder);
        this.adBreaks = builder.adBreaks;
        this.arn = builder.arn;
        this.channelName = builder.channelName;
        this.creationTime = builder.creationTime;
        this.programName = builder.programName;
        this.scheduledStartTime = builder.scheduledStartTime;
        this.sourceLocationName = builder.sourceLocationName;
        this.vodSourceName = builder.vodSourceName;
    }

    public final boolean hasAdBreaks() {
        return this.adBreaks != null && !(this.adBreaks instanceof SdkAutoConstructList);
    }

    public final List<AdBreak> adBreaks() {
        return this.adBreaks;
    }

    public final String arn() {
        return this.arn;
    }

    public final String channelName() {
        return this.channelName;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final String programName() {
        return this.programName;
    }

    public final Instant scheduledStartTime() {
        return this.scheduledStartTime;
    }

    public final String sourceLocationName() {
        return this.sourceLocationName;
    }

    public final String vodSourceName() {
        return this.vodSourceName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAdBreaks() ? this.adBreaks() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.channelName());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.programName());
        hashCode = 31 * hashCode + Objects.hashCode(this.scheduledStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceLocationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.vodSourceName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateProgramResponse)) {
            return false;
        }
        CreateProgramResponse other = (CreateProgramResponse)((Object)obj);
        return this.hasAdBreaks() == other.hasAdBreaks() && Objects.equals(this.adBreaks(), other.adBreaks()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.channelName(), other.channelName()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.programName(), other.programName()) && Objects.equals(this.scheduledStartTime(), other.scheduledStartTime()) && Objects.equals(this.sourceLocationName(), other.sourceLocationName()) && Objects.equals(this.vodSourceName(), other.vodSourceName());
    }

    public final String toString() {
        return ToString.builder((String)"CreateProgramResponse").add("AdBreaks", this.hasAdBreaks() ? this.adBreaks() : null).add("Arn", (Object)this.arn()).add("ChannelName", (Object)this.channelName()).add("CreationTime", (Object)this.creationTime()).add("ProgramName", (Object)this.programName()).add("ScheduledStartTime", (Object)this.scheduledStartTime()).add("SourceLocationName", (Object)this.sourceLocationName()).add("VodSourceName", (Object)this.vodSourceName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AdBreaks": {
                return Optional.ofNullable(clazz.cast(this.adBreaks()));
            }
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "ChannelName": {
                return Optional.ofNullable(clazz.cast(this.channelName()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "ProgramName": {
                return Optional.ofNullable(clazz.cast(this.programName()));
            }
            case "ScheduledStartTime": {
                return Optional.ofNullable(clazz.cast(this.scheduledStartTime()));
            }
            case "SourceLocationName": {
                return Optional.ofNullable(clazz.cast(this.sourceLocationName()));
            }
            case "VodSourceName": {
                return Optional.ofNullable(clazz.cast(this.vodSourceName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateProgramResponse, T> g) {
        return obj -> g.apply((CreateProgramResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MediaTailorResponse.BuilderImpl
    implements Builder {
        private List<AdBreak> adBreaks = DefaultSdkAutoConstructList.getInstance();
        private String arn;
        private String channelName;
        private Instant creationTime;
        private String programName;
        private Instant scheduledStartTime;
        private String sourceLocationName;
        private String vodSourceName;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateProgramResponse model) {
            super(model);
            this.adBreaks(model.adBreaks);
            this.arn(model.arn);
            this.channelName(model.channelName);
            this.creationTime(model.creationTime);
            this.programName(model.programName);
            this.scheduledStartTime(model.scheduledStartTime);
            this.sourceLocationName(model.sourceLocationName);
            this.vodSourceName(model.vodSourceName);
        }

        public final List<AdBreak.Builder> getAdBreaks() {
            List<AdBreak.Builder> result = ___listOfAdBreakCopier.copyToBuilder(this.adBreaks);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAdBreaks(Collection<AdBreak.BuilderImpl> adBreaks) {
            this.adBreaks = ___listOfAdBreakCopier.copyFromBuilder(adBreaks);
        }

        @Override
        public final Builder adBreaks(Collection<AdBreak> adBreaks) {
            this.adBreaks = ___listOfAdBreakCopier.copy(adBreaks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder adBreaks(AdBreak ... adBreaks) {
            this.adBreaks(Arrays.asList(adBreaks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder adBreaks(Consumer<AdBreak.Builder> ... adBreaks) {
            this.adBreaks(Stream.of(adBreaks).map(c -> (AdBreak)((AdBreak.Builder)AdBreak.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getChannelName() {
            return this.channelName;
        }

        public final void setChannelName(String channelName) {
            this.channelName = channelName;
        }

        @Override
        public final Builder channelName(String channelName) {
            this.channelName = channelName;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getProgramName() {
            return this.programName;
        }

        public final void setProgramName(String programName) {
            this.programName = programName;
        }

        @Override
        public final Builder programName(String programName) {
            this.programName = programName;
            return this;
        }

        public final Instant getScheduledStartTime() {
            return this.scheduledStartTime;
        }

        public final void setScheduledStartTime(Instant scheduledStartTime) {
            this.scheduledStartTime = scheduledStartTime;
        }

        @Override
        public final Builder scheduledStartTime(Instant scheduledStartTime) {
            this.scheduledStartTime = scheduledStartTime;
            return this;
        }

        public final String getSourceLocationName() {
            return this.sourceLocationName;
        }

        public final void setSourceLocationName(String sourceLocationName) {
            this.sourceLocationName = sourceLocationName;
        }

        @Override
        public final Builder sourceLocationName(String sourceLocationName) {
            this.sourceLocationName = sourceLocationName;
            return this;
        }

        public final String getVodSourceName() {
            return this.vodSourceName;
        }

        public final void setVodSourceName(String vodSourceName) {
            this.vodSourceName = vodSourceName;
        }

        @Override
        public final Builder vodSourceName(String vodSourceName) {
            this.vodSourceName = vodSourceName;
            return this;
        }

        @Override
        public CreateProgramResponse build() {
            return new CreateProgramResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends MediaTailorResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateProgramResponse> {
        public Builder adBreaks(Collection<AdBreak> var1);

        public Builder adBreaks(AdBreak ... var1);

        public Builder adBreaks(Consumer<AdBreak.Builder> ... var1);

        public Builder arn(String var1);

        public Builder channelName(String var1);

        public Builder creationTime(Instant var1);

        public Builder programName(String var1);

        public Builder scheduledStartTime(Instant var1);

        public Builder sourceLocationName(String var1);

        public Builder vodSourceName(String var1);
    }
}

