/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediatailor.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mediatailor.model.RelativePosition;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Transition
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Transition> {
    private static final SdkField<String> RELATIVE_POSITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RelativePosition").getter(Transition.getter(Transition::relativePositionAsString)).setter(Transition.setter(Builder::relativePosition)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RelativePosition").build()}).build();
    private static final SdkField<String> RELATIVE_PROGRAM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RelativeProgram").getter(Transition.getter(Transition::relativeProgram)).setter(Transition.setter(Builder::relativeProgram)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RelativeProgram").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(Transition.getter(Transition::type)).setter(Transition.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RELATIVE_POSITION_FIELD, RELATIVE_PROGRAM_FIELD, TYPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String relativePosition;
    private final String relativeProgram;
    private final String type;

    private Transition(BuilderImpl builder) {
        this.relativePosition = builder.relativePosition;
        this.relativeProgram = builder.relativeProgram;
        this.type = builder.type;
    }

    public final RelativePosition relativePosition() {
        return RelativePosition.fromValue(this.relativePosition);
    }

    public final String relativePositionAsString() {
        return this.relativePosition;
    }

    public final String relativeProgram() {
        return this.relativeProgram;
    }

    public final String type() {
        return this.type;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.relativePositionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.relativeProgram());
        hashCode = 31 * hashCode + Objects.hashCode(this.type());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Transition)) {
            return false;
        }
        Transition other = (Transition)obj;
        return Objects.equals(this.relativePositionAsString(), other.relativePositionAsString()) && Objects.equals(this.relativeProgram(), other.relativeProgram()) && Objects.equals(this.type(), other.type());
    }

    public final String toString() {
        return ToString.builder((String)"Transition").add("RelativePosition", (Object)this.relativePositionAsString()).add("RelativeProgram", (Object)this.relativeProgram()).add("Type", (Object)this.type()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RelativePosition": {
                return Optional.ofNullable(clazz.cast(this.relativePositionAsString()));
            }
            case "RelativeProgram": {
                return Optional.ofNullable(clazz.cast(this.relativeProgram()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.type()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Transition, T> g) {
        return obj -> g.apply((Transition)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String relativePosition;
        private String relativeProgram;
        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(Transition model) {
            this.relativePosition(model.relativePosition);
            this.relativeProgram(model.relativeProgram);
            this.type(model.type);
        }

        public final String getRelativePosition() {
            return this.relativePosition;
        }

        public final void setRelativePosition(String relativePosition) {
            this.relativePosition = relativePosition;
        }

        @Override
        @Transient
        public final Builder relativePosition(String relativePosition) {
            this.relativePosition = relativePosition;
            return this;
        }

        @Override
        @Transient
        public final Builder relativePosition(RelativePosition relativePosition) {
            this.relativePosition(relativePosition == null ? null : relativePosition.toString());
            return this;
        }

        public final String getRelativeProgram() {
            return this.relativeProgram;
        }

        public final void setRelativeProgram(String relativeProgram) {
            this.relativeProgram = relativeProgram;
        }

        @Override
        @Transient
        public final Builder relativeProgram(String relativeProgram) {
            this.relativeProgram = relativeProgram;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        @Transient
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public Transition build() {
            return new Transition(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Transition> {
        public Builder relativePosition(String var1);

        public Builder relativePosition(RelativePosition var1);

        public Builder relativeProgram(String var1);

        public Builder type(String var1);
    }
}

