/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediatailor.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.mediatailor.model.AccessConfiguration;
import software.amazon.awssdk.services.mediatailor.model.DefaultSegmentDeliveryConfiguration;
import software.amazon.awssdk.services.mediatailor.model.HttpConfiguration;
import software.amazon.awssdk.services.mediatailor.model.MediaTailorResponse;
import software.amazon.awssdk.services.mediatailor.model.___mapOf__stringCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateSourceLocationResponse
extends MediaTailorResponse
implements ToCopyableBuilder<Builder, UpdateSourceLocationResponse> {
    private static final SdkField<AccessConfiguration> ACCESS_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AccessConfiguration").getter(UpdateSourceLocationResponse.getter(UpdateSourceLocationResponse::accessConfiguration)).setter(UpdateSourceLocationResponse.setter(Builder::accessConfiguration)).constructor(AccessConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessConfiguration").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(UpdateSourceLocationResponse.getter(UpdateSourceLocationResponse::arn)).setter(UpdateSourceLocationResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(UpdateSourceLocationResponse.getter(UpdateSourceLocationResponse::creationTime)).setter(UpdateSourceLocationResponse.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.UNIX_TIMESTAMP)}).build();
    private static final SdkField<DefaultSegmentDeliveryConfiguration> DEFAULT_SEGMENT_DELIVERY_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DefaultSegmentDeliveryConfiguration").getter(UpdateSourceLocationResponse.getter(UpdateSourceLocationResponse::defaultSegmentDeliveryConfiguration)).setter(UpdateSourceLocationResponse.setter(Builder::defaultSegmentDeliveryConfiguration)).constructor(DefaultSegmentDeliveryConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultSegmentDeliveryConfiguration").build()}).build();
    private static final SdkField<HttpConfiguration> HTTP_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("HttpConfiguration").getter(UpdateSourceLocationResponse.getter(UpdateSourceLocationResponse::httpConfiguration)).setter(UpdateSourceLocationResponse.setter(Builder::httpConfiguration)).constructor(HttpConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HttpConfiguration").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModifiedTime").getter(UpdateSourceLocationResponse.getter(UpdateSourceLocationResponse::lastModifiedTime)).setter(UpdateSourceLocationResponse.setter(Builder::lastModifiedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.UNIX_TIMESTAMP)}).build();
    private static final SdkField<String> SOURCE_LOCATION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceLocationName").getter(UpdateSourceLocationResponse.getter(UpdateSourceLocationResponse::sourceLocationName)).setter(UpdateSourceLocationResponse.setter(Builder::sourceLocationName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceLocationName").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(UpdateSourceLocationResponse.getter(UpdateSourceLocationResponse::tags)).setter(UpdateSourceLocationResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCESS_CONFIGURATION_FIELD, ARN_FIELD, CREATION_TIME_FIELD, DEFAULT_SEGMENT_DELIVERY_CONFIGURATION_FIELD, HTTP_CONFIGURATION_FIELD, LAST_MODIFIED_TIME_FIELD, SOURCE_LOCATION_NAME_FIELD, TAGS_FIELD));
    private final AccessConfiguration accessConfiguration;
    private final String arn;
    private final Instant creationTime;
    private final DefaultSegmentDeliveryConfiguration defaultSegmentDeliveryConfiguration;
    private final HttpConfiguration httpConfiguration;
    private final Instant lastModifiedTime;
    private final String sourceLocationName;
    private final Map<String, String> tags;

    private UpdateSourceLocationResponse(BuilderImpl builder) {
        super(builder);
        this.accessConfiguration = builder.accessConfiguration;
        this.arn = builder.arn;
        this.creationTime = builder.creationTime;
        this.defaultSegmentDeliveryConfiguration = builder.defaultSegmentDeliveryConfiguration;
        this.httpConfiguration = builder.httpConfiguration;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.sourceLocationName = builder.sourceLocationName;
        this.tags = builder.tags;
    }

    public final AccessConfiguration accessConfiguration() {
        return this.accessConfiguration;
    }

    public final String arn() {
        return this.arn;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final DefaultSegmentDeliveryConfiguration defaultSegmentDeliveryConfiguration() {
        return this.defaultSegmentDeliveryConfiguration;
    }

    public final HttpConfiguration httpConfiguration() {
        return this.httpConfiguration;
    }

    public final Instant lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public final String sourceLocationName() {
        return this.sourceLocationName;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.accessConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultSegmentDeliveryConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.httpConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceLocationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateSourceLocationResponse)) {
            return false;
        }
        UpdateSourceLocationResponse other = (UpdateSourceLocationResponse)((Object)obj);
        return Objects.equals(this.accessConfiguration(), other.accessConfiguration()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.defaultSegmentDeliveryConfiguration(), other.defaultSegmentDeliveryConfiguration()) && Objects.equals(this.httpConfiguration(), other.httpConfiguration()) && Objects.equals(this.lastModifiedTime(), other.lastModifiedTime()) && Objects.equals(this.sourceLocationName(), other.sourceLocationName()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateSourceLocationResponse").add("AccessConfiguration", (Object)this.accessConfiguration()).add("Arn", (Object)this.arn()).add("CreationTime", (Object)this.creationTime()).add("DefaultSegmentDeliveryConfiguration", (Object)this.defaultSegmentDeliveryConfiguration()).add("HttpConfiguration", (Object)this.httpConfiguration()).add("LastModifiedTime", (Object)this.lastModifiedTime()).add("SourceLocationName", (Object)this.sourceLocationName()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccessConfiguration": {
                return Optional.ofNullable(clazz.cast(this.accessConfiguration()));
            }
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "DefaultSegmentDeliveryConfiguration": {
                return Optional.ofNullable(clazz.cast(this.defaultSegmentDeliveryConfiguration()));
            }
            case "HttpConfiguration": {
                return Optional.ofNullable(clazz.cast(this.httpConfiguration()));
            }
            case "LastModifiedTime": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTime()));
            }
            case "SourceLocationName": {
                return Optional.ofNullable(clazz.cast(this.sourceLocationName()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateSourceLocationResponse, T> g) {
        return obj -> g.apply((UpdateSourceLocationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MediaTailorResponse.BuilderImpl
    implements Builder {
        private AccessConfiguration accessConfiguration;
        private String arn;
        private Instant creationTime;
        private DefaultSegmentDeliveryConfiguration defaultSegmentDeliveryConfiguration;
        private HttpConfiguration httpConfiguration;
        private Instant lastModifiedTime;
        private String sourceLocationName;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateSourceLocationResponse model) {
            super(model);
            this.accessConfiguration(model.accessConfiguration);
            this.arn(model.arn);
            this.creationTime(model.creationTime);
            this.defaultSegmentDeliveryConfiguration(model.defaultSegmentDeliveryConfiguration);
            this.httpConfiguration(model.httpConfiguration);
            this.lastModifiedTime(model.lastModifiedTime);
            this.sourceLocationName(model.sourceLocationName);
            this.tags(model.tags);
        }

        public final AccessConfiguration.Builder getAccessConfiguration() {
            return this.accessConfiguration != null ? this.accessConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder accessConfiguration(AccessConfiguration accessConfiguration) {
            this.accessConfiguration = accessConfiguration;
            return this;
        }

        public final void setAccessConfiguration(AccessConfiguration.BuilderImpl accessConfiguration) {
            this.accessConfiguration = accessConfiguration != null ? accessConfiguration.build() : null;
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public final DefaultSegmentDeliveryConfiguration.Builder getDefaultSegmentDeliveryConfiguration() {
            return this.defaultSegmentDeliveryConfiguration != null ? this.defaultSegmentDeliveryConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder defaultSegmentDeliveryConfiguration(DefaultSegmentDeliveryConfiguration defaultSegmentDeliveryConfiguration) {
            this.defaultSegmentDeliveryConfiguration = defaultSegmentDeliveryConfiguration;
            return this;
        }

        public final void setDefaultSegmentDeliveryConfiguration(DefaultSegmentDeliveryConfiguration.BuilderImpl defaultSegmentDeliveryConfiguration) {
            this.defaultSegmentDeliveryConfiguration = defaultSegmentDeliveryConfiguration != null ? defaultSegmentDeliveryConfiguration.build() : null;
        }

        public final HttpConfiguration.Builder getHttpConfiguration() {
            return this.httpConfiguration != null ? this.httpConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder httpConfiguration(HttpConfiguration httpConfiguration) {
            this.httpConfiguration = httpConfiguration;
            return this;
        }

        public final void setHttpConfiguration(HttpConfiguration.BuilderImpl httpConfiguration) {
            this.httpConfiguration = httpConfiguration != null ? httpConfiguration.build() : null;
        }

        public final Instant getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        public final String getSourceLocationName() {
            return this.sourceLocationName;
        }

        @Override
        public final Builder sourceLocationName(String sourceLocationName) {
            this.sourceLocationName = sourceLocationName;
            return this;
        }

        public final void setSourceLocationName(String sourceLocationName) {
            this.sourceLocationName = sourceLocationName;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = ___mapOf__stringCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = ___mapOf__stringCopier.copy(tags);
        }

        @Override
        public UpdateSourceLocationResponse build() {
            return new UpdateSourceLocationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends MediaTailorResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateSourceLocationResponse> {
        public Builder accessConfiguration(AccessConfiguration var1);

        default public Builder accessConfiguration(Consumer<AccessConfiguration.Builder> accessConfiguration) {
            return this.accessConfiguration((AccessConfiguration)((AccessConfiguration.Builder)AccessConfiguration.builder().applyMutation(accessConfiguration)).build());
        }

        public Builder arn(String var1);

        public Builder creationTime(Instant var1);

        public Builder defaultSegmentDeliveryConfiguration(DefaultSegmentDeliveryConfiguration var1);

        default public Builder defaultSegmentDeliveryConfiguration(Consumer<DefaultSegmentDeliveryConfiguration.Builder> defaultSegmentDeliveryConfiguration) {
            return this.defaultSegmentDeliveryConfiguration((DefaultSegmentDeliveryConfiguration)((DefaultSegmentDeliveryConfiguration.Builder)DefaultSegmentDeliveryConfiguration.builder().applyMutation(defaultSegmentDeliveryConfiguration)).build());
        }

        public Builder httpConfiguration(HttpConfiguration var1);

        default public Builder httpConfiguration(Consumer<HttpConfiguration.Builder> httpConfiguration) {
            return this.httpConfiguration((HttpConfiguration)((HttpConfiguration.Builder)HttpConfiguration.builder().applyMutation(httpConfiguration)).build());
        }

        public Builder lastModifiedTime(Instant var1);

        public Builder sourceLocationName(String var1);

        public Builder tags(Map<String, String> var1);
    }
}

