/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediatailor.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.mediatailor.model.HttpPackageConfiguration;
import software.amazon.awssdk.services.mediatailor.model.HttpPackageConfigurationsCopier;
import software.amazon.awssdk.services.mediatailor.model.MediaTailorResponse;
import software.amazon.awssdk.services.mediatailor.model.___mapOf__stringCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateVodSourceResponse
extends MediaTailorResponse
implements ToCopyableBuilder<Builder, CreateVodSourceResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(CreateVodSourceResponse.getter(CreateVodSourceResponse::arn)).setter(CreateVodSourceResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(CreateVodSourceResponse.getter(CreateVodSourceResponse::creationTime)).setter(CreateVodSourceResponse.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.UNIX_TIMESTAMP)}).build();
    private static final SdkField<List<HttpPackageConfiguration>> HTTP_PACKAGE_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("HttpPackageConfigurations").getter(CreateVodSourceResponse.getter(CreateVodSourceResponse::httpPackageConfigurations)).setter(CreateVodSourceResponse.setter(Builder::httpPackageConfigurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HttpPackageConfigurations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(HttpPackageConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModifiedTime").getter(CreateVodSourceResponse.getter(CreateVodSourceResponse::lastModifiedTime)).setter(CreateVodSourceResponse.setter(Builder::lastModifiedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.UNIX_TIMESTAMP)}).build();
    private static final SdkField<String> SOURCE_LOCATION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceLocationName").getter(CreateVodSourceResponse.getter(CreateVodSourceResponse::sourceLocationName)).setter(CreateVodSourceResponse.setter(Builder::sourceLocationName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceLocationName").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(CreateVodSourceResponse.getter(CreateVodSourceResponse::tags)).setter(CreateVodSourceResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> VOD_SOURCE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VodSourceName").getter(CreateVodSourceResponse.getter(CreateVodSourceResponse::vodSourceName)).setter(CreateVodSourceResponse.setter(Builder::vodSourceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VodSourceName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, CREATION_TIME_FIELD, HTTP_PACKAGE_CONFIGURATIONS_FIELD, LAST_MODIFIED_TIME_FIELD, SOURCE_LOCATION_NAME_FIELD, TAGS_FIELD, VOD_SOURCE_NAME_FIELD));
    private final String arn;
    private final Instant creationTime;
    private final List<HttpPackageConfiguration> httpPackageConfigurations;
    private final Instant lastModifiedTime;
    private final String sourceLocationName;
    private final Map<String, String> tags;
    private final String vodSourceName;

    private CreateVodSourceResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.creationTime = builder.creationTime;
        this.httpPackageConfigurations = builder.httpPackageConfigurations;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.sourceLocationName = builder.sourceLocationName;
        this.tags = builder.tags;
        this.vodSourceName = builder.vodSourceName;
    }

    public final String arn() {
        return this.arn;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final boolean hasHttpPackageConfigurations() {
        return this.httpPackageConfigurations != null && !(this.httpPackageConfigurations instanceof SdkAutoConstructList);
    }

    public final List<HttpPackageConfiguration> httpPackageConfigurations() {
        return this.httpPackageConfigurations;
    }

    public final Instant lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public final String sourceLocationName() {
        return this.sourceLocationName;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final String vodSourceName() {
        return this.vodSourceName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasHttpPackageConfigurations() ? this.httpPackageConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceLocationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.vodSourceName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateVodSourceResponse)) {
            return false;
        }
        CreateVodSourceResponse other = (CreateVodSourceResponse)((Object)obj);
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.creationTime(), other.creationTime()) && this.hasHttpPackageConfigurations() == other.hasHttpPackageConfigurations() && Objects.equals(this.httpPackageConfigurations(), other.httpPackageConfigurations()) && Objects.equals(this.lastModifiedTime(), other.lastModifiedTime()) && Objects.equals(this.sourceLocationName(), other.sourceLocationName()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.vodSourceName(), other.vodSourceName());
    }

    public final String toString() {
        return ToString.builder((String)"CreateVodSourceResponse").add("Arn", (Object)this.arn()).add("CreationTime", (Object)this.creationTime()).add("HttpPackageConfigurations", this.hasHttpPackageConfigurations() ? this.httpPackageConfigurations() : null).add("LastModifiedTime", (Object)this.lastModifiedTime()).add("SourceLocationName", (Object)this.sourceLocationName()).add("Tags", this.hasTags() ? this.tags() : null).add("VodSourceName", (Object)this.vodSourceName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "HttpPackageConfigurations": {
                return Optional.ofNullable(clazz.cast(this.httpPackageConfigurations()));
            }
            case "LastModifiedTime": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTime()));
            }
            case "SourceLocationName": {
                return Optional.ofNullable(clazz.cast(this.sourceLocationName()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "VodSourceName": {
                return Optional.ofNullable(clazz.cast(this.vodSourceName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateVodSourceResponse, T> g) {
        return obj -> g.apply((CreateVodSourceResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MediaTailorResponse.BuilderImpl
    implements Builder {
        private String arn;
        private Instant creationTime;
        private List<HttpPackageConfiguration> httpPackageConfigurations = DefaultSdkAutoConstructList.getInstance();
        private Instant lastModifiedTime;
        private String sourceLocationName;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private String vodSourceName;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateVodSourceResponse model) {
            super(model);
            this.arn(model.arn);
            this.creationTime(model.creationTime);
            this.httpPackageConfigurations(model.httpPackageConfigurations);
            this.lastModifiedTime(model.lastModifiedTime);
            this.sourceLocationName(model.sourceLocationName);
            this.tags(model.tags);
            this.vodSourceName(model.vodSourceName);
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public final List<HttpPackageConfiguration.Builder> getHttpPackageConfigurations() {
            List<HttpPackageConfiguration.Builder> result = HttpPackageConfigurationsCopier.copyToBuilder(this.httpPackageConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder httpPackageConfigurations(Collection<HttpPackageConfiguration> httpPackageConfigurations) {
            this.httpPackageConfigurations = HttpPackageConfigurationsCopier.copy(httpPackageConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder httpPackageConfigurations(HttpPackageConfiguration ... httpPackageConfigurations) {
            this.httpPackageConfigurations(Arrays.asList(httpPackageConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder httpPackageConfigurations(Consumer<HttpPackageConfiguration.Builder> ... httpPackageConfigurations) {
            this.httpPackageConfigurations(Stream.of(httpPackageConfigurations).map(c -> (HttpPackageConfiguration)((HttpPackageConfiguration.Builder)HttpPackageConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setHttpPackageConfigurations(Collection<HttpPackageConfiguration.BuilderImpl> httpPackageConfigurations) {
            this.httpPackageConfigurations = HttpPackageConfigurationsCopier.copyFromBuilder(httpPackageConfigurations);
        }

        public final Instant getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        public final String getSourceLocationName() {
            return this.sourceLocationName;
        }

        @Override
        public final Builder sourceLocationName(String sourceLocationName) {
            this.sourceLocationName = sourceLocationName;
            return this;
        }

        public final void setSourceLocationName(String sourceLocationName) {
            this.sourceLocationName = sourceLocationName;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = ___mapOf__stringCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = ___mapOf__stringCopier.copy(tags);
        }

        public final String getVodSourceName() {
            return this.vodSourceName;
        }

        @Override
        public final Builder vodSourceName(String vodSourceName) {
            this.vodSourceName = vodSourceName;
            return this;
        }

        public final void setVodSourceName(String vodSourceName) {
            this.vodSourceName = vodSourceName;
        }

        @Override
        public CreateVodSourceResponse build() {
            return new CreateVodSourceResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends MediaTailorResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateVodSourceResponse> {
        public Builder arn(String var1);

        public Builder creationTime(Instant var1);

        public Builder httpPackageConfigurations(Collection<HttpPackageConfiguration> var1);

        public Builder httpPackageConfigurations(HttpPackageConfiguration ... var1);

        public Builder httpPackageConfigurations(Consumer<HttpPackageConfiguration.Builder> ... var1);

        public Builder lastModifiedTime(Instant var1);

        public Builder sourceLocationName(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder vodSourceName(String var1);
    }
}

