/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediatailor.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.mediatailor.model.HttpPackageConfiguration;
import software.amazon.awssdk.services.mediatailor.model.HttpPackageConfigurationsCopier;
import software.amazon.awssdk.services.mediatailor.model.MediaTailorRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateVodSourceRequest
extends MediaTailorRequest
implements ToCopyableBuilder<Builder, UpdateVodSourceRequest> {
    private static final SdkField<List<HttpPackageConfiguration>> HTTP_PACKAGE_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("HttpPackageConfigurations").getter(UpdateVodSourceRequest.getter(UpdateVodSourceRequest::httpPackageConfigurations)).setter(UpdateVodSourceRequest.setter(Builder::httpPackageConfigurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HttpPackageConfigurations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(HttpPackageConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> SOURCE_LOCATION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceLocationName").getter(UpdateVodSourceRequest.getter(UpdateVodSourceRequest::sourceLocationName)).setter(UpdateVodSourceRequest.setter(Builder::sourceLocationName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("sourceLocationName").build()}).build();
    private static final SdkField<String> VOD_SOURCE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VodSourceName").getter(UpdateVodSourceRequest.getter(UpdateVodSourceRequest::vodSourceName)).setter(UpdateVodSourceRequest.setter(Builder::vodSourceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("vodSourceName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HTTP_PACKAGE_CONFIGURATIONS_FIELD, SOURCE_LOCATION_NAME_FIELD, VOD_SOURCE_NAME_FIELD));
    private final List<HttpPackageConfiguration> httpPackageConfigurations;
    private final String sourceLocationName;
    private final String vodSourceName;

    private UpdateVodSourceRequest(BuilderImpl builder) {
        super(builder);
        this.httpPackageConfigurations = builder.httpPackageConfigurations;
        this.sourceLocationName = builder.sourceLocationName;
        this.vodSourceName = builder.vodSourceName;
    }

    public final boolean hasHttpPackageConfigurations() {
        return this.httpPackageConfigurations != null && !(this.httpPackageConfigurations instanceof SdkAutoConstructList);
    }

    public final List<HttpPackageConfiguration> httpPackageConfigurations() {
        return this.httpPackageConfigurations;
    }

    public final String sourceLocationName() {
        return this.sourceLocationName;
    }

    public final String vodSourceName() {
        return this.vodSourceName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasHttpPackageConfigurations() ? this.httpPackageConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceLocationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.vodSourceName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateVodSourceRequest)) {
            return false;
        }
        UpdateVodSourceRequest other = (UpdateVodSourceRequest)((Object)obj);
        return this.hasHttpPackageConfigurations() == other.hasHttpPackageConfigurations() && Objects.equals(this.httpPackageConfigurations(), other.httpPackageConfigurations()) && Objects.equals(this.sourceLocationName(), other.sourceLocationName()) && Objects.equals(this.vodSourceName(), other.vodSourceName());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateVodSourceRequest").add("HttpPackageConfigurations", this.hasHttpPackageConfigurations() ? this.httpPackageConfigurations() : null).add("SourceLocationName", (Object)this.sourceLocationName()).add("VodSourceName", (Object)this.vodSourceName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "HttpPackageConfigurations": {
                return Optional.ofNullable(clazz.cast(this.httpPackageConfigurations()));
            }
            case "SourceLocationName": {
                return Optional.ofNullable(clazz.cast(this.sourceLocationName()));
            }
            case "VodSourceName": {
                return Optional.ofNullable(clazz.cast(this.vodSourceName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateVodSourceRequest, T> g) {
        return obj -> g.apply((UpdateVodSourceRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MediaTailorRequest.BuilderImpl
    implements Builder {
        private List<HttpPackageConfiguration> httpPackageConfigurations = DefaultSdkAutoConstructList.getInstance();
        private String sourceLocationName;
        private String vodSourceName;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateVodSourceRequest model) {
            super(model);
            this.httpPackageConfigurations(model.httpPackageConfigurations);
            this.sourceLocationName(model.sourceLocationName);
            this.vodSourceName(model.vodSourceName);
        }

        public final Collection<HttpPackageConfiguration.Builder> getHttpPackageConfigurations() {
            if (this.httpPackageConfigurations instanceof SdkAutoConstructList) {
                return null;
            }
            return this.httpPackageConfigurations != null ? (Collection)this.httpPackageConfigurations.stream().map(HttpPackageConfiguration::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder httpPackageConfigurations(Collection<HttpPackageConfiguration> httpPackageConfigurations) {
            this.httpPackageConfigurations = HttpPackageConfigurationsCopier.copy(httpPackageConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder httpPackageConfigurations(HttpPackageConfiguration ... httpPackageConfigurations) {
            this.httpPackageConfigurations(Arrays.asList(httpPackageConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder httpPackageConfigurations(Consumer<HttpPackageConfiguration.Builder> ... httpPackageConfigurations) {
            this.httpPackageConfigurations(Stream.of(httpPackageConfigurations).map(c -> (HttpPackageConfiguration)((HttpPackageConfiguration.Builder)HttpPackageConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setHttpPackageConfigurations(Collection<HttpPackageConfiguration.BuilderImpl> httpPackageConfigurations) {
            this.httpPackageConfigurations = HttpPackageConfigurationsCopier.copyFromBuilder(httpPackageConfigurations);
        }

        public final String getSourceLocationName() {
            return this.sourceLocationName;
        }

        @Override
        public final Builder sourceLocationName(String sourceLocationName) {
            this.sourceLocationName = sourceLocationName;
            return this;
        }

        public final void setSourceLocationName(String sourceLocationName) {
            this.sourceLocationName = sourceLocationName;
        }

        public final String getVodSourceName() {
            return this.vodSourceName;
        }

        @Override
        public final Builder vodSourceName(String vodSourceName) {
            this.vodSourceName = vodSourceName;
            return this;
        }

        public final void setVodSourceName(String vodSourceName) {
            this.vodSourceName = vodSourceName;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateVodSourceRequest build() {
            return new UpdateVodSourceRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends MediaTailorRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateVodSourceRequest> {
        public Builder httpPackageConfigurations(Collection<HttpPackageConfiguration> var1);

        public Builder httpPackageConfigurations(HttpPackageConfiguration ... var1);

        public Builder httpPackageConfigurations(Consumer<HttpPackageConfiguration.Builder> ... var1);

        public Builder sourceLocationName(String var1);

        public Builder vodSourceName(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

