/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediatailor.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ScheduleEntry
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ScheduleEntry> {
    private static final SdkField<Long> APPROXIMATE_DURATION_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("ApproximateDurationSeconds").getter(ScheduleEntry.getter(ScheduleEntry::approximateDurationSeconds)).setter(ScheduleEntry.setter(Builder::approximateDurationSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApproximateDurationSeconds").build()}).build();
    private static final SdkField<Instant> APPROXIMATE_START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ApproximateStartTime").getter(ScheduleEntry.getter(ScheduleEntry::approximateStartTime)).setter(ScheduleEntry.setter(Builder::approximateStartTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApproximateStartTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.UNIX_TIMESTAMP)}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(ScheduleEntry.getter(ScheduleEntry::arn)).setter(ScheduleEntry.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> CHANNEL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ChannelName").getter(ScheduleEntry.getter(ScheduleEntry::channelName)).setter(ScheduleEntry.setter(Builder::channelName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChannelName").build()}).build();
    private static final SdkField<String> PROGRAM_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProgramName").getter(ScheduleEntry.getter(ScheduleEntry::programName)).setter(ScheduleEntry.setter(Builder::programName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProgramName").build()}).build();
    private static final SdkField<String> SOURCE_LOCATION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceLocationName").getter(ScheduleEntry.getter(ScheduleEntry::sourceLocationName)).setter(ScheduleEntry.setter(Builder::sourceLocationName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceLocationName").build()}).build();
    private static final SdkField<String> VOD_SOURCE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VodSourceName").getter(ScheduleEntry.getter(ScheduleEntry::vodSourceName)).setter(ScheduleEntry.setter(Builder::vodSourceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VodSourceName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPROXIMATE_DURATION_SECONDS_FIELD, APPROXIMATE_START_TIME_FIELD, ARN_FIELD, CHANNEL_NAME_FIELD, PROGRAM_NAME_FIELD, SOURCE_LOCATION_NAME_FIELD, VOD_SOURCE_NAME_FIELD));
    private static final long serialVersionUID = 1L;
    private final Long approximateDurationSeconds;
    private final Instant approximateStartTime;
    private final String arn;
    private final String channelName;
    private final String programName;
    private final String sourceLocationName;
    private final String vodSourceName;

    private ScheduleEntry(BuilderImpl builder) {
        this.approximateDurationSeconds = builder.approximateDurationSeconds;
        this.approximateStartTime = builder.approximateStartTime;
        this.arn = builder.arn;
        this.channelName = builder.channelName;
        this.programName = builder.programName;
        this.sourceLocationName = builder.sourceLocationName;
        this.vodSourceName = builder.vodSourceName;
    }

    public final Long approximateDurationSeconds() {
        return this.approximateDurationSeconds;
    }

    public final Instant approximateStartTime() {
        return this.approximateStartTime;
    }

    public final String arn() {
        return this.arn;
    }

    public final String channelName() {
        return this.channelName;
    }

    public final String programName() {
        return this.programName;
    }

    public final String sourceLocationName() {
        return this.sourceLocationName;
    }

    public final String vodSourceName() {
        return this.vodSourceName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.approximateDurationSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.approximateStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.channelName());
        hashCode = 31 * hashCode + Objects.hashCode(this.programName());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceLocationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.vodSourceName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScheduleEntry)) {
            return false;
        }
        ScheduleEntry other = (ScheduleEntry)obj;
        return Objects.equals(this.approximateDurationSeconds(), other.approximateDurationSeconds()) && Objects.equals(this.approximateStartTime(), other.approximateStartTime()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.channelName(), other.channelName()) && Objects.equals(this.programName(), other.programName()) && Objects.equals(this.sourceLocationName(), other.sourceLocationName()) && Objects.equals(this.vodSourceName(), other.vodSourceName());
    }

    public final String toString() {
        return ToString.builder((String)"ScheduleEntry").add("ApproximateDurationSeconds", (Object)this.approximateDurationSeconds()).add("ApproximateStartTime", (Object)this.approximateStartTime()).add("Arn", (Object)this.arn()).add("ChannelName", (Object)this.channelName()).add("ProgramName", (Object)this.programName()).add("SourceLocationName", (Object)this.sourceLocationName()).add("VodSourceName", (Object)this.vodSourceName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApproximateDurationSeconds": {
                return Optional.ofNullable(clazz.cast(this.approximateDurationSeconds()));
            }
            case "ApproximateStartTime": {
                return Optional.ofNullable(clazz.cast(this.approximateStartTime()));
            }
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "ChannelName": {
                return Optional.ofNullable(clazz.cast(this.channelName()));
            }
            case "ProgramName": {
                return Optional.ofNullable(clazz.cast(this.programName()));
            }
            case "SourceLocationName": {
                return Optional.ofNullable(clazz.cast(this.sourceLocationName()));
            }
            case "VodSourceName": {
                return Optional.ofNullable(clazz.cast(this.vodSourceName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ScheduleEntry, T> g) {
        return obj -> g.apply((ScheduleEntry)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Long approximateDurationSeconds;
        private Instant approximateStartTime;
        private String arn;
        private String channelName;
        private String programName;
        private String sourceLocationName;
        private String vodSourceName;

        private BuilderImpl() {
        }

        private BuilderImpl(ScheduleEntry model) {
            this.approximateDurationSeconds(model.approximateDurationSeconds);
            this.approximateStartTime(model.approximateStartTime);
            this.arn(model.arn);
            this.channelName(model.channelName);
            this.programName(model.programName);
            this.sourceLocationName(model.sourceLocationName);
            this.vodSourceName(model.vodSourceName);
        }

        public final Long getApproximateDurationSeconds() {
            return this.approximateDurationSeconds;
        }

        @Override
        public final Builder approximateDurationSeconds(Long approximateDurationSeconds) {
            this.approximateDurationSeconds = approximateDurationSeconds;
            return this;
        }

        public final void setApproximateDurationSeconds(Long approximateDurationSeconds) {
            this.approximateDurationSeconds = approximateDurationSeconds;
        }

        public final Instant getApproximateStartTime() {
            return this.approximateStartTime;
        }

        @Override
        public final Builder approximateStartTime(Instant approximateStartTime) {
            this.approximateStartTime = approximateStartTime;
            return this;
        }

        public final void setApproximateStartTime(Instant approximateStartTime) {
            this.approximateStartTime = approximateStartTime;
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getChannelName() {
            return this.channelName;
        }

        @Override
        public final Builder channelName(String channelName) {
            this.channelName = channelName;
            return this;
        }

        public final void setChannelName(String channelName) {
            this.channelName = channelName;
        }

        public final String getProgramName() {
            return this.programName;
        }

        @Override
        public final Builder programName(String programName) {
            this.programName = programName;
            return this;
        }

        public final void setProgramName(String programName) {
            this.programName = programName;
        }

        public final String getSourceLocationName() {
            return this.sourceLocationName;
        }

        @Override
        public final Builder sourceLocationName(String sourceLocationName) {
            this.sourceLocationName = sourceLocationName;
            return this;
        }

        public final void setSourceLocationName(String sourceLocationName) {
            this.sourceLocationName = sourceLocationName;
        }

        public final String getVodSourceName() {
            return this.vodSourceName;
        }

        @Override
        public final Builder vodSourceName(String vodSourceName) {
            this.vodSourceName = vodSourceName;
            return this;
        }

        public final void setVodSourceName(String vodSourceName) {
            this.vodSourceName = vodSourceName;
        }

        public ScheduleEntry build() {
            return new ScheduleEntry(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ScheduleEntry> {
        public Builder approximateDurationSeconds(Long var1);

        public Builder approximateStartTime(Instant var1);

        public Builder arn(String var1);

        public Builder channelName(String var1);

        public Builder programName(String var1);

        public Builder sourceLocationName(String var1);

        public Builder vodSourceName(String var1);
    }
}

