/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediatailor.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.mediatailor.MediaTailorAsyncClient;
import software.amazon.awssdk.services.mediatailor.model.ListProgramsRequest;
import software.amazon.awssdk.services.mediatailor.model.ListProgramsResponse;
import software.amazon.awssdk.services.mediatailor.model.Program;

public class ListProgramsPublisher
implements SdkPublisher<ListProgramsResponse> {
    private final MediaTailorAsyncClient client;
    private final ListProgramsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListProgramsPublisher(MediaTailorAsyncClient client, ListProgramsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListProgramsPublisher(MediaTailorAsyncClient client, ListProgramsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListProgramsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListProgramsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Program> items() {
        Function<ListProgramsResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListProgramsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListProgramsResponseFetcher
    implements AsyncPageFetcher<ListProgramsResponse> {
        private ListProgramsResponseFetcher() {
        }

        public boolean hasNextPage(ListProgramsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListProgramsResponse> nextPage(ListProgramsResponse previousPage) {
            if (previousPage == null) {
                return ListProgramsPublisher.this.client.listPrograms(ListProgramsPublisher.this.firstRequest);
            }
            return ListProgramsPublisher.this.client.listPrograms((ListProgramsRequest)((Object)ListProgramsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

