/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediatailor.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.mediatailor.model.CdnConfiguration;
import software.amazon.awssdk.services.mediatailor.model.DashConfiguration;
import software.amazon.awssdk.services.mediatailor.model.HlsConfiguration;
import software.amazon.awssdk.services.mediatailor.model.MediaTailorResponse;
import software.amazon.awssdk.services.mediatailor.model.___mapOf__stringCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetPlaybackConfigurationResponse
extends MediaTailorResponse
implements ToCopyableBuilder<Builder, GetPlaybackConfigurationResponse> {
    private static final SdkField<String> AD_DECISION_SERVER_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetPlaybackConfigurationResponse.getter(GetPlaybackConfigurationResponse::adDecisionServerUrl)).setter(GetPlaybackConfigurationResponse.setter(Builder::adDecisionServerUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdDecisionServerUrl").build()}).build();
    private static final SdkField<CdnConfiguration> CDN_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(GetPlaybackConfigurationResponse.getter(GetPlaybackConfigurationResponse::cdnConfiguration)).setter(GetPlaybackConfigurationResponse.setter(Builder::cdnConfiguration)).constructor(CdnConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CdnConfiguration").build()}).build();
    private static final SdkField<DashConfiguration> DASH_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(GetPlaybackConfigurationResponse.getter(GetPlaybackConfigurationResponse::dashConfiguration)).setter(GetPlaybackConfigurationResponse.setter(Builder::dashConfiguration)).constructor(DashConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DashConfiguration").build()}).build();
    private static final SdkField<HlsConfiguration> HLS_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(GetPlaybackConfigurationResponse.getter(GetPlaybackConfigurationResponse::hlsConfiguration)).setter(GetPlaybackConfigurationResponse.setter(Builder::hlsConfiguration)).constructor(HlsConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HlsConfiguration").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetPlaybackConfigurationResponse.getter(GetPlaybackConfigurationResponse::name)).setter(GetPlaybackConfigurationResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> PLAYBACK_CONFIGURATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetPlaybackConfigurationResponse.getter(GetPlaybackConfigurationResponse::playbackConfigurationArn)).setter(GetPlaybackConfigurationResponse.setter(Builder::playbackConfigurationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlaybackConfigurationArn").build()}).build();
    private static final SdkField<String> PLAYBACK_ENDPOINT_PREFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetPlaybackConfigurationResponse.getter(GetPlaybackConfigurationResponse::playbackEndpointPrefix)).setter(GetPlaybackConfigurationResponse.setter(Builder::playbackEndpointPrefix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlaybackEndpointPrefix").build()}).build();
    private static final SdkField<String> SESSION_INITIALIZATION_ENDPOINT_PREFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetPlaybackConfigurationResponse.getter(GetPlaybackConfigurationResponse::sessionInitializationEndpointPrefix)).setter(GetPlaybackConfigurationResponse.setter(Builder::sessionInitializationEndpointPrefix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SessionInitializationEndpointPrefix").build()}).build();
    private static final SdkField<String> SLATE_AD_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetPlaybackConfigurationResponse.getter(GetPlaybackConfigurationResponse::slateAdUrl)).setter(GetPlaybackConfigurationResponse.setter(Builder::slateAdUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SlateAdUrl").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(GetPlaybackConfigurationResponse.getter(GetPlaybackConfigurationResponse::tags)).setter(GetPlaybackConfigurationResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> TRANSCODE_PROFILE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetPlaybackConfigurationResponse.getter(GetPlaybackConfigurationResponse::transcodeProfileName)).setter(GetPlaybackConfigurationResponse.setter(Builder::transcodeProfileName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TranscodeProfileName").build()}).build();
    private static final SdkField<String> VIDEO_CONTENT_SOURCE_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetPlaybackConfigurationResponse.getter(GetPlaybackConfigurationResponse::videoContentSourceUrl)).setter(GetPlaybackConfigurationResponse.setter(Builder::videoContentSourceUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VideoContentSourceUrl").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AD_DECISION_SERVER_URL_FIELD, CDN_CONFIGURATION_FIELD, DASH_CONFIGURATION_FIELD, HLS_CONFIGURATION_FIELD, NAME_FIELD, PLAYBACK_CONFIGURATION_ARN_FIELD, PLAYBACK_ENDPOINT_PREFIX_FIELD, SESSION_INITIALIZATION_ENDPOINT_PREFIX_FIELD, SLATE_AD_URL_FIELD, TAGS_FIELD, TRANSCODE_PROFILE_NAME_FIELD, VIDEO_CONTENT_SOURCE_URL_FIELD));
    private final String adDecisionServerUrl;
    private final CdnConfiguration cdnConfiguration;
    private final DashConfiguration dashConfiguration;
    private final HlsConfiguration hlsConfiguration;
    private final String name;
    private final String playbackConfigurationArn;
    private final String playbackEndpointPrefix;
    private final String sessionInitializationEndpointPrefix;
    private final String slateAdUrl;
    private final Map<String, String> tags;
    private final String transcodeProfileName;
    private final String videoContentSourceUrl;

    private GetPlaybackConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.adDecisionServerUrl = builder.adDecisionServerUrl;
        this.cdnConfiguration = builder.cdnConfiguration;
        this.dashConfiguration = builder.dashConfiguration;
        this.hlsConfiguration = builder.hlsConfiguration;
        this.name = builder.name;
        this.playbackConfigurationArn = builder.playbackConfigurationArn;
        this.playbackEndpointPrefix = builder.playbackEndpointPrefix;
        this.sessionInitializationEndpointPrefix = builder.sessionInitializationEndpointPrefix;
        this.slateAdUrl = builder.slateAdUrl;
        this.tags = builder.tags;
        this.transcodeProfileName = builder.transcodeProfileName;
        this.videoContentSourceUrl = builder.videoContentSourceUrl;
    }

    public String adDecisionServerUrl() {
        return this.adDecisionServerUrl;
    }

    public CdnConfiguration cdnConfiguration() {
        return this.cdnConfiguration;
    }

    public DashConfiguration dashConfiguration() {
        return this.dashConfiguration;
    }

    public HlsConfiguration hlsConfiguration() {
        return this.hlsConfiguration;
    }

    public String name() {
        return this.name;
    }

    public String playbackConfigurationArn() {
        return this.playbackConfigurationArn;
    }

    public String playbackEndpointPrefix() {
        return this.playbackEndpointPrefix;
    }

    public String sessionInitializationEndpointPrefix() {
        return this.sessionInitializationEndpointPrefix;
    }

    public String slateAdUrl() {
        return this.slateAdUrl;
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public String transcodeProfileName() {
        return this.transcodeProfileName;
    }

    public String videoContentSourceUrl() {
        return this.videoContentSourceUrl;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.adDecisionServerUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.cdnConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.dashConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.hlsConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.playbackConfigurationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.playbackEndpointPrefix());
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionInitializationEndpointPrefix());
        hashCode = 31 * hashCode + Objects.hashCode(this.slateAdUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        hashCode = 31 * hashCode + Objects.hashCode(this.transcodeProfileName());
        hashCode = 31 * hashCode + Objects.hashCode(this.videoContentSourceUrl());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetPlaybackConfigurationResponse)) {
            return false;
        }
        GetPlaybackConfigurationResponse other = (GetPlaybackConfigurationResponse)((Object)obj);
        return Objects.equals(this.adDecisionServerUrl(), other.adDecisionServerUrl()) && Objects.equals(this.cdnConfiguration(), other.cdnConfiguration()) && Objects.equals(this.dashConfiguration(), other.dashConfiguration()) && Objects.equals(this.hlsConfiguration(), other.hlsConfiguration()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.playbackConfigurationArn(), other.playbackConfigurationArn()) && Objects.equals(this.playbackEndpointPrefix(), other.playbackEndpointPrefix()) && Objects.equals(this.sessionInitializationEndpointPrefix(), other.sessionInitializationEndpointPrefix()) && Objects.equals(this.slateAdUrl(), other.slateAdUrl()) && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.transcodeProfileName(), other.transcodeProfileName()) && Objects.equals(this.videoContentSourceUrl(), other.videoContentSourceUrl());
    }

    public String toString() {
        return ToString.builder((String)"GetPlaybackConfigurationResponse").add("AdDecisionServerUrl", (Object)this.adDecisionServerUrl()).add("CdnConfiguration", (Object)this.cdnConfiguration()).add("DashConfiguration", (Object)this.dashConfiguration()).add("HlsConfiguration", (Object)this.hlsConfiguration()).add("Name", (Object)this.name()).add("PlaybackConfigurationArn", (Object)this.playbackConfigurationArn()).add("PlaybackEndpointPrefix", (Object)this.playbackEndpointPrefix()).add("SessionInitializationEndpointPrefix", (Object)this.sessionInitializationEndpointPrefix()).add("SlateAdUrl", (Object)this.slateAdUrl()).add("Tags", this.tags()).add("TranscodeProfileName", (Object)this.transcodeProfileName()).add("VideoContentSourceUrl", (Object)this.videoContentSourceUrl()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AdDecisionServerUrl": {
                return Optional.ofNullable(clazz.cast(this.adDecisionServerUrl()));
            }
            case "CdnConfiguration": {
                return Optional.ofNullable(clazz.cast(this.cdnConfiguration()));
            }
            case "DashConfiguration": {
                return Optional.ofNullable(clazz.cast(this.dashConfiguration()));
            }
            case "HlsConfiguration": {
                return Optional.ofNullable(clazz.cast(this.hlsConfiguration()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "PlaybackConfigurationArn": {
                return Optional.ofNullable(clazz.cast(this.playbackConfigurationArn()));
            }
            case "PlaybackEndpointPrefix": {
                return Optional.ofNullable(clazz.cast(this.playbackEndpointPrefix()));
            }
            case "SessionInitializationEndpointPrefix": {
                return Optional.ofNullable(clazz.cast(this.sessionInitializationEndpointPrefix()));
            }
            case "SlateAdUrl": {
                return Optional.ofNullable(clazz.cast(this.slateAdUrl()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "TranscodeProfileName": {
                return Optional.ofNullable(clazz.cast(this.transcodeProfileName()));
            }
            case "VideoContentSourceUrl": {
                return Optional.ofNullable(clazz.cast(this.videoContentSourceUrl()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetPlaybackConfigurationResponse, T> g) {
        return obj -> g.apply((GetPlaybackConfigurationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MediaTailorResponse.BuilderImpl
    implements Builder {
        private String adDecisionServerUrl;
        private CdnConfiguration cdnConfiguration;
        private DashConfiguration dashConfiguration;
        private HlsConfiguration hlsConfiguration;
        private String name;
        private String playbackConfigurationArn;
        private String playbackEndpointPrefix;
        private String sessionInitializationEndpointPrefix;
        private String slateAdUrl;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private String transcodeProfileName;
        private String videoContentSourceUrl;

        private BuilderImpl() {
        }

        private BuilderImpl(GetPlaybackConfigurationResponse model) {
            super(model);
            this.adDecisionServerUrl(model.adDecisionServerUrl);
            this.cdnConfiguration(model.cdnConfiguration);
            this.dashConfiguration(model.dashConfiguration);
            this.hlsConfiguration(model.hlsConfiguration);
            this.name(model.name);
            this.playbackConfigurationArn(model.playbackConfigurationArn);
            this.playbackEndpointPrefix(model.playbackEndpointPrefix);
            this.sessionInitializationEndpointPrefix(model.sessionInitializationEndpointPrefix);
            this.slateAdUrl(model.slateAdUrl);
            this.tags(model.tags);
            this.transcodeProfileName(model.transcodeProfileName);
            this.videoContentSourceUrl(model.videoContentSourceUrl);
        }

        public final String getAdDecisionServerUrl() {
            return this.adDecisionServerUrl;
        }

        @Override
        public final Builder adDecisionServerUrl(String adDecisionServerUrl) {
            this.adDecisionServerUrl = adDecisionServerUrl;
            return this;
        }

        public final void setAdDecisionServerUrl(String adDecisionServerUrl) {
            this.adDecisionServerUrl = adDecisionServerUrl;
        }

        public final CdnConfiguration.Builder getCdnConfiguration() {
            return this.cdnConfiguration != null ? this.cdnConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder cdnConfiguration(CdnConfiguration cdnConfiguration) {
            this.cdnConfiguration = cdnConfiguration;
            return this;
        }

        public final void setCdnConfiguration(CdnConfiguration.BuilderImpl cdnConfiguration) {
            this.cdnConfiguration = cdnConfiguration != null ? cdnConfiguration.build() : null;
        }

        public final DashConfiguration.Builder getDashConfiguration() {
            return this.dashConfiguration != null ? this.dashConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder dashConfiguration(DashConfiguration dashConfiguration) {
            this.dashConfiguration = dashConfiguration;
            return this;
        }

        public final void setDashConfiguration(DashConfiguration.BuilderImpl dashConfiguration) {
            this.dashConfiguration = dashConfiguration != null ? dashConfiguration.build() : null;
        }

        public final HlsConfiguration.Builder getHlsConfiguration() {
            return this.hlsConfiguration != null ? this.hlsConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder hlsConfiguration(HlsConfiguration hlsConfiguration) {
            this.hlsConfiguration = hlsConfiguration;
            return this;
        }

        public final void setHlsConfiguration(HlsConfiguration.BuilderImpl hlsConfiguration) {
            this.hlsConfiguration = hlsConfiguration != null ? hlsConfiguration.build() : null;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getPlaybackConfigurationArn() {
            return this.playbackConfigurationArn;
        }

        @Override
        public final Builder playbackConfigurationArn(String playbackConfigurationArn) {
            this.playbackConfigurationArn = playbackConfigurationArn;
            return this;
        }

        public final void setPlaybackConfigurationArn(String playbackConfigurationArn) {
            this.playbackConfigurationArn = playbackConfigurationArn;
        }

        public final String getPlaybackEndpointPrefix() {
            return this.playbackEndpointPrefix;
        }

        @Override
        public final Builder playbackEndpointPrefix(String playbackEndpointPrefix) {
            this.playbackEndpointPrefix = playbackEndpointPrefix;
            return this;
        }

        public final void setPlaybackEndpointPrefix(String playbackEndpointPrefix) {
            this.playbackEndpointPrefix = playbackEndpointPrefix;
        }

        public final String getSessionInitializationEndpointPrefix() {
            return this.sessionInitializationEndpointPrefix;
        }

        @Override
        public final Builder sessionInitializationEndpointPrefix(String sessionInitializationEndpointPrefix) {
            this.sessionInitializationEndpointPrefix = sessionInitializationEndpointPrefix;
            return this;
        }

        public final void setSessionInitializationEndpointPrefix(String sessionInitializationEndpointPrefix) {
            this.sessionInitializationEndpointPrefix = sessionInitializationEndpointPrefix;
        }

        public final String getSlateAdUrl() {
            return this.slateAdUrl;
        }

        @Override
        public final Builder slateAdUrl(String slateAdUrl) {
            this.slateAdUrl = slateAdUrl;
            return this;
        }

        public final void setSlateAdUrl(String slateAdUrl) {
            this.slateAdUrl = slateAdUrl;
        }

        public final Map<String, String> getTags() {
            return this.tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = ___mapOf__stringCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = ___mapOf__stringCopier.copy(tags);
        }

        public final String getTranscodeProfileName() {
            return this.transcodeProfileName;
        }

        @Override
        public final Builder transcodeProfileName(String transcodeProfileName) {
            this.transcodeProfileName = transcodeProfileName;
            return this;
        }

        public final void setTranscodeProfileName(String transcodeProfileName) {
            this.transcodeProfileName = transcodeProfileName;
        }

        public final String getVideoContentSourceUrl() {
            return this.videoContentSourceUrl;
        }

        @Override
        public final Builder videoContentSourceUrl(String videoContentSourceUrl) {
            this.videoContentSourceUrl = videoContentSourceUrl;
            return this;
        }

        public final void setVideoContentSourceUrl(String videoContentSourceUrl) {
            this.videoContentSourceUrl = videoContentSourceUrl;
        }

        @Override
        public GetPlaybackConfigurationResponse build() {
            return new GetPlaybackConfigurationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends MediaTailorResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetPlaybackConfigurationResponse> {
        public Builder adDecisionServerUrl(String var1);

        public Builder cdnConfiguration(CdnConfiguration var1);

        default public Builder cdnConfiguration(Consumer<CdnConfiguration.Builder> cdnConfiguration) {
            return this.cdnConfiguration((CdnConfiguration)((CdnConfiguration.Builder)CdnConfiguration.builder().applyMutation(cdnConfiguration)).build());
        }

        public Builder dashConfiguration(DashConfiguration var1);

        default public Builder dashConfiguration(Consumer<DashConfiguration.Builder> dashConfiguration) {
            return this.dashConfiguration((DashConfiguration)((DashConfiguration.Builder)DashConfiguration.builder().applyMutation(dashConfiguration)).build());
        }

        public Builder hlsConfiguration(HlsConfiguration var1);

        default public Builder hlsConfiguration(Consumer<HlsConfiguration.Builder> hlsConfiguration) {
            return this.hlsConfiguration((HlsConfiguration)((HlsConfiguration.Builder)HlsConfiguration.builder().applyMutation(hlsConfiguration)).build());
        }

        public Builder name(String var1);

        public Builder playbackConfigurationArn(String var1);

        public Builder playbackEndpointPrefix(String var1);

        public Builder sessionInitializationEndpointPrefix(String var1);

        public Builder slateAdUrl(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder transcodeProfileName(String var1);

        public Builder videoContentSourceUrl(String var1);
    }
}

