/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediastore.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mediastore.model.MediaStoreRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutLifecyclePolicyRequest
extends MediaStoreRequest
implements ToCopyableBuilder<Builder, PutLifecyclePolicyRequest> {
    private static final SdkField<String> CONTAINER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PutLifecyclePolicyRequest.getter(PutLifecyclePolicyRequest::containerName)).setter(PutLifecyclePolicyRequest.setter(Builder::containerName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContainerName").build()}).build();
    private static final SdkField<String> LIFECYCLE_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PutLifecyclePolicyRequest.getter(PutLifecyclePolicyRequest::lifecyclePolicy)).setter(PutLifecyclePolicyRequest.setter(Builder::lifecyclePolicy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LifecyclePolicy").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTAINER_NAME_FIELD, LIFECYCLE_POLICY_FIELD));
    private final String containerName;
    private final String lifecyclePolicy;

    private PutLifecyclePolicyRequest(BuilderImpl builder) {
        super(builder);
        this.containerName = builder.containerName;
        this.lifecyclePolicy = builder.lifecyclePolicy;
    }

    public String containerName() {
        return this.containerName;
    }

    public String lifecyclePolicy() {
        return this.lifecyclePolicy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.containerName());
        hashCode = 31 * hashCode + Objects.hashCode(this.lifecyclePolicy());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutLifecyclePolicyRequest)) {
            return false;
        }
        PutLifecyclePolicyRequest other = (PutLifecyclePolicyRequest)((Object)obj);
        return Objects.equals(this.containerName(), other.containerName()) && Objects.equals(this.lifecyclePolicy(), other.lifecyclePolicy());
    }

    public String toString() {
        return ToString.builder((String)"PutLifecyclePolicyRequest").add("ContainerName", (Object)this.containerName()).add("LifecyclePolicy", (Object)this.lifecyclePolicy()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ContainerName": {
                return Optional.ofNullable(clazz.cast(this.containerName()));
            }
            case "LifecyclePolicy": {
                return Optional.ofNullable(clazz.cast(this.lifecyclePolicy()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutLifecyclePolicyRequest, T> g) {
        return obj -> g.apply((PutLifecyclePolicyRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MediaStoreRequest.BuilderImpl
    implements Builder {
        private String containerName;
        private String lifecyclePolicy;

        private BuilderImpl() {
        }

        private BuilderImpl(PutLifecyclePolicyRequest model) {
            super(model);
            this.containerName(model.containerName);
            this.lifecyclePolicy(model.lifecyclePolicy);
        }

        public final String getContainerName() {
            return this.containerName;
        }

        @Override
        public final Builder containerName(String containerName) {
            this.containerName = containerName;
            return this;
        }

        public final void setContainerName(String containerName) {
            this.containerName = containerName;
        }

        public final String getLifecyclePolicy() {
            return this.lifecyclePolicy;
        }

        @Override
        public final Builder lifecyclePolicy(String lifecyclePolicy) {
            this.lifecyclePolicy = lifecyclePolicy;
            return this;
        }

        public final void setLifecyclePolicy(String lifecyclePolicy) {
            this.lifecyclePolicy = lifecyclePolicy;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutLifecyclePolicyRequest build() {
            return new PutLifecyclePolicyRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends MediaStoreRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutLifecyclePolicyRequest> {
        public Builder containerName(String var1);

        public Builder lifecyclePolicy(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

