/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediastore.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum MethodName {
    PUT("PUT"),
    GET("GET"),
    DELETE("DELETE"),
    HEAD("HEAD"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, MethodName> VALUE_MAP;
    private final String value;

    private MethodName(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static MethodName fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<MethodName> knownValues() {
        EnumSet<MethodName> knownValues = EnumSet.allOf(MethodName.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(MethodName.class, MethodName::toString);
    }
}

