/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediastore.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A rule for a CORS policy. You can add up to 100 rules to a CORS policy. If more than one rule applies, the service
 * uses the first applicable rule listed.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CorsRule implements SdkPojo, Serializable, ToCopyableBuilder<CorsRule.Builder, CorsRule> {
    private static final SdkField<List<String>> ALLOWED_ORIGINS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AllowedOrigins")
            .getter(getter(CorsRule::allowedOrigins))
            .setter(setter(Builder::allowedOrigins))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowedOrigins").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> ALLOWED_METHODS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AllowedMethods")
            .getter(getter(CorsRule::allowedMethodsAsStrings))
            .setter(setter(Builder::allowedMethodsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowedMethods").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> ALLOWED_HEADERS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AllowedHeaders")
            .getter(getter(CorsRule::allowedHeaders))
            .setter(setter(Builder::allowedHeaders))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowedHeaders").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> MAX_AGE_SECONDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxAgeSeconds").getter(getter(CorsRule::maxAgeSeconds)).setter(setter(Builder::maxAgeSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxAgeSeconds").build()).build();

    private static final SdkField<List<String>> EXPOSE_HEADERS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ExposeHeaders")
            .getter(getter(CorsRule::exposeHeaders))
            .setter(setter(Builder::exposeHeaders))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExposeHeaders").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALLOWED_ORIGINS_FIELD,
            ALLOWED_METHODS_FIELD, ALLOWED_HEADERS_FIELD, MAX_AGE_SECONDS_FIELD, EXPOSE_HEADERS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> allowedOrigins;

    private final List<String> allowedMethods;

    private final List<String> allowedHeaders;

    private final Integer maxAgeSeconds;

    private final List<String> exposeHeaders;

    private CorsRule(BuilderImpl builder) {
        this.allowedOrigins = builder.allowedOrigins;
        this.allowedMethods = builder.allowedMethods;
        this.allowedHeaders = builder.allowedHeaders;
        this.maxAgeSeconds = builder.maxAgeSeconds;
        this.exposeHeaders = builder.exposeHeaders;
    }

    /**
     * Returns true if the AllowedOrigins property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasAllowedOrigins() {
        return allowedOrigins != null && !(allowedOrigins instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * One or more response headers that you want users to be able to access from their applications (for example, from
     * a JavaScript <code>XMLHttpRequest</code> object).
     * </p>
     * <p>
     * Each CORS rule must have at least one <code>AllowedOrigins</code> element. The string value can include only one
     * wildcard character (*), for example, http://*.example.com. Additionally, you can specify only one wildcard
     * character to allow cross-origin access for all origins.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAllowedOrigins()} to see if a value was sent in this field.
     * </p>
     * 
     * @return One or more response headers that you want users to be able to access from their applications (for
     *         example, from a JavaScript <code>XMLHttpRequest</code> object).</p>
     *         <p>
     *         Each CORS rule must have at least one <code>AllowedOrigins</code> element. The string value can include
     *         only one wildcard character (*), for example, http://*.example.com. Additionally, you can specify only
     *         one wildcard character to allow cross-origin access for all origins.
     */
    public final List<String> allowedOrigins() {
        return allowedOrigins;
    }

    /**
     * <p>
     * Identifies an HTTP method that the origin that is specified in the rule is allowed to execute.
     * </p>
     * <p>
     * Each CORS rule must contain at least one <code>AllowedMethods</code> and one <code>AllowedOrigins</code> element.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAllowedMethods()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Identifies an HTTP method that the origin that is specified in the rule is allowed to execute.</p>
     *         <p>
     *         Each CORS rule must contain at least one <code>AllowedMethods</code> and one <code>AllowedOrigins</code>
     *         element.
     */
    public final List<MethodName> allowedMethods() {
        return AllowedMethodsCopier.copyStringToEnum(allowedMethods);
    }

    /**
     * Returns true if the AllowedMethods property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasAllowedMethods() {
        return allowedMethods != null && !(allowedMethods instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Identifies an HTTP method that the origin that is specified in the rule is allowed to execute.
     * </p>
     * <p>
     * Each CORS rule must contain at least one <code>AllowedMethods</code> and one <code>AllowedOrigins</code> element.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAllowedMethods()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Identifies an HTTP method that the origin that is specified in the rule is allowed to execute.</p>
     *         <p>
     *         Each CORS rule must contain at least one <code>AllowedMethods</code> and one <code>AllowedOrigins</code>
     *         element.
     */
    public final List<String> allowedMethodsAsStrings() {
        return allowedMethods;
    }

    /**
     * Returns true if the AllowedHeaders property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasAllowedHeaders() {
        return allowedHeaders != null && !(allowedHeaders instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies which headers are allowed in a preflight <code>OPTIONS</code> request through the
     * <code>Access-Control-Request-Headers</code> header. Each header name that is specified in
     * <code>Access-Control-Request-Headers</code> must have a corresponding entry in the rule. Only the headers that
     * were requested are sent back.
     * </p>
     * <p>
     * This element can contain only one wildcard character (*).
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAllowedHeaders()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Specifies which headers are allowed in a preflight <code>OPTIONS</code> request through the
     *         <code>Access-Control-Request-Headers</code> header. Each header name that is specified in
     *         <code>Access-Control-Request-Headers</code> must have a corresponding entry in the rule. Only the headers
     *         that were requested are sent back. </p>
     *         <p>
     *         This element can contain only one wildcard character (*).
     */
    public final List<String> allowedHeaders() {
        return allowedHeaders;
    }

    /**
     * <p>
     * The time in seconds that your browser caches the preflight response for the specified resource.
     * </p>
     * <p>
     * A CORS rule can have only one <code>MaxAgeSeconds</code> element.
     * </p>
     * 
     * @return The time in seconds that your browser caches the preflight response for the specified resource.</p>
     *         <p>
     *         A CORS rule can have only one <code>MaxAgeSeconds</code> element.
     */
    public final Integer maxAgeSeconds() {
        return maxAgeSeconds;
    }

    /**
     * Returns true if the ExposeHeaders property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasExposeHeaders() {
        return exposeHeaders != null && !(exposeHeaders instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * One or more headers in the response that you want users to be able to access from their applications (for
     * example, from a JavaScript <code>XMLHttpRequest</code> object).
     * </p>
     * <p>
     * This element is optional for each rule.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasExposeHeaders()} to see if a value was sent in this field.
     * </p>
     * 
     * @return One or more headers in the response that you want users to be able to access from their applications (for
     *         example, from a JavaScript <code>XMLHttpRequest</code> object).</p>
     *         <p>
     *         This element is optional for each rule.
     */
    public final List<String> exposeHeaders() {
        return exposeHeaders;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasAllowedOrigins() ? allowedOrigins() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAllowedMethods() ? allowedMethodsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAllowedHeaders() ? allowedHeaders() : null);
        hashCode = 31 * hashCode + Objects.hashCode(maxAgeSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(hasExposeHeaders() ? exposeHeaders() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CorsRule)) {
            return false;
        }
        CorsRule other = (CorsRule) obj;
        return hasAllowedOrigins() == other.hasAllowedOrigins() && Objects.equals(allowedOrigins(), other.allowedOrigins())
                && hasAllowedMethods() == other.hasAllowedMethods()
                && Objects.equals(allowedMethodsAsStrings(), other.allowedMethodsAsStrings())
                && hasAllowedHeaders() == other.hasAllowedHeaders() && Objects.equals(allowedHeaders(), other.allowedHeaders())
                && Objects.equals(maxAgeSeconds(), other.maxAgeSeconds()) && hasExposeHeaders() == other.hasExposeHeaders()
                && Objects.equals(exposeHeaders(), other.exposeHeaders());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CorsRule").add("AllowedOrigins", hasAllowedOrigins() ? allowedOrigins() : null)
                .add("AllowedMethods", hasAllowedMethods() ? allowedMethodsAsStrings() : null)
                .add("AllowedHeaders", hasAllowedHeaders() ? allowedHeaders() : null).add("MaxAgeSeconds", maxAgeSeconds())
                .add("ExposeHeaders", hasExposeHeaders() ? exposeHeaders() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AllowedOrigins":
            return Optional.ofNullable(clazz.cast(allowedOrigins()));
        case "AllowedMethods":
            return Optional.ofNullable(clazz.cast(allowedMethodsAsStrings()));
        case "AllowedHeaders":
            return Optional.ofNullable(clazz.cast(allowedHeaders()));
        case "MaxAgeSeconds":
            return Optional.ofNullable(clazz.cast(maxAgeSeconds()));
        case "ExposeHeaders":
            return Optional.ofNullable(clazz.cast(exposeHeaders()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CorsRule, T> g) {
        return obj -> g.apply((CorsRule) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CorsRule> {
        /**
         * <p>
         * One or more response headers that you want users to be able to access from their applications (for example,
         * from a JavaScript <code>XMLHttpRequest</code> object).
         * </p>
         * <p>
         * Each CORS rule must have at least one <code>AllowedOrigins</code> element. The string value can include only
         * one wildcard character (*), for example, http://*.example.com. Additionally, you can specify only one
         * wildcard character to allow cross-origin access for all origins.
         * </p>
         * 
         * @param allowedOrigins
         *        One or more response headers that you want users to be able to access from their applications (for
         *        example, from a JavaScript <code>XMLHttpRequest</code> object).</p>
         *        <p>
         *        Each CORS rule must have at least one <code>AllowedOrigins</code> element. The string value can
         *        include only one wildcard character (*), for example, http://*.example.com. Additionally, you can
         *        specify only one wildcard character to allow cross-origin access for all origins.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedOrigins(Collection<String> allowedOrigins);

        /**
         * <p>
         * One or more response headers that you want users to be able to access from their applications (for example,
         * from a JavaScript <code>XMLHttpRequest</code> object).
         * </p>
         * <p>
         * Each CORS rule must have at least one <code>AllowedOrigins</code> element. The string value can include only
         * one wildcard character (*), for example, http://*.example.com. Additionally, you can specify only one
         * wildcard character to allow cross-origin access for all origins.
         * </p>
         * 
         * @param allowedOrigins
         *        One or more response headers that you want users to be able to access from their applications (for
         *        example, from a JavaScript <code>XMLHttpRequest</code> object).</p>
         *        <p>
         *        Each CORS rule must have at least one <code>AllowedOrigins</code> element. The string value can
         *        include only one wildcard character (*), for example, http://*.example.com. Additionally, you can
         *        specify only one wildcard character to allow cross-origin access for all origins.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedOrigins(String... allowedOrigins);

        /**
         * <p>
         * Identifies an HTTP method that the origin that is specified in the rule is allowed to execute.
         * </p>
         * <p>
         * Each CORS rule must contain at least one <code>AllowedMethods</code> and one <code>AllowedOrigins</code>
         * element.
         * </p>
         * 
         * @param allowedMethods
         *        Identifies an HTTP method that the origin that is specified in the rule is allowed to execute.</p>
         *        <p>
         *        Each CORS rule must contain at least one <code>AllowedMethods</code> and one
         *        <code>AllowedOrigins</code> element.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedMethodsWithStrings(Collection<String> allowedMethods);

        /**
         * <p>
         * Identifies an HTTP method that the origin that is specified in the rule is allowed to execute.
         * </p>
         * <p>
         * Each CORS rule must contain at least one <code>AllowedMethods</code> and one <code>AllowedOrigins</code>
         * element.
         * </p>
         * 
         * @param allowedMethods
         *        Identifies an HTTP method that the origin that is specified in the rule is allowed to execute.</p>
         *        <p>
         *        Each CORS rule must contain at least one <code>AllowedMethods</code> and one
         *        <code>AllowedOrigins</code> element.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedMethodsWithStrings(String... allowedMethods);

        /**
         * <p>
         * Identifies an HTTP method that the origin that is specified in the rule is allowed to execute.
         * </p>
         * <p>
         * Each CORS rule must contain at least one <code>AllowedMethods</code> and one <code>AllowedOrigins</code>
         * element.
         * </p>
         * 
         * @param allowedMethods
         *        Identifies an HTTP method that the origin that is specified in the rule is allowed to execute.</p>
         *        <p>
         *        Each CORS rule must contain at least one <code>AllowedMethods</code> and one
         *        <code>AllowedOrigins</code> element.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedMethods(Collection<MethodName> allowedMethods);

        /**
         * <p>
         * Identifies an HTTP method that the origin that is specified in the rule is allowed to execute.
         * </p>
         * <p>
         * Each CORS rule must contain at least one <code>AllowedMethods</code> and one <code>AllowedOrigins</code>
         * element.
         * </p>
         * 
         * @param allowedMethods
         *        Identifies an HTTP method that the origin that is specified in the rule is allowed to execute.</p>
         *        <p>
         *        Each CORS rule must contain at least one <code>AllowedMethods</code> and one
         *        <code>AllowedOrigins</code> element.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedMethods(MethodName... allowedMethods);

        /**
         * <p>
         * Specifies which headers are allowed in a preflight <code>OPTIONS</code> request through the
         * <code>Access-Control-Request-Headers</code> header. Each header name that is specified in
         * <code>Access-Control-Request-Headers</code> must have a corresponding entry in the rule. Only the headers
         * that were requested are sent back.
         * </p>
         * <p>
         * This element can contain only one wildcard character (*).
         * </p>
         * 
         * @param allowedHeaders
         *        Specifies which headers are allowed in a preflight <code>OPTIONS</code> request through the
         *        <code>Access-Control-Request-Headers</code> header. Each header name that is specified in
         *        <code>Access-Control-Request-Headers</code> must have a corresponding entry in the rule. Only the
         *        headers that were requested are sent back. </p>
         *        <p>
         *        This element can contain only one wildcard character (*).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedHeaders(Collection<String> allowedHeaders);

        /**
         * <p>
         * Specifies which headers are allowed in a preflight <code>OPTIONS</code> request through the
         * <code>Access-Control-Request-Headers</code> header. Each header name that is specified in
         * <code>Access-Control-Request-Headers</code> must have a corresponding entry in the rule. Only the headers
         * that were requested are sent back.
         * </p>
         * <p>
         * This element can contain only one wildcard character (*).
         * </p>
         * 
         * @param allowedHeaders
         *        Specifies which headers are allowed in a preflight <code>OPTIONS</code> request through the
         *        <code>Access-Control-Request-Headers</code> header. Each header name that is specified in
         *        <code>Access-Control-Request-Headers</code> must have a corresponding entry in the rule. Only the
         *        headers that were requested are sent back. </p>
         *        <p>
         *        This element can contain only one wildcard character (*).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedHeaders(String... allowedHeaders);

        /**
         * <p>
         * The time in seconds that your browser caches the preflight response for the specified resource.
         * </p>
         * <p>
         * A CORS rule can have only one <code>MaxAgeSeconds</code> element.
         * </p>
         * 
         * @param maxAgeSeconds
         *        The time in seconds that your browser caches the preflight response for the specified resource.</p>
         *        <p>
         *        A CORS rule can have only one <code>MaxAgeSeconds</code> element.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxAgeSeconds(Integer maxAgeSeconds);

        /**
         * <p>
         * One or more headers in the response that you want users to be able to access from their applications (for
         * example, from a JavaScript <code>XMLHttpRequest</code> object).
         * </p>
         * <p>
         * This element is optional for each rule.
         * </p>
         * 
         * @param exposeHeaders
         *        One or more headers in the response that you want users to be able to access from their applications
         *        (for example, from a JavaScript <code>XMLHttpRequest</code> object).</p>
         *        <p>
         *        This element is optional for each rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exposeHeaders(Collection<String> exposeHeaders);

        /**
         * <p>
         * One or more headers in the response that you want users to be able to access from their applications (for
         * example, from a JavaScript <code>XMLHttpRequest</code> object).
         * </p>
         * <p>
         * This element is optional for each rule.
         * </p>
         * 
         * @param exposeHeaders
         *        One or more headers in the response that you want users to be able to access from their applications
         *        (for example, from a JavaScript <code>XMLHttpRequest</code> object).</p>
         *        <p>
         *        This element is optional for each rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exposeHeaders(String... exposeHeaders);
    }

    static final class BuilderImpl implements Builder {
        private List<String> allowedOrigins = DefaultSdkAutoConstructList.getInstance();

        private List<String> allowedMethods = DefaultSdkAutoConstructList.getInstance();

        private List<String> allowedHeaders = DefaultSdkAutoConstructList.getInstance();

        private Integer maxAgeSeconds;

        private List<String> exposeHeaders = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CorsRule model) {
            allowedOrigins(model.allowedOrigins);
            allowedMethodsWithStrings(model.allowedMethods);
            allowedHeaders(model.allowedHeaders);
            maxAgeSeconds(model.maxAgeSeconds);
            exposeHeaders(model.exposeHeaders);
        }

        public final Collection<String> getAllowedOrigins() {
            if (allowedOrigins instanceof SdkAutoConstructList) {
                return null;
            }
            return allowedOrigins;
        }

        @Override
        public final Builder allowedOrigins(Collection<String> allowedOrigins) {
            this.allowedOrigins = AllowedOriginsCopier.copy(allowedOrigins);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowedOrigins(String... allowedOrigins) {
            allowedOrigins(Arrays.asList(allowedOrigins));
            return this;
        }

        public final void setAllowedOrigins(Collection<String> allowedOrigins) {
            this.allowedOrigins = AllowedOriginsCopier.copy(allowedOrigins);
        }

        public final Collection<String> getAllowedMethods() {
            if (allowedMethods instanceof SdkAutoConstructList) {
                return null;
            }
            return allowedMethods;
        }

        @Override
        public final Builder allowedMethodsWithStrings(Collection<String> allowedMethods) {
            this.allowedMethods = AllowedMethodsCopier.copy(allowedMethods);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowedMethodsWithStrings(String... allowedMethods) {
            allowedMethodsWithStrings(Arrays.asList(allowedMethods));
            return this;
        }

        @Override
        public final Builder allowedMethods(Collection<MethodName> allowedMethods) {
            this.allowedMethods = AllowedMethodsCopier.copyEnumToString(allowedMethods);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowedMethods(MethodName... allowedMethods) {
            allowedMethods(Arrays.asList(allowedMethods));
            return this;
        }

        public final void setAllowedMethods(Collection<String> allowedMethods) {
            this.allowedMethods = AllowedMethodsCopier.copy(allowedMethods);
        }

        public final Collection<String> getAllowedHeaders() {
            if (allowedHeaders instanceof SdkAutoConstructList) {
                return null;
            }
            return allowedHeaders;
        }

        @Override
        public final Builder allowedHeaders(Collection<String> allowedHeaders) {
            this.allowedHeaders = AllowedHeadersCopier.copy(allowedHeaders);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowedHeaders(String... allowedHeaders) {
            allowedHeaders(Arrays.asList(allowedHeaders));
            return this;
        }

        public final void setAllowedHeaders(Collection<String> allowedHeaders) {
            this.allowedHeaders = AllowedHeadersCopier.copy(allowedHeaders);
        }

        public final Integer getMaxAgeSeconds() {
            return maxAgeSeconds;
        }

        @Override
        public final Builder maxAgeSeconds(Integer maxAgeSeconds) {
            this.maxAgeSeconds = maxAgeSeconds;
            return this;
        }

        public final void setMaxAgeSeconds(Integer maxAgeSeconds) {
            this.maxAgeSeconds = maxAgeSeconds;
        }

        public final Collection<String> getExposeHeaders() {
            if (exposeHeaders instanceof SdkAutoConstructList) {
                return null;
            }
            return exposeHeaders;
        }

        @Override
        public final Builder exposeHeaders(Collection<String> exposeHeaders) {
            this.exposeHeaders = ExposeHeadersCopier.copy(exposeHeaders);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder exposeHeaders(String... exposeHeaders) {
            exposeHeaders(Arrays.asList(exposeHeaders));
            return this;
        }

        public final void setExposeHeaders(Collection<String> exposeHeaders) {
            this.exposeHeaders = ExposeHeadersCopier.copy(exposeHeaders);
        }

        @Override
        public CorsRule build() {
            return new CorsRule(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
