/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediastore.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListContainersResponse extends MediaStoreResponse implements
        ToCopyableBuilder<ListContainersResponse.Builder, ListContainersResponse> {
    private static final SdkField<List<Container>> CONTAINERS_FIELD = SdkField
            .<List<Container>> builder(MarshallingType.LIST)
            .getter(getter(ListContainersResponse::containers))
            .setter(setter(Builder::containers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Containers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Container> builder(MarshallingType.SDK_POJO)
                                            .constructor(Container::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListContainersResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTAINERS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<Container> containers;

    private final String nextToken;

    private ListContainersResponse(BuilderImpl builder) {
        super(builder);
        this.containers = builder.containers;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the Containers property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasContainers() {
        return containers != null && !(containers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The names of the containers.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasContainers()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The names of the containers.
     */
    public List<Container> containers() {
        return containers;
    }

    /**
     * <p>
     * <code>NextToken</code> is the token to use in the next call to <code>ListContainers</code>. This token is
     * returned only if you included the <code>MaxResults</code> tag in the original command, and only if there are
     * still containers to return.
     * </p>
     * 
     * @return <code>NextToken</code> is the token to use in the next call to <code>ListContainers</code>. This token is
     *         returned only if you included the <code>MaxResults</code> tag in the original command, and only if there
     *         are still containers to return.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(containers());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListContainersResponse)) {
            return false;
        }
        ListContainersResponse other = (ListContainersResponse) obj;
        return Objects.equals(containers(), other.containers()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListContainersResponse").add("Containers", containers()).add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Containers":
            return Optional.ofNullable(clazz.cast(containers()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListContainersResponse, T> g) {
        return obj -> g.apply((ListContainersResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MediaStoreResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListContainersResponse> {
        /**
         * <p>
         * The names of the containers.
         * </p>
         * 
         * @param containers
         *        The names of the containers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder containers(Collection<Container> containers);

        /**
         * <p>
         * The names of the containers.
         * </p>
         * 
         * @param containers
         *        The names of the containers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder containers(Container... containers);

        /**
         * <p>
         * The names of the containers.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Container>.Builder} avoiding the need to
         * create one manually via {@link List<Container>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Container>.Builder#build()} is called immediately and its
         * result is passed to {@link #containers(List<Container>)}.
         * 
         * @param containers
         *        a consumer that will call methods on {@link List<Container>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #containers(List<Container>)
         */
        Builder containers(Consumer<Container.Builder>... containers);

        /**
         * <p>
         * <code>NextToken</code> is the token to use in the next call to <code>ListContainers</code>. This token is
         * returned only if you included the <code>MaxResults</code> tag in the original command, and only if there are
         * still containers to return.
         * </p>
         * 
         * @param nextToken
         *        <code>NextToken</code> is the token to use in the next call to <code>ListContainers</code>. This token
         *        is returned only if you included the <code>MaxResults</code> tag in the original command, and only if
         *        there are still containers to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends MediaStoreResponse.BuilderImpl implements Builder {
        private List<Container> containers = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListContainersResponse model) {
            super(model);
            containers(model.containers);
            nextToken(model.nextToken);
        }

        public final Collection<Container.Builder> getContainers() {
            return containers != null ? containers.stream().map(Container::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder containers(Collection<Container> containers) {
            this.containers = ContainerListCopier.copy(containers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder containers(Container... containers) {
            containers(Arrays.asList(containers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder containers(Consumer<Container.Builder>... containers) {
            containers(Stream.of(containers).map(c -> Container.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setContainers(Collection<Container.BuilderImpl> containers) {
            this.containers = ContainerListCopier.copyFromBuilder(containers);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListContainersResponse build() {
            return new ListContainersResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
