/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediastore.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateContainerResponse extends MediaStoreResponse implements
        ToCopyableBuilder<CreateContainerResponse.Builder, CreateContainerResponse> {
    private static final SdkField<Container> CONTAINER_FIELD = SdkField.<Container> builder(MarshallingType.SDK_POJO)
            .getter(getter(CreateContainerResponse::container)).setter(setter(Builder::container))
            .constructor(Container::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Container").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTAINER_FIELD));

    private final Container container;

    private CreateContainerResponse(BuilderImpl builder) {
        super(builder);
        this.container = builder.container;
    }

    /**
     * <p>
     * ContainerARN: The Amazon Resource Name (ARN) of the newly created container. The ARN has the following format:
     * arn:aws:&lt;region&gt;:&lt;account that owns this container&gt;:container/&lt;name of container&gt;. For example:
     * arn:aws:mediastore:us-west-2:111122223333:container/movies
     * </p>
     * <p>
     * ContainerName: The container name as specified in the request.
     * </p>
     * <p>
     * CreationTime: Unix time stamp.
     * </p>
     * <p>
     * Status: The status of container creation or deletion. The status is one of the following: <code>CREATING</code>,
     * <code>ACTIVE</code>, or <code>DELETING</code>. While the service is creating the container, the status is
     * <code>CREATING</code>. When an endpoint is available, the status changes to <code>ACTIVE</code>.
     * </p>
     * <p>
     * The return value does not include the container's endpoint. To make downstream requests, you must obtain this
     * value by using <a>DescribeContainer</a> or <a>ListContainers</a>.
     * </p>
     * 
     * @return ContainerARN: The Amazon Resource Name (ARN) of the newly created container. The ARN has the following
     *         format: arn:aws:&lt;region&gt;:&lt;account that owns this container&gt;:container/&lt;name of
     *         container&gt;. For example: arn:aws:mediastore:us-west-2:111122223333:container/movies </p>
     *         <p>
     *         ContainerName: The container name as specified in the request.
     *         </p>
     *         <p>
     *         CreationTime: Unix time stamp.
     *         </p>
     *         <p>
     *         Status: The status of container creation or deletion. The status is one of the following:
     *         <code>CREATING</code>, <code>ACTIVE</code>, or <code>DELETING</code>. While the service is creating the
     *         container, the status is <code>CREATING</code>. When an endpoint is available, the status changes to
     *         <code>ACTIVE</code>.
     *         </p>
     *         <p>
     *         The return value does not include the container's endpoint. To make downstream requests, you must obtain
     *         this value by using <a>DescribeContainer</a> or <a>ListContainers</a>.
     */
    public Container container() {
        return container;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(container());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateContainerResponse)) {
            return false;
        }
        CreateContainerResponse other = (CreateContainerResponse) obj;
        return Objects.equals(container(), other.container());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateContainerResponse").add("Container", container()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Container":
            return Optional.ofNullable(clazz.cast(container()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateContainerResponse, T> g) {
        return obj -> g.apply((CreateContainerResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MediaStoreResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateContainerResponse> {
        /**
         * <p>
         * ContainerARN: The Amazon Resource Name (ARN) of the newly created container. The ARN has the following
         * format: arn:aws:&lt;region&gt;:&lt;account that owns this container&gt;:container/&lt;name of container&gt;.
         * For example: arn:aws:mediastore:us-west-2:111122223333:container/movies
         * </p>
         * <p>
         * ContainerName: The container name as specified in the request.
         * </p>
         * <p>
         * CreationTime: Unix time stamp.
         * </p>
         * <p>
         * Status: The status of container creation or deletion. The status is one of the following:
         * <code>CREATING</code>, <code>ACTIVE</code>, or <code>DELETING</code>. While the service is creating the
         * container, the status is <code>CREATING</code>. When an endpoint is available, the status changes to
         * <code>ACTIVE</code>.
         * </p>
         * <p>
         * The return value does not include the container's endpoint. To make downstream requests, you must obtain this
         * value by using <a>DescribeContainer</a> or <a>ListContainers</a>.
         * </p>
         * 
         * @param container
         *        ContainerARN: The Amazon Resource Name (ARN) of the newly created container. The ARN has the following
         *        format: arn:aws:&lt;region&gt;:&lt;account that owns this container&gt;:container/&lt;name of
         *        container&gt;. For example: arn:aws:mediastore:us-west-2:111122223333:container/movies </p>
         *        <p>
         *        ContainerName: The container name as specified in the request.
         *        </p>
         *        <p>
         *        CreationTime: Unix time stamp.
         *        </p>
         *        <p>
         *        Status: The status of container creation or deletion. The status is one of the following:
         *        <code>CREATING</code>, <code>ACTIVE</code>, or <code>DELETING</code>. While the service is creating
         *        the container, the status is <code>CREATING</code>. When an endpoint is available, the status changes
         *        to <code>ACTIVE</code>.
         *        </p>
         *        <p>
         *        The return value does not include the container's endpoint. To make downstream requests, you must
         *        obtain this value by using <a>DescribeContainer</a> or <a>ListContainers</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder container(Container container);

        /**
         * <p>
         * ContainerARN: The Amazon Resource Name (ARN) of the newly created container. The ARN has the following
         * format: arn:aws:&lt;region&gt;:&lt;account that owns this container&gt;:container/&lt;name of container&gt;.
         * For example: arn:aws:mediastore:us-west-2:111122223333:container/movies
         * </p>
         * <p>
         * ContainerName: The container name as specified in the request.
         * </p>
         * <p>
         * CreationTime: Unix time stamp.
         * </p>
         * <p>
         * Status: The status of container creation or deletion. The status is one of the following:
         * <code>CREATING</code>, <code>ACTIVE</code>, or <code>DELETING</code>. While the service is creating the
         * container, the status is <code>CREATING</code>. When an endpoint is available, the status changes to
         * <code>ACTIVE</code>.
         * </p>
         * <p>
         * The return value does not include the container's endpoint. To make downstream requests, you must obtain this
         * value by using <a>DescribeContainer</a> or <a>ListContainers</a>.
         * </p>
         * This is a convenience that creates an instance of the {@link Container.Builder} avoiding the need to create
         * one manually via {@link Container#builder()}.
         *
         * When the {@link Consumer} completes, {@link Container.Builder#build()} is called immediately and its result
         * is passed to {@link #container(Container)}.
         * 
         * @param container
         *        a consumer that will call methods on {@link Container.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #container(Container)
         */
        default Builder container(Consumer<Container.Builder> container) {
            return container(Container.builder().applyMutation(container).build());
        }
    }

    static final class BuilderImpl extends MediaStoreResponse.BuilderImpl implements Builder {
        private Container container;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateContainerResponse model) {
            super(model);
            container(model.container);
        }

        public final Container.Builder getContainer() {
            return container != null ? container.toBuilder() : null;
        }

        @Override
        public final Builder container(Container container) {
            this.container = container;
            return this;
        }

        public final void setContainer(Container.BuilderImpl container) {
            this.container = container != null ? container.build() : null;
        }

        @Override
        public CreateContainerResponse build() {
            return new CreateContainerResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
