/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediastore.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.mediastore.model.ContainerLevelMetrics;
import software.amazon.awssdk.services.mediastore.model.MetricPolicyRule;
import software.amazon.awssdk.services.mediastore.model.MetricPolicyRulesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MetricPolicy
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MetricPolicy> {
    private static final SdkField<String> CONTAINER_LEVEL_METRICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(MetricPolicy.getter(MetricPolicy::containerLevelMetricsAsString)).setter(MetricPolicy.setter(Builder::containerLevelMetrics)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContainerLevelMetrics").build()}).build();
    private static final SdkField<List<MetricPolicyRule>> METRIC_POLICY_RULES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(MetricPolicy.getter(MetricPolicy::metricPolicyRules)).setter(MetricPolicy.setter(Builder::metricPolicyRules)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricPolicyRules").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MetricPolicyRule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTAINER_LEVEL_METRICS_FIELD, METRIC_POLICY_RULES_FIELD));
    private static final long serialVersionUID = 1L;
    private final String containerLevelMetrics;
    private final List<MetricPolicyRule> metricPolicyRules;

    private MetricPolicy(BuilderImpl builder) {
        this.containerLevelMetrics = builder.containerLevelMetrics;
        this.metricPolicyRules = builder.metricPolicyRules;
    }

    public ContainerLevelMetrics containerLevelMetrics() {
        return ContainerLevelMetrics.fromValue(this.containerLevelMetrics);
    }

    public String containerLevelMetricsAsString() {
        return this.containerLevelMetrics;
    }

    public boolean hasMetricPolicyRules() {
        return this.metricPolicyRules != null && !(this.metricPolicyRules instanceof SdkAutoConstructList);
    }

    public List<MetricPolicyRule> metricPolicyRules() {
        return this.metricPolicyRules;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.containerLevelMetricsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.metricPolicyRules());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MetricPolicy)) {
            return false;
        }
        MetricPolicy other = (MetricPolicy)obj;
        return Objects.equals(this.containerLevelMetricsAsString(), other.containerLevelMetricsAsString()) && Objects.equals(this.metricPolicyRules(), other.metricPolicyRules());
    }

    public String toString() {
        return ToString.builder((String)"MetricPolicy").add("ContainerLevelMetrics", (Object)this.containerLevelMetricsAsString()).add("MetricPolicyRules", this.metricPolicyRules()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ContainerLevelMetrics": {
                return Optional.ofNullable(clazz.cast(this.containerLevelMetricsAsString()));
            }
            case "MetricPolicyRules": {
                return Optional.ofNullable(clazz.cast(this.metricPolicyRules()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MetricPolicy, T> g) {
        return obj -> g.apply((MetricPolicy)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String containerLevelMetrics;
        private List<MetricPolicyRule> metricPolicyRules = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(MetricPolicy model) {
            this.containerLevelMetrics(model.containerLevelMetrics);
            this.metricPolicyRules(model.metricPolicyRules);
        }

        public final String getContainerLevelMetrics() {
            return this.containerLevelMetrics;
        }

        @Override
        public final Builder containerLevelMetrics(String containerLevelMetrics) {
            this.containerLevelMetrics = containerLevelMetrics;
            return this;
        }

        @Override
        public final Builder containerLevelMetrics(ContainerLevelMetrics containerLevelMetrics) {
            this.containerLevelMetrics(containerLevelMetrics == null ? null : containerLevelMetrics.toString());
            return this;
        }

        public final void setContainerLevelMetrics(String containerLevelMetrics) {
            this.containerLevelMetrics = containerLevelMetrics;
        }

        public final Collection<MetricPolicyRule.Builder> getMetricPolicyRules() {
            return this.metricPolicyRules != null ? (Collection)this.metricPolicyRules.stream().map(MetricPolicyRule::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder metricPolicyRules(Collection<MetricPolicyRule> metricPolicyRules) {
            this.metricPolicyRules = MetricPolicyRulesCopier.copy(metricPolicyRules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricPolicyRules(MetricPolicyRule ... metricPolicyRules) {
            this.metricPolicyRules(Arrays.asList(metricPolicyRules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricPolicyRules(Consumer<MetricPolicyRule.Builder> ... metricPolicyRules) {
            this.metricPolicyRules(Stream.of(metricPolicyRules).map(c -> (MetricPolicyRule)((MetricPolicyRule.Builder)MetricPolicyRule.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setMetricPolicyRules(Collection<MetricPolicyRule.BuilderImpl> metricPolicyRules) {
            this.metricPolicyRules = MetricPolicyRulesCopier.copyFromBuilder(metricPolicyRules);
        }

        public MetricPolicy build() {
            return new MetricPolicy(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MetricPolicy> {
        public Builder containerLevelMetrics(String var1);

        public Builder containerLevelMetrics(ContainerLevelMetrics var1);

        public Builder metricPolicyRules(Collection<MetricPolicyRule> var1);

        public Builder metricPolicyRules(MetricPolicyRule ... var1);

        public Builder metricPolicyRules(Consumer<MetricPolicyRule.Builder> ... var1);
    }
}

