/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediastore.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetLifecyclePolicyResponse extends MediaStoreResponse implements
        ToCopyableBuilder<GetLifecyclePolicyResponse.Builder, GetLifecyclePolicyResponse> {
    private static final SdkField<String> LIFECYCLE_POLICY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetLifecyclePolicyResponse::lifecyclePolicy)).setter(setter(Builder::lifecyclePolicy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LifecyclePolicy").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LIFECYCLE_POLICY_FIELD));

    private final String lifecyclePolicy;

    private GetLifecyclePolicyResponse(BuilderImpl builder) {
        super(builder);
        this.lifecyclePolicy = builder.lifecyclePolicy;
    }

    /**
     * <p>
     * The object lifecycle policy that is assigned to the container.
     * </p>
     * 
     * @return The object lifecycle policy that is assigned to the container.
     */
    public String lifecyclePolicy() {
        return lifecyclePolicy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(lifecyclePolicy());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetLifecyclePolicyResponse)) {
            return false;
        }
        GetLifecyclePolicyResponse other = (GetLifecyclePolicyResponse) obj;
        return Objects.equals(lifecyclePolicy(), other.lifecyclePolicy());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetLifecyclePolicyResponse").add("LifecyclePolicy", lifecyclePolicy()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LifecyclePolicy":
            return Optional.ofNullable(clazz.cast(lifecyclePolicy()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetLifecyclePolicyResponse, T> g) {
        return obj -> g.apply((GetLifecyclePolicyResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MediaStoreResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetLifecyclePolicyResponse> {
        /**
         * <p>
         * The object lifecycle policy that is assigned to the container.
         * </p>
         * 
         * @param lifecyclePolicy
         *        The object lifecycle policy that is assigned to the container.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lifecyclePolicy(String lifecyclePolicy);
    }

    static final class BuilderImpl extends MediaStoreResponse.BuilderImpl implements Builder {
        private String lifecyclePolicy;

        private BuilderImpl() {
        }

        private BuilderImpl(GetLifecyclePolicyResponse model) {
            super(model);
            lifecyclePolicy(model.lifecyclePolicy);
        }

        public final String getLifecyclePolicy() {
            return lifecyclePolicy;
        }

        @Override
        public final Builder lifecyclePolicy(String lifecyclePolicy) {
            this.lifecyclePolicy = lifecyclePolicy;
            return this;
        }

        public final void setLifecyclePolicy(String lifecyclePolicy) {
            this.lifecyclePolicy = lifecyclePolicy;
        }

        @Override
        public GetLifecyclePolicyResponse build() {
            return new GetLifecyclePolicyResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
