/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediastore.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.protocol.OperationInfo;
import software.amazon.awssdk.core.protocol.Protocol;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.ProtocolRequestMarshaller;
import software.amazon.awssdk.core.protocol.json.SdkJsonProtocolFactory;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.services.mediastore.model.DescribeContainerRequest;
import software.amazon.awssdk.services.mediastore.transform.DescribeContainerRequestModelMarshaller;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class DescribeContainerRequestMarshaller
implements Marshaller<Request<DescribeContainerRequest>, DescribeContainerRequest> {
    private static final OperationInfo SDK_OPERATION_BINDING = OperationInfo.builder().protocol(Protocol.AWS_JSON).requestUri("/").httpMethodName(HttpMethodName.POST).hasExplicitPayloadMember(false).hasPayloadMembers(true).operationIdentifier("MediaStore_20170901.DescribeContainer").serviceName("MediaStore").build();
    private final SdkJsonProtocolFactory protocolFactory;

    public DescribeContainerRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<DescribeContainerRequest> marshall(DescribeContainerRequest describeContainerRequest) {
        Validate.paramNotNull((Object)((Object)describeContainerRequest), (String)"describeContainerRequest");
        try {
            ProtocolRequestMarshaller protocolMarshaller = this.protocolFactory.createProtocolMarshaller(SDK_OPERATION_BINDING, (SdkRequest)describeContainerRequest);
            protocolMarshaller.startMarshalling();
            DescribeContainerRequestModelMarshaller.getInstance().marshall(describeContainerRequest, (ProtocolMarshaller)protocolMarshaller);
            return protocolMarshaller.finishMarshalling();
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

