/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediastore.transform;

import com.fasterxml.jackson.core.JsonToken;
import java.time.Instant;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.mediastore.model.Container;

public class ContainerUnmarshaller
implements Unmarshaller<Container, JsonUnmarshallerContext> {
    private static final ContainerUnmarshaller INSTANCE = new ContainerUnmarshaller();

    public Container unmarshall(JsonUnmarshallerContext context) throws Exception {
        Container.Builder containerBuilder = Container.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("Endpoint", targetDepth)) {
                    context.nextToken();
                    containerBuilder.endpoint((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("CreationTime", targetDepth)) {
                    context.nextToken();
                    containerBuilder.creationTime((Instant)context.getUnmarshaller(Instant.class).unmarshall((Object)context));
                }
                if (context.testExpression("ARN", targetDepth)) {
                    context.nextToken();
                    containerBuilder.arn((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Name", targetDepth)) {
                    context.nextToken();
                    containerBuilder.name((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Status", targetDepth)) {
                    context.nextToken();
                    containerBuilder.status((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (Container)containerBuilder.build();
    }

    public static ContainerUnmarshaller getInstance() {
        return INSTANCE;
    }
}

