/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediastore.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.mediastore.model.Container;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ContainerMarshaller {
    private static final MarshallingInfo<String> ENDPOINT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Endpoint").isBinary(false).build();
    private static final MarshallingInfo<Instant> CREATIONTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreationTime").isBinary(false).build();
    private static final MarshallingInfo<String> ARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ARN").isBinary(false).build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").isBinary(false).build();
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Status").isBinary(false).build();
    private static final ContainerMarshaller INSTANCE = new ContainerMarshaller();

    private ContainerMarshaller() {
    }

    public static ContainerMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Container container, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)container, (String)"container");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)container.endpoint(), ENDPOINT_BINDING);
            protocolMarshaller.marshall((Object)container.creationTime(), CREATIONTIME_BINDING);
            protocolMarshaller.marshall((Object)container.arn(), ARN_BINDING);
            protocolMarshaller.marshall((Object)container.name(), NAME_BINDING);
            protocolMarshaller.marshall((Object)container.statusString(), STATUS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

