/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediastore.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.mediastore.model.MediaStoreRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class PutContainerPolicyRequest
extends MediaStoreRequest
implements ToCopyableBuilder<Builder, PutContainerPolicyRequest> {
    private final String containerName;
    private final String policy;

    private PutContainerPolicyRequest(BuilderImpl builder) {
        super(builder);
        this.containerName = builder.containerName;
        this.policy = builder.policy;
    }

    public String containerName() {
        return this.containerName;
    }

    public String policy() {
        return this.policy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.containerName());
        hashCode = 31 * hashCode + Objects.hashCode(this.policy());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutContainerPolicyRequest)) {
            return false;
        }
        PutContainerPolicyRequest other = (PutContainerPolicyRequest)((Object)obj);
        return Objects.equals(this.containerName(), other.containerName()) && Objects.equals(this.policy(), other.policy());
    }

    public String toString() {
        return ToString.builder((String)"PutContainerPolicyRequest").add("ContainerName", (Object)this.containerName()).add("Policy", (Object)this.policy()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ContainerName": {
                return Optional.of(clazz.cast(this.containerName()));
            }
            case "Policy": {
                return Optional.of(clazz.cast(this.policy()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends MediaStoreRequest.BuilderImpl
    implements Builder {
        private String containerName;
        private String policy;

        private BuilderImpl() {
        }

        private BuilderImpl(PutContainerPolicyRequest model) {
            this.containerName(model.containerName);
            this.policy(model.policy);
        }

        public final String getContainerName() {
            return this.containerName;
        }

        @Override
        public final Builder containerName(String containerName) {
            this.containerName = containerName;
            return this;
        }

        public final void setContainerName(String containerName) {
            this.containerName = containerName;
        }

        public final String getPolicy() {
            return this.policy;
        }

        @Override
        public final Builder policy(String policy) {
            this.policy = policy;
            return this;
        }

        public final void setPolicy(String policy) {
            this.policy = policy;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public PutContainerPolicyRequest build() {
            return new PutContainerPolicyRequest(this);
        }
    }

    public static interface Builder
    extends MediaStoreRequest.Builder,
    CopyableBuilder<Builder, PutContainerPolicyRequest> {
        public Builder containerName(String var1);

        public Builder policy(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

