/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediastore;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.ClientExecutionParams;
import software.amazon.awssdk.core.client.ClientHandler;
import software.amazon.awssdk.core.client.SdkClientHandler;
import software.amazon.awssdk.core.config.ClientConfiguration;
import software.amazon.awssdk.core.config.SyncClientConfiguration;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.exception.SdkServiceException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.protocol.json.JsonClientMetadata;
import software.amazon.awssdk.core.protocol.json.JsonErrorResponseMetadata;
import software.amazon.awssdk.core.protocol.json.JsonErrorShapeMetadata;
import software.amazon.awssdk.core.protocol.json.JsonOperationMetadata;
import software.amazon.awssdk.core.protocol.json.SdkJsonProtocolFactory;
import software.amazon.awssdk.core.runtime.http.response.JsonResponseHandler;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.mediastore.MediaStoreClient;
import software.amazon.awssdk.services.mediastore.model.ContainerInUseException;
import software.amazon.awssdk.services.mediastore.model.ContainerNotFoundException;
import software.amazon.awssdk.services.mediastore.model.CreateContainerRequest;
import software.amazon.awssdk.services.mediastore.model.CreateContainerResponse;
import software.amazon.awssdk.services.mediastore.model.DeleteContainerPolicyRequest;
import software.amazon.awssdk.services.mediastore.model.DeleteContainerPolicyResponse;
import software.amazon.awssdk.services.mediastore.model.DeleteContainerRequest;
import software.amazon.awssdk.services.mediastore.model.DeleteContainerResponse;
import software.amazon.awssdk.services.mediastore.model.DescribeContainerRequest;
import software.amazon.awssdk.services.mediastore.model.DescribeContainerResponse;
import software.amazon.awssdk.services.mediastore.model.GetContainerPolicyRequest;
import software.amazon.awssdk.services.mediastore.model.GetContainerPolicyResponse;
import software.amazon.awssdk.services.mediastore.model.InternalServerErrorException;
import software.amazon.awssdk.services.mediastore.model.LimitExceededException;
import software.amazon.awssdk.services.mediastore.model.ListContainersRequest;
import software.amazon.awssdk.services.mediastore.model.ListContainersResponse;
import software.amazon.awssdk.services.mediastore.model.MediaStoreException;
import software.amazon.awssdk.services.mediastore.model.PolicyNotFoundException;
import software.amazon.awssdk.services.mediastore.model.PutContainerPolicyRequest;
import software.amazon.awssdk.services.mediastore.model.PutContainerPolicyResponse;
import software.amazon.awssdk.services.mediastore.transform.CreateContainerRequestMarshaller;
import software.amazon.awssdk.services.mediastore.transform.CreateContainerResponseUnmarshaller;
import software.amazon.awssdk.services.mediastore.transform.DeleteContainerPolicyRequestMarshaller;
import software.amazon.awssdk.services.mediastore.transform.DeleteContainerPolicyResponseUnmarshaller;
import software.amazon.awssdk.services.mediastore.transform.DeleteContainerRequestMarshaller;
import software.amazon.awssdk.services.mediastore.transform.DeleteContainerResponseUnmarshaller;
import software.amazon.awssdk.services.mediastore.transform.DescribeContainerRequestMarshaller;
import software.amazon.awssdk.services.mediastore.transform.DescribeContainerResponseUnmarshaller;
import software.amazon.awssdk.services.mediastore.transform.GetContainerPolicyRequestMarshaller;
import software.amazon.awssdk.services.mediastore.transform.GetContainerPolicyResponseUnmarshaller;
import software.amazon.awssdk.services.mediastore.transform.ListContainersRequestMarshaller;
import software.amazon.awssdk.services.mediastore.transform.ListContainersResponseUnmarshaller;
import software.amazon.awssdk.services.mediastore.transform.PutContainerPolicyRequestMarshaller;
import software.amazon.awssdk.services.mediastore.transform.PutContainerPolicyResponseUnmarshaller;

@SdkInternalApi
final class DefaultMediaStoreClient
implements MediaStoreClient {
    private final ClientHandler clientHandler;
    private final SdkJsonProtocolFactory protocolFactory;
    private final ClientConfiguration clientConfiguration;

    protected DefaultMediaStoreClient(SyncClientConfiguration clientConfiguration) {
        this.clientHandler = new SdkClientHandler(clientConfiguration, null);
        this.protocolFactory = this.init();
        this.clientConfiguration = clientConfiguration;
    }

    public final String serviceName() {
        return "mediastore";
    }

    @Override
    public CreateContainerResponse createContainer(CreateContainerRequest createContainerRequest) throws ContainerInUseException, LimitExceededException, InternalServerErrorException, SdkServiceException, SdkClientException, MediaStoreException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateContainerResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (CreateContainerResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createContainerRequest).withMarshaller((Marshaller)new CreateContainerRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DeleteContainerResponse deleteContainer(DeleteContainerRequest deleteContainerRequest) throws ContainerInUseException, ContainerNotFoundException, InternalServerErrorException, SdkServiceException, SdkClientException, MediaStoreException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteContainerResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (DeleteContainerResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteContainerRequest).withMarshaller((Marshaller)new DeleteContainerRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DeleteContainerPolicyResponse deleteContainerPolicy(DeleteContainerPolicyRequest deleteContainerPolicyRequest) throws ContainerInUseException, ContainerNotFoundException, PolicyNotFoundException, InternalServerErrorException, SdkServiceException, SdkClientException, MediaStoreException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteContainerPolicyResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (DeleteContainerPolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteContainerPolicyRequest).withMarshaller((Marshaller)new DeleteContainerPolicyRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeContainerResponse describeContainer(DescribeContainerRequest describeContainerRequest) throws ContainerNotFoundException, InternalServerErrorException, SdkServiceException, SdkClientException, MediaStoreException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeContainerResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (DescribeContainerResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeContainerRequest).withMarshaller((Marshaller)new DescribeContainerRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public GetContainerPolicyResponse getContainerPolicy(GetContainerPolicyRequest getContainerPolicyRequest) throws ContainerInUseException, ContainerNotFoundException, PolicyNotFoundException, InternalServerErrorException, SdkServiceException, SdkClientException, MediaStoreException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetContainerPolicyResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (GetContainerPolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getContainerPolicyRequest).withMarshaller((Marshaller)new GetContainerPolicyRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ListContainersResponse listContainers(ListContainersRequest listContainersRequest) throws InternalServerErrorException, SdkServiceException, SdkClientException, MediaStoreException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListContainersResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (ListContainersResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listContainersRequest).withMarshaller((Marshaller)new ListContainersRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public PutContainerPolicyResponse putContainerPolicy(PutContainerPolicyRequest putContainerPolicyRequest) throws ContainerNotFoundException, ContainerInUseException, InternalServerErrorException, SdkServiceException, SdkClientException, MediaStoreException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new PutContainerPolicyResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (PutContainerPolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)putContainerPolicyRequest).withMarshaller((Marshaller)new PutContainerPolicyRequestMarshaller(this.protocolFactory)));
    }

    private HttpResponseHandler<SdkServiceException> createErrorResponseHandler() {
        return this.protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
    }

    private SdkJsonProtocolFactory init() {
        return new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).withBaseServiceExceptionClass(MediaStoreException.class).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ContainerInUseException").withModeledClass(ContainerInUseException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("PolicyNotFoundException").withModeledClass(PolicyNotFoundException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InternalServerError").withModeledClass(InternalServerErrorException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("LimitExceededException").withModeledClass(LimitExceededException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ContainerNotFoundException").withModeledClass(ContainerNotFoundException.class)));
    }

    public void close() {
        this.clientHandler.close();
    }
}

