/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediapackagevod.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EgressEndpoint
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EgressEndpoint> {
    private static final SdkField<String> PACKAGING_CONFIGURATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(EgressEndpoint.getter(EgressEndpoint::packagingConfigurationId)).setter(EgressEndpoint.setter(Builder::packagingConfigurationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("packagingConfigurationId").build()}).build();
    private static final SdkField<String> URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(EgressEndpoint.getter(EgressEndpoint::url)).setter(EgressEndpoint.setter(Builder::url)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("url").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PACKAGING_CONFIGURATION_ID_FIELD, URL_FIELD));
    private static final long serialVersionUID = 1L;
    private final String packagingConfigurationId;
    private final String url;

    private EgressEndpoint(BuilderImpl builder) {
        this.packagingConfigurationId = builder.packagingConfigurationId;
        this.url = builder.url;
    }

    public String packagingConfigurationId() {
        return this.packagingConfigurationId;
    }

    public String url() {
        return this.url;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.packagingConfigurationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.url());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EgressEndpoint)) {
            return false;
        }
        EgressEndpoint other = (EgressEndpoint)obj;
        return Objects.equals(this.packagingConfigurationId(), other.packagingConfigurationId()) && Objects.equals(this.url(), other.url());
    }

    public String toString() {
        return ToString.builder((String)"EgressEndpoint").add("PackagingConfigurationId", (Object)this.packagingConfigurationId()).add("Url", (Object)this.url()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PackagingConfigurationId": {
                return Optional.ofNullable(clazz.cast(this.packagingConfigurationId()));
            }
            case "Url": {
                return Optional.ofNullable(clazz.cast(this.url()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EgressEndpoint, T> g) {
        return obj -> g.apply((EgressEndpoint)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String packagingConfigurationId;
        private String url;

        private BuilderImpl() {
        }

        private BuilderImpl(EgressEndpoint model) {
            this.packagingConfigurationId(model.packagingConfigurationId);
            this.url(model.url);
        }

        public final String getPackagingConfigurationId() {
            return this.packagingConfigurationId;
        }

        @Override
        public final Builder packagingConfigurationId(String packagingConfigurationId) {
            this.packagingConfigurationId = packagingConfigurationId;
            return this;
        }

        public final void setPackagingConfigurationId(String packagingConfigurationId) {
            this.packagingConfigurationId = packagingConfigurationId;
        }

        public final String getUrl() {
            return this.url;
        }

        @Override
        public final Builder url(String url) {
            this.url = url;
            return this;
        }

        public final void setUrl(String url) {
            this.url = url;
        }

        public EgressEndpoint build() {
            return new EgressEndpoint(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EgressEndpoint> {
        public Builder packagingConfigurationId(String var1);

        public Builder url(String var1);
    }
}

