/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediapackagevod.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mediapackagevod.model.CmafPackage;
import software.amazon.awssdk.services.mediapackagevod.model.DashPackage;
import software.amazon.awssdk.services.mediapackagevod.model.HlsPackage;
import software.amazon.awssdk.services.mediapackagevod.model.MediaPackageVodResponse;
import software.amazon.awssdk.services.mediapackagevod.model.MssPackage;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreatePackagingConfigurationResponse
extends MediaPackageVodResponse
implements ToCopyableBuilder<Builder, CreatePackagingConfigurationResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreatePackagingConfigurationResponse.getter(CreatePackagingConfigurationResponse::arn)).setter(CreatePackagingConfigurationResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<CmafPackage> CMAF_PACKAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(CreatePackagingConfigurationResponse.getter(CreatePackagingConfigurationResponse::cmafPackage)).setter(CreatePackagingConfigurationResponse.setter(Builder::cmafPackage)).constructor(CmafPackage::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cmafPackage").build()}).build();
    private static final SdkField<DashPackage> DASH_PACKAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(CreatePackagingConfigurationResponse.getter(CreatePackagingConfigurationResponse::dashPackage)).setter(CreatePackagingConfigurationResponse.setter(Builder::dashPackage)).constructor(DashPackage::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dashPackage").build()}).build();
    private static final SdkField<HlsPackage> HLS_PACKAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(CreatePackagingConfigurationResponse.getter(CreatePackagingConfigurationResponse::hlsPackage)).setter(CreatePackagingConfigurationResponse.setter(Builder::hlsPackage)).constructor(HlsPackage::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hlsPackage").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreatePackagingConfigurationResponse.getter(CreatePackagingConfigurationResponse::id)).setter(CreatePackagingConfigurationResponse.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<MssPackage> MSS_PACKAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(CreatePackagingConfigurationResponse.getter(CreatePackagingConfigurationResponse::mssPackage)).setter(CreatePackagingConfigurationResponse.setter(Builder::mssPackage)).constructor(MssPackage::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mssPackage").build()}).build();
    private static final SdkField<String> PACKAGING_GROUP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreatePackagingConfigurationResponse.getter(CreatePackagingConfigurationResponse::packagingGroupId)).setter(CreatePackagingConfigurationResponse.setter(Builder::packagingGroupId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("packagingGroupId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, CMAF_PACKAGE_FIELD, DASH_PACKAGE_FIELD, HLS_PACKAGE_FIELD, ID_FIELD, MSS_PACKAGE_FIELD, PACKAGING_GROUP_ID_FIELD));
    private final String arn;
    private final CmafPackage cmafPackage;
    private final DashPackage dashPackage;
    private final HlsPackage hlsPackage;
    private final String id;
    private final MssPackage mssPackage;
    private final String packagingGroupId;

    private CreatePackagingConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.cmafPackage = builder.cmafPackage;
        this.dashPackage = builder.dashPackage;
        this.hlsPackage = builder.hlsPackage;
        this.id = builder.id;
        this.mssPackage = builder.mssPackage;
        this.packagingGroupId = builder.packagingGroupId;
    }

    public String arn() {
        return this.arn;
    }

    public CmafPackage cmafPackage() {
        return this.cmafPackage;
    }

    public DashPackage dashPackage() {
        return this.dashPackage;
    }

    public HlsPackage hlsPackage() {
        return this.hlsPackage;
    }

    public String id() {
        return this.id;
    }

    public MssPackage mssPackage() {
        return this.mssPackage;
    }

    public String packagingGroupId() {
        return this.packagingGroupId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.cmafPackage());
        hashCode = 31 * hashCode + Objects.hashCode(this.dashPackage());
        hashCode = 31 * hashCode + Objects.hashCode(this.hlsPackage());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.mssPackage());
        hashCode = 31 * hashCode + Objects.hashCode(this.packagingGroupId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreatePackagingConfigurationResponse)) {
            return false;
        }
        CreatePackagingConfigurationResponse other = (CreatePackagingConfigurationResponse)((Object)obj);
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.cmafPackage(), other.cmafPackage()) && Objects.equals(this.dashPackage(), other.dashPackage()) && Objects.equals(this.hlsPackage(), other.hlsPackage()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.mssPackage(), other.mssPackage()) && Objects.equals(this.packagingGroupId(), other.packagingGroupId());
    }

    public String toString() {
        return ToString.builder((String)"CreatePackagingConfigurationResponse").add("Arn", (Object)this.arn()).add("CmafPackage", (Object)this.cmafPackage()).add("DashPackage", (Object)this.dashPackage()).add("HlsPackage", (Object)this.hlsPackage()).add("Id", (Object)this.id()).add("MssPackage", (Object)this.mssPackage()).add("PackagingGroupId", (Object)this.packagingGroupId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "CmafPackage": {
                return Optional.ofNullable(clazz.cast(this.cmafPackage()));
            }
            case "DashPackage": {
                return Optional.ofNullable(clazz.cast(this.dashPackage()));
            }
            case "HlsPackage": {
                return Optional.ofNullable(clazz.cast(this.hlsPackage()));
            }
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "MssPackage": {
                return Optional.ofNullable(clazz.cast(this.mssPackage()));
            }
            case "PackagingGroupId": {
                return Optional.ofNullable(clazz.cast(this.packagingGroupId()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreatePackagingConfigurationResponse, T> g) {
        return obj -> g.apply((CreatePackagingConfigurationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MediaPackageVodResponse.BuilderImpl
    implements Builder {
        private String arn;
        private CmafPackage cmafPackage;
        private DashPackage dashPackage;
        private HlsPackage hlsPackage;
        private String id;
        private MssPackage mssPackage;
        private String packagingGroupId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreatePackagingConfigurationResponse model) {
            super(model);
            this.arn(model.arn);
            this.cmafPackage(model.cmafPackage);
            this.dashPackage(model.dashPackage);
            this.hlsPackage(model.hlsPackage);
            this.id(model.id);
            this.mssPackage(model.mssPackage);
            this.packagingGroupId(model.packagingGroupId);
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final CmafPackage.Builder getCmafPackage() {
            return this.cmafPackage != null ? this.cmafPackage.toBuilder() : null;
        }

        @Override
        public final Builder cmafPackage(CmafPackage cmafPackage) {
            this.cmafPackage = cmafPackage;
            return this;
        }

        public final void setCmafPackage(CmafPackage.BuilderImpl cmafPackage) {
            this.cmafPackage = cmafPackage != null ? cmafPackage.build() : null;
        }

        public final DashPackage.Builder getDashPackage() {
            return this.dashPackage != null ? this.dashPackage.toBuilder() : null;
        }

        @Override
        public final Builder dashPackage(DashPackage dashPackage) {
            this.dashPackage = dashPackage;
            return this;
        }

        public final void setDashPackage(DashPackage.BuilderImpl dashPackage) {
            this.dashPackage = dashPackage != null ? dashPackage.build() : null;
        }

        public final HlsPackage.Builder getHlsPackage() {
            return this.hlsPackage != null ? this.hlsPackage.toBuilder() : null;
        }

        @Override
        public final Builder hlsPackage(HlsPackage hlsPackage) {
            this.hlsPackage = hlsPackage;
            return this;
        }

        public final void setHlsPackage(HlsPackage.BuilderImpl hlsPackage) {
            this.hlsPackage = hlsPackage != null ? hlsPackage.build() : null;
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final MssPackage.Builder getMssPackage() {
            return this.mssPackage != null ? this.mssPackage.toBuilder() : null;
        }

        @Override
        public final Builder mssPackage(MssPackage mssPackage) {
            this.mssPackage = mssPackage;
            return this;
        }

        public final void setMssPackage(MssPackage.BuilderImpl mssPackage) {
            this.mssPackage = mssPackage != null ? mssPackage.build() : null;
        }

        public final String getPackagingGroupId() {
            return this.packagingGroupId;
        }

        @Override
        public final Builder packagingGroupId(String packagingGroupId) {
            this.packagingGroupId = packagingGroupId;
            return this;
        }

        public final void setPackagingGroupId(String packagingGroupId) {
            this.packagingGroupId = packagingGroupId;
        }

        @Override
        public CreatePackagingConfigurationResponse build() {
            return new CreatePackagingConfigurationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends MediaPackageVodResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreatePackagingConfigurationResponse> {
        public Builder arn(String var1);

        public Builder cmafPackage(CmafPackage var1);

        default public Builder cmafPackage(Consumer<CmafPackage.Builder> cmafPackage) {
            return this.cmafPackage((CmafPackage)((CmafPackage.Builder)CmafPackage.builder().applyMutation(cmafPackage)).build());
        }

        public Builder dashPackage(DashPackage var1);

        default public Builder dashPackage(Consumer<DashPackage.Builder> dashPackage) {
            return this.dashPackage((DashPackage)((DashPackage.Builder)DashPackage.builder().applyMutation(dashPackage)).build());
        }

        public Builder hlsPackage(HlsPackage var1);

        default public Builder hlsPackage(Consumer<HlsPackage.Builder> hlsPackage) {
            return this.hlsPackage((HlsPackage)((HlsPackage.Builder)HlsPackage.builder().applyMutation(hlsPackage)).build());
        }

        public Builder id(String var1);

        public Builder mssPackage(MssPackage var1);

        default public Builder mssPackage(Consumer<MssPackage.Builder> mssPackage) {
            return this.mssPackage((MssPackage)((MssPackage.Builder)MssPackage.builder().applyMutation(mssPackage)).build());
        }

        public Builder packagingGroupId(String var1);
    }
}

