/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediapackagevod.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mediapackagevod.model.MediaPackageVodRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListAssetsRequest
extends MediaPackageVodRequest
implements ToCopyableBuilder<Builder, ListAssetsRequest> {
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(ListAssetsRequest.getter(ListAssetsRequest::maxResults)).setter(ListAssetsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListAssetsRequest.getter(ListAssetsRequest::nextToken)).setter(ListAssetsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()}).build();
    private static final SdkField<String> PACKAGING_GROUP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListAssetsRequest.getter(ListAssetsRequest::packagingGroupId)).setter(ListAssetsRequest.setter(Builder::packagingGroupId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("packagingGroupId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, PACKAGING_GROUP_ID_FIELD));
    private final Integer maxResults;
    private final String nextToken;
    private final String packagingGroupId;

    private ListAssetsRequest(BuilderImpl builder) {
        super(builder);
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.packagingGroupId = builder.packagingGroupId;
    }

    public Integer maxResults() {
        return this.maxResults;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public String packagingGroupId() {
        return this.packagingGroupId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.packagingGroupId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAssetsRequest)) {
            return false;
        }
        ListAssetsRequest other = (ListAssetsRequest)((Object)obj);
        return Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.packagingGroupId(), other.packagingGroupId());
    }

    public String toString() {
        return ToString.builder((String)"ListAssetsRequest").add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).add("PackagingGroupId", (Object)this.packagingGroupId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "PackagingGroupId": {
                return Optional.ofNullable(clazz.cast(this.packagingGroupId()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListAssetsRequest, T> g) {
        return obj -> g.apply((ListAssetsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MediaPackageVodRequest.BuilderImpl
    implements Builder {
        private Integer maxResults;
        private String nextToken;
        private String packagingGroupId;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAssetsRequest model) {
            super(model);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
            this.packagingGroupId(model.packagingGroupId);
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final String getPackagingGroupId() {
            return this.packagingGroupId;
        }

        @Override
        public final Builder packagingGroupId(String packagingGroupId) {
            this.packagingGroupId = packagingGroupId;
            return this;
        }

        public final void setPackagingGroupId(String packagingGroupId) {
            this.packagingGroupId = packagingGroupId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListAssetsRequest build() {
            return new ListAssetsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends MediaPackageVodRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListAssetsRequest> {
        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder packagingGroupId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

