/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediapackagevod.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.mediapackagevod.MediaPackageVodClient;
import software.amazon.awssdk.services.mediapackagevod.internal.UserAgentUtils;
import software.amazon.awssdk.services.mediapackagevod.model.ListPackagingGroupsRequest;
import software.amazon.awssdk.services.mediapackagevod.model.ListPackagingGroupsResponse;
import software.amazon.awssdk.services.mediapackagevod.model.PackagingGroup;

public class ListPackagingGroupsIterable
implements SdkIterable<ListPackagingGroupsResponse> {
    private final MediaPackageVodClient client;
    private final ListPackagingGroupsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListPackagingGroupsIterable(MediaPackageVodClient client, ListPackagingGroupsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListPackagingGroupsResponseFetcher();
    }

    public Iterator<ListPackagingGroupsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<PackagingGroup> packagingGroups() {
        Function<ListPackagingGroupsResponse, Iterator> getIterator = response -> {
            if (response != null && response.packagingGroups() != null) {
                return response.packagingGroups().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListPackagingGroupsResponseFetcher
    implements SyncPageFetcher<ListPackagingGroupsResponse> {
        private ListPackagingGroupsResponseFetcher() {
        }

        public boolean hasNextPage(ListPackagingGroupsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListPackagingGroupsResponse nextPage(ListPackagingGroupsResponse previousPage) {
            if (previousPage == null) {
                return ListPackagingGroupsIterable.this.client.listPackagingGroups(ListPackagingGroupsIterable.this.firstRequest);
            }
            return ListPackagingGroupsIterable.this.client.listPackagingGroups((ListPackagingGroupsRequest)((Object)ListPackagingGroupsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

