/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediapackagevod.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.mediapackagevod.MediaPackageVodAsyncClient;
import software.amazon.awssdk.services.mediapackagevod.internal.UserAgentUtils;
import software.amazon.awssdk.services.mediapackagevod.model.ListPackagingConfigurationsRequest;
import software.amazon.awssdk.services.mediapackagevod.model.ListPackagingConfigurationsResponse;
import software.amazon.awssdk.services.mediapackagevod.model.PackagingConfiguration;

public class ListPackagingConfigurationsPublisher
implements SdkPublisher<ListPackagingConfigurationsResponse> {
    private final MediaPackageVodAsyncClient client;
    private final ListPackagingConfigurationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListPackagingConfigurationsPublisher(MediaPackageVodAsyncClient client, ListPackagingConfigurationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListPackagingConfigurationsPublisher(MediaPackageVodAsyncClient client, ListPackagingConfigurationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListPackagingConfigurationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListPackagingConfigurationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<PackagingConfiguration> packagingConfigurations() {
        Function<ListPackagingConfigurationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.packagingConfigurations() != null) {
                return response.packagingConfigurations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListPackagingConfigurationsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListPackagingConfigurationsResponseFetcher
    implements AsyncPageFetcher<ListPackagingConfigurationsResponse> {
        private ListPackagingConfigurationsResponseFetcher() {
        }

        public boolean hasNextPage(ListPackagingConfigurationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListPackagingConfigurationsResponse> nextPage(ListPackagingConfigurationsResponse previousPage) {
            if (previousPage == null) {
                return ListPackagingConfigurationsPublisher.this.client.listPackagingConfigurations(ListPackagingConfigurationsPublisher.this.firstRequest);
            }
            return ListPackagingConfigurationsPublisher.this.client.listPackagingConfigurations((ListPackagingConfigurationsRequest)((Object)ListPackagingConfigurationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

