/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediapackagevod;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.mediapackagevod.DefaultMediaPackageVodAsyncClient;
import software.amazon.awssdk.services.mediapackagevod.DefaultMediaPackageVodBaseClientBuilder;
import software.amazon.awssdk.services.mediapackagevod.MediaPackageVodAsyncClient;
import software.amazon.awssdk.services.mediapackagevod.MediaPackageVodAsyncClientBuilder;
import software.amazon.awssdk.services.mediapackagevod.MediaPackageVodServiceClientConfiguration;
import software.amazon.awssdk.services.mediapackagevod.endpoints.MediaPackageVodEndpointProvider;

@SdkInternalApi
final class DefaultMediaPackageVodAsyncClientBuilder
extends DefaultMediaPackageVodBaseClientBuilder<MediaPackageVodAsyncClientBuilder, MediaPackageVodAsyncClient>
implements MediaPackageVodAsyncClientBuilder {
    DefaultMediaPackageVodAsyncClientBuilder() {
    }

    @Override
    public DefaultMediaPackageVodAsyncClientBuilder endpointProvider(MediaPackageVodEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final MediaPackageVodAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultMediaPackageVodAsyncClientBuilder.validateClientOptions(clientConfiguration);
        MediaPackageVodServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultMediaPackageVodAsyncClient client = new DefaultMediaPackageVodAsyncClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private MediaPackageVodServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        if (Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return MediaPackageVodServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider((EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER)).build();
    }
}

