/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediapackagevod;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.mediapackagevod.DefaultMediaPackageVodBaseClientBuilder;
import software.amazon.awssdk.services.mediapackagevod.DefaultMediaPackageVodClient;
import software.amazon.awssdk.services.mediapackagevod.MediaPackageVodClient;
import software.amazon.awssdk.services.mediapackagevod.MediaPackageVodClientBuilder;
import software.amazon.awssdk.services.mediapackagevod.MediaPackageVodServiceClientConfiguration;
import software.amazon.awssdk.services.mediapackagevod.endpoints.MediaPackageVodEndpointProvider;

@SdkInternalApi
final class DefaultMediaPackageVodClientBuilder
extends DefaultMediaPackageVodBaseClientBuilder<MediaPackageVodClientBuilder, MediaPackageVodClient>
implements MediaPackageVodClientBuilder {
    DefaultMediaPackageVodClientBuilder() {
    }

    @Override
    public DefaultMediaPackageVodClientBuilder endpointProvider(MediaPackageVodEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final MediaPackageVodClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultMediaPackageVodClientBuilder.validateClientOptions(clientConfiguration);
        MediaPackageVodServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultMediaPackageVodClient client = new DefaultMediaPackageVodClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private MediaPackageVodServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        EndpointProvider endpointProvider = (EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER);
        if (clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return MediaPackageVodServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider(endpointProvider).build();
    }
}

