/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediapackagevod.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.mediapackagevod.model.EgressEndpoint;
import software.amazon.awssdk.services.mediapackagevod.model.MediaPackageVodResponse;
import software.amazon.awssdk.services.mediapackagevod.model.TagsCopier;
import software.amazon.awssdk.services.mediapackagevod.model.___listOfEgressEndpointCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeAssetResponse
extends MediaPackageVodResponse
implements ToCopyableBuilder<Builder, DescribeAssetResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(DescribeAssetResponse.getter(DescribeAssetResponse::arn)).setter(DescribeAssetResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CreatedAt").getter(DescribeAssetResponse.getter(DescribeAssetResponse::createdAt)).setter(DescribeAssetResponse.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()}).build();
    private static final SdkField<List<EgressEndpoint>> EGRESS_ENDPOINTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("EgressEndpoints").getter(DescribeAssetResponse.getter(DescribeAssetResponse::egressEndpoints)).setter(DescribeAssetResponse.setter(Builder::egressEndpoints)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("egressEndpoints").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EgressEndpoint::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(DescribeAssetResponse.getter(DescribeAssetResponse::id)).setter(DescribeAssetResponse.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> PACKAGING_GROUP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PackagingGroupId").getter(DescribeAssetResponse.getter(DescribeAssetResponse::packagingGroupId)).setter(DescribeAssetResponse.setter(Builder::packagingGroupId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("packagingGroupId").build()}).build();
    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceId").getter(DescribeAssetResponse.getter(DescribeAssetResponse::resourceId)).setter(DescribeAssetResponse.setter(Builder::resourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceId").build()}).build();
    private static final SdkField<String> SOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceArn").getter(DescribeAssetResponse.getter(DescribeAssetResponse::sourceArn)).setter(DescribeAssetResponse.setter(Builder::sourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceArn").build()}).build();
    private static final SdkField<String> SOURCE_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceRoleArn").getter(DescribeAssetResponse.getter(DescribeAssetResponse::sourceRoleArn)).setter(DescribeAssetResponse.setter(Builder::sourceRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceRoleArn").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(DescribeAssetResponse.getter(DescribeAssetResponse::tags)).setter(DescribeAssetResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, CREATED_AT_FIELD, EGRESS_ENDPOINTS_FIELD, ID_FIELD, PACKAGING_GROUP_ID_FIELD, RESOURCE_ID_FIELD, SOURCE_ARN_FIELD, SOURCE_ROLE_ARN_FIELD, TAGS_FIELD));
    private final String arn;
    private final String createdAt;
    private final List<EgressEndpoint> egressEndpoints;
    private final String id;
    private final String packagingGroupId;
    private final String resourceId;
    private final String sourceArn;
    private final String sourceRoleArn;
    private final Map<String, String> tags;

    private DescribeAssetResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.createdAt = builder.createdAt;
        this.egressEndpoints = builder.egressEndpoints;
        this.id = builder.id;
        this.packagingGroupId = builder.packagingGroupId;
        this.resourceId = builder.resourceId;
        this.sourceArn = builder.sourceArn;
        this.sourceRoleArn = builder.sourceRoleArn;
        this.tags = builder.tags;
    }

    public final String arn() {
        return this.arn;
    }

    public final String createdAt() {
        return this.createdAt;
    }

    public final boolean hasEgressEndpoints() {
        return this.egressEndpoints != null && !(this.egressEndpoints instanceof SdkAutoConstructList);
    }

    public final List<EgressEndpoint> egressEndpoints() {
        return this.egressEndpoints;
    }

    public final String id() {
        return this.id;
    }

    public final String packagingGroupId() {
        return this.packagingGroupId;
    }

    public final String resourceId() {
        return this.resourceId;
    }

    public final String sourceArn() {
        return this.sourceArn;
    }

    public final String sourceRoleArn() {
        return this.sourceRoleArn;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEgressEndpoints() ? this.egressEndpoints() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.packagingGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAssetResponse)) {
            return false;
        }
        DescribeAssetResponse other = (DescribeAssetResponse)((Object)obj);
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.createdAt(), other.createdAt()) && this.hasEgressEndpoints() == other.hasEgressEndpoints() && Objects.equals(this.egressEndpoints(), other.egressEndpoints()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.packagingGroupId(), other.packagingGroupId()) && Objects.equals(this.resourceId(), other.resourceId()) && Objects.equals(this.sourceArn(), other.sourceArn()) && Objects.equals(this.sourceRoleArn(), other.sourceRoleArn()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeAssetResponse").add("Arn", (Object)this.arn()).add("CreatedAt", (Object)this.createdAt()).add("EgressEndpoints", this.hasEgressEndpoints() ? this.egressEndpoints() : null).add("Id", (Object)this.id()).add("PackagingGroupId", (Object)this.packagingGroupId()).add("ResourceId", (Object)this.resourceId()).add("SourceArn", (Object)this.sourceArn()).add("SourceRoleArn", (Object)this.sourceRoleArn()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "CreatedAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "EgressEndpoints": {
                return Optional.ofNullable(clazz.cast(this.egressEndpoints()));
            }
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "PackagingGroupId": {
                return Optional.ofNullable(clazz.cast(this.packagingGroupId()));
            }
            case "ResourceId": {
                return Optional.ofNullable(clazz.cast(this.resourceId()));
            }
            case "SourceArn": {
                return Optional.ofNullable(clazz.cast(this.sourceArn()));
            }
            case "SourceRoleArn": {
                return Optional.ofNullable(clazz.cast(this.sourceRoleArn()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeAssetResponse, T> g) {
        return obj -> g.apply((DescribeAssetResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MediaPackageVodResponse.BuilderImpl
    implements Builder {
        private String arn;
        private String createdAt;
        private List<EgressEndpoint> egressEndpoints = DefaultSdkAutoConstructList.getInstance();
        private String id;
        private String packagingGroupId;
        private String resourceId;
        private String sourceArn;
        private String sourceRoleArn;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAssetResponse model) {
            super(model);
            this.arn(model.arn);
            this.createdAt(model.createdAt);
            this.egressEndpoints(model.egressEndpoints);
            this.id(model.id);
            this.packagingGroupId(model.packagingGroupId);
            this.resourceId(model.resourceId);
            this.sourceArn(model.sourceArn);
            this.sourceRoleArn(model.sourceRoleArn);
            this.tags(model.tags);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        @Transient
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(String createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        @Transient
        public final Builder createdAt(String createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final List<EgressEndpoint.Builder> getEgressEndpoints() {
            List<EgressEndpoint.Builder> result = ___listOfEgressEndpointCopier.copyToBuilder(this.egressEndpoints);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEgressEndpoints(Collection<EgressEndpoint.BuilderImpl> egressEndpoints) {
            this.egressEndpoints = ___listOfEgressEndpointCopier.copyFromBuilder(egressEndpoints);
        }

        @Override
        @Transient
        public final Builder egressEndpoints(Collection<EgressEndpoint> egressEndpoints) {
            this.egressEndpoints = ___listOfEgressEndpointCopier.copy(egressEndpoints);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder egressEndpoints(EgressEndpoint ... egressEndpoints) {
            this.egressEndpoints(Arrays.asList(egressEndpoints));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder egressEndpoints(Consumer<EgressEndpoint.Builder> ... egressEndpoints) {
            this.egressEndpoints(Stream.of(egressEndpoints).map(c -> (EgressEndpoint)((EgressEndpoint.Builder)EgressEndpoint.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        @Transient
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getPackagingGroupId() {
            return this.packagingGroupId;
        }

        public final void setPackagingGroupId(String packagingGroupId) {
            this.packagingGroupId = packagingGroupId;
        }

        @Override
        @Transient
        public final Builder packagingGroupId(String packagingGroupId) {
            this.packagingGroupId = packagingGroupId;
            return this;
        }

        public final String getResourceId() {
            return this.resourceId;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        @Override
        @Transient
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final String getSourceArn() {
            return this.sourceArn;
        }

        public final void setSourceArn(String sourceArn) {
            this.sourceArn = sourceArn;
        }

        @Override
        @Transient
        public final Builder sourceArn(String sourceArn) {
            this.sourceArn = sourceArn;
            return this;
        }

        public final String getSourceRoleArn() {
            return this.sourceRoleArn;
        }

        public final void setSourceRoleArn(String sourceRoleArn) {
            this.sourceRoleArn = sourceRoleArn;
        }

        @Override
        @Transient
        public final Builder sourceRoleArn(String sourceRoleArn) {
            this.sourceRoleArn = sourceRoleArn;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        @Transient
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        public DescribeAssetResponse build() {
            return new DescribeAssetResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends MediaPackageVodResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeAssetResponse> {
        public Builder arn(String var1);

        public Builder createdAt(String var1);

        public Builder egressEndpoints(Collection<EgressEndpoint> var1);

        public Builder egressEndpoints(EgressEndpoint ... var1);

        public Builder egressEndpoints(Consumer<EgressEndpoint.Builder> ... var1);

        public Builder id(String var1);

        public Builder packagingGroupId(String var1);

        public Builder resourceId(String var1);

        public Builder sourceArn(String var1);

        public Builder sourceRoleArn(String var1);

        public Builder tags(Map<String, String> var1);
    }
}

