/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediapackagevod.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum StreamOrder {
    ORIGINAL("ORIGINAL"),
    VIDEO_BITRATE_ASCENDING("VIDEO_BITRATE_ASCENDING"),
    VIDEO_BITRATE_DESCENDING("VIDEO_BITRATE_DESCENDING"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, StreamOrder> VALUE_MAP;
    private final String value;

    private StreamOrder(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static StreamOrder fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<StreamOrder> knownValues() {
        EnumSet<StreamOrder> knownValues = EnumSet.allOf(StreamOrder.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(StreamOrder.class, StreamOrder::toString);
    }
}

