/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediapackagevod.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * The endpoint URL used to access an Asset using one PackagingConfiguration.
 */
@Generated("software.amazon.awssdk:codegen")
public final class EgressEndpoint implements SdkPojo, Serializable, ToCopyableBuilder<EgressEndpoint.Builder, EgressEndpoint> {
    private static final SdkField<String> PACKAGING_CONFIGURATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PackagingConfigurationId").getter(getter(EgressEndpoint::packagingConfigurationId))
            .setter(setter(Builder::packagingConfigurationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("packagingConfigurationId").build())
            .build();

    private static final SdkField<String> URL_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Url")
            .getter(getter(EgressEndpoint::url)).setter(setter(Builder::url))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("url").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            PACKAGING_CONFIGURATION_ID_FIELD, URL_FIELD));

    private static final long serialVersionUID = 1L;

    private final String packagingConfigurationId;

    private final String url;

    private EgressEndpoint(BuilderImpl builder) {
        this.packagingConfigurationId = builder.packagingConfigurationId;
        this.url = builder.url;
    }

    /**
     * The ID of the PackagingConfiguration being applied to the Asset.
     * 
     * @return The ID of the PackagingConfiguration being applied to the Asset.
     */
    public final String packagingConfigurationId() {
        return packagingConfigurationId;
    }

    /**
     * The URL of the parent manifest for the repackaged Asset.
     * 
     * @return The URL of the parent manifest for the repackaged Asset.
     */
    public final String url() {
        return url;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(packagingConfigurationId());
        hashCode = 31 * hashCode + Objects.hashCode(url());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EgressEndpoint)) {
            return false;
        }
        EgressEndpoint other = (EgressEndpoint) obj;
        return Objects.equals(packagingConfigurationId(), other.packagingConfigurationId()) && Objects.equals(url(), other.url());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EgressEndpoint").add("PackagingConfigurationId", packagingConfigurationId()).add("Url", url())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PackagingConfigurationId":
            return Optional.ofNullable(clazz.cast(packagingConfigurationId()));
        case "Url":
            return Optional.ofNullable(clazz.cast(url()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EgressEndpoint, T> g) {
        return obj -> g.apply((EgressEndpoint) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EgressEndpoint> {
        /**
         * The ID of the PackagingConfiguration being applied to the Asset.
         * 
         * @param packagingConfigurationId
         *        The ID of the PackagingConfiguration being applied to the Asset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder packagingConfigurationId(String packagingConfigurationId);

        /**
         * The URL of the parent manifest for the repackaged Asset.
         * 
         * @param url
         *        The URL of the parent manifest for the repackaged Asset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder url(String url);
    }

    static final class BuilderImpl implements Builder {
        private String packagingConfigurationId;

        private String url;

        private BuilderImpl() {
        }

        private BuilderImpl(EgressEndpoint model) {
            packagingConfigurationId(model.packagingConfigurationId);
            url(model.url);
        }

        public final String getPackagingConfigurationId() {
            return packagingConfigurationId;
        }

        @Override
        public final Builder packagingConfigurationId(String packagingConfigurationId) {
            this.packagingConfigurationId = packagingConfigurationId;
            return this;
        }

        public final void setPackagingConfigurationId(String packagingConfigurationId) {
            this.packagingConfigurationId = packagingConfigurationId;
        }

        public final String getUrl() {
            return url;
        }

        @Override
        public final Builder url(String url) {
            this.url = url;
            return this;
        }

        public final void setUrl(String url) {
            this.url = url;
        }

        @Override
        public EgressEndpoint build() {
            return new EgressEndpoint(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
