/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediapackagevod.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.mediapackagevod.model.MediaPackageVodRequest;
import software.amazon.awssdk.services.mediapackagevod.model.TagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateAssetRequest
extends MediaPackageVodRequest
implements ToCopyableBuilder<Builder, CreateAssetRequest> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateAssetRequest.getter(CreateAssetRequest::id)).setter(CreateAssetRequest.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> PACKAGING_GROUP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateAssetRequest.getter(CreateAssetRequest::packagingGroupId)).setter(CreateAssetRequest.setter(Builder::packagingGroupId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("packagingGroupId").build()}).build();
    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateAssetRequest.getter(CreateAssetRequest::resourceId)).setter(CreateAssetRequest.setter(Builder::resourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceId").build()}).build();
    private static final SdkField<String> SOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateAssetRequest.getter(CreateAssetRequest::sourceArn)).setter(CreateAssetRequest.setter(Builder::sourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceArn").build()}).build();
    private static final SdkField<String> SOURCE_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateAssetRequest.getter(CreateAssetRequest::sourceRoleArn)).setter(CreateAssetRequest.setter(Builder::sourceRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceRoleArn").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(CreateAssetRequest.getter(CreateAssetRequest::tags)).setter(CreateAssetRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, PACKAGING_GROUP_ID_FIELD, RESOURCE_ID_FIELD, SOURCE_ARN_FIELD, SOURCE_ROLE_ARN_FIELD, TAGS_FIELD));
    private final String id;
    private final String packagingGroupId;
    private final String resourceId;
    private final String sourceArn;
    private final String sourceRoleArn;
    private final Map<String, String> tags;

    private CreateAssetRequest(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.packagingGroupId = builder.packagingGroupId;
        this.resourceId = builder.resourceId;
        this.sourceArn = builder.sourceArn;
        this.sourceRoleArn = builder.sourceRoleArn;
        this.tags = builder.tags;
    }

    public String id() {
        return this.id;
    }

    public String packagingGroupId() {
        return this.packagingGroupId;
    }

    public String resourceId() {
        return this.resourceId;
    }

    public String sourceArn() {
        return this.sourceArn;
    }

    public String sourceRoleArn() {
        return this.sourceRoleArn;
    }

    public boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.packagingGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAssetRequest)) {
            return false;
        }
        CreateAssetRequest other = (CreateAssetRequest)((Object)obj);
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.packagingGroupId(), other.packagingGroupId()) && Objects.equals(this.resourceId(), other.resourceId()) && Objects.equals(this.sourceArn(), other.sourceArn()) && Objects.equals(this.sourceRoleArn(), other.sourceRoleArn()) && Objects.equals(this.tags(), other.tags());
    }

    public String toString() {
        return ToString.builder((String)"CreateAssetRequest").add("Id", (Object)this.id()).add("PackagingGroupId", (Object)this.packagingGroupId()).add("ResourceId", (Object)this.resourceId()).add("SourceArn", (Object)this.sourceArn()).add("SourceRoleArn", (Object)this.sourceRoleArn()).add("Tags", this.tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "PackagingGroupId": {
                return Optional.ofNullable(clazz.cast(this.packagingGroupId()));
            }
            case "ResourceId": {
                return Optional.ofNullable(clazz.cast(this.resourceId()));
            }
            case "SourceArn": {
                return Optional.ofNullable(clazz.cast(this.sourceArn()));
            }
            case "SourceRoleArn": {
                return Optional.ofNullable(clazz.cast(this.sourceRoleArn()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateAssetRequest, T> g) {
        return obj -> g.apply((CreateAssetRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MediaPackageVodRequest.BuilderImpl
    implements Builder {
        private String id;
        private String packagingGroupId;
        private String resourceId;
        private String sourceArn;
        private String sourceRoleArn;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAssetRequest model) {
            super(model);
            this.id(model.id);
            this.packagingGroupId(model.packagingGroupId);
            this.resourceId(model.resourceId);
            this.sourceArn(model.sourceArn);
            this.sourceRoleArn(model.sourceRoleArn);
            this.tags(model.tags);
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getPackagingGroupId() {
            return this.packagingGroupId;
        }

        @Override
        public final Builder packagingGroupId(String packagingGroupId) {
            this.packagingGroupId = packagingGroupId;
            return this;
        }

        public final void setPackagingGroupId(String packagingGroupId) {
            this.packagingGroupId = packagingGroupId;
        }

        public final String getResourceId() {
            return this.resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        public final String getSourceArn() {
            return this.sourceArn;
        }

        @Override
        public final Builder sourceArn(String sourceArn) {
            this.sourceArn = sourceArn;
            return this;
        }

        public final void setSourceArn(String sourceArn) {
            this.sourceArn = sourceArn;
        }

        public final String getSourceRoleArn() {
            return this.sourceRoleArn;
        }

        @Override
        public final Builder sourceRoleArn(String sourceRoleArn) {
            this.sourceRoleArn = sourceRoleArn;
            return this;
        }

        public final void setSourceRoleArn(String sourceRoleArn) {
            this.sourceRoleArn = sourceRoleArn;
        }

        public final Map<String, String> getTags() {
            return this.tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateAssetRequest build() {
            return new CreateAssetRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends MediaPackageVodRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateAssetRequest> {
        public Builder id(String var1);

        public Builder packagingGroupId(String var1);

        public Builder resourceId(String var1);

        public Builder sourceArn(String var1);

        public Builder sourceRoleArn(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

