/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediapackagevod.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.mediapackagevod.model.Authorization;
import software.amazon.awssdk.services.mediapackagevod.model.MediaPackageVodResponse;
import software.amazon.awssdk.services.mediapackagevod.model.TagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribePackagingGroupResponse
extends MediaPackageVodResponse
implements ToCopyableBuilder<Builder, DescribePackagingGroupResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribePackagingGroupResponse.getter(DescribePackagingGroupResponse::arn)).setter(DescribePackagingGroupResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<Authorization> AUTHORIZATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(DescribePackagingGroupResponse.getter(DescribePackagingGroupResponse::authorization)).setter(DescribePackagingGroupResponse.setter(Builder::authorization)).constructor(Authorization::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authorization").build()}).build();
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribePackagingGroupResponse.getter(DescribePackagingGroupResponse::domainName)).setter(DescribePackagingGroupResponse.setter(Builder::domainName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainName").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribePackagingGroupResponse.getter(DescribePackagingGroupResponse::id)).setter(DescribePackagingGroupResponse.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(DescribePackagingGroupResponse.getter(DescribePackagingGroupResponse::tags)).setter(DescribePackagingGroupResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, AUTHORIZATION_FIELD, DOMAIN_NAME_FIELD, ID_FIELD, TAGS_FIELD));
    private final String arn;
    private final Authorization authorization;
    private final String domainName;
    private final String id;
    private final Map<String, String> tags;

    private DescribePackagingGroupResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.authorization = builder.authorization;
        this.domainName = builder.domainName;
        this.id = builder.id;
        this.tags = builder.tags;
    }

    public String arn() {
        return this.arn;
    }

    public Authorization authorization() {
        return this.authorization;
    }

    public String domainName() {
        return this.domainName;
    }

    public String id() {
        return this.id;
    }

    public boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.authorization());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribePackagingGroupResponse)) {
            return false;
        }
        DescribePackagingGroupResponse other = (DescribePackagingGroupResponse)((Object)obj);
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.authorization(), other.authorization()) && Objects.equals(this.domainName(), other.domainName()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.tags(), other.tags());
    }

    public String toString() {
        return ToString.builder((String)"DescribePackagingGroupResponse").add("Arn", (Object)this.arn()).add("Authorization", (Object)this.authorization()).add("DomainName", (Object)this.domainName()).add("Id", (Object)this.id()).add("Tags", this.tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "Authorization": {
                return Optional.ofNullable(clazz.cast(this.authorization()));
            }
            case "DomainName": {
                return Optional.ofNullable(clazz.cast(this.domainName()));
            }
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribePackagingGroupResponse, T> g) {
        return obj -> g.apply((DescribePackagingGroupResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MediaPackageVodResponse.BuilderImpl
    implements Builder {
        private String arn;
        private Authorization authorization;
        private String domainName;
        private String id;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribePackagingGroupResponse model) {
            super(model);
            this.arn(model.arn);
            this.authorization(model.authorization);
            this.domainName(model.domainName);
            this.id(model.id);
            this.tags(model.tags);
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final Authorization.Builder getAuthorization() {
            return this.authorization != null ? this.authorization.toBuilder() : null;
        }

        @Override
        public final Builder authorization(Authorization authorization) {
            this.authorization = authorization;
            return this;
        }

        public final void setAuthorization(Authorization.BuilderImpl authorization) {
            this.authorization = authorization != null ? authorization.build() : null;
        }

        public final String getDomainName() {
            return this.domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final Map<String, String> getTags() {
            return this.tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public DescribePackagingGroupResponse build() {
            return new DescribePackagingGroupResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends MediaPackageVodResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribePackagingGroupResponse> {
        public Builder arn(String var1);

        public Builder authorization(Authorization var1);

        default public Builder authorization(Consumer<Authorization.Builder> authorization) {
            return this.authorization((Authorization)((Authorization.Builder)Authorization.builder().applyMutation(authorization)).build());
        }

        public Builder domainName(String var1);

        public Builder id(String var1);

        public Builder tags(Map<String, String> var1);
    }
}

