/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediapackagevod;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.mediapackagevod.MediaPackageVodClient;
import software.amazon.awssdk.services.mediapackagevod.model.CreateAssetRequest;
import software.amazon.awssdk.services.mediapackagevod.model.CreateAssetResponse;
import software.amazon.awssdk.services.mediapackagevod.model.CreatePackagingConfigurationRequest;
import software.amazon.awssdk.services.mediapackagevod.model.CreatePackagingConfigurationResponse;
import software.amazon.awssdk.services.mediapackagevod.model.CreatePackagingGroupRequest;
import software.amazon.awssdk.services.mediapackagevod.model.CreatePackagingGroupResponse;
import software.amazon.awssdk.services.mediapackagevod.model.DeleteAssetRequest;
import software.amazon.awssdk.services.mediapackagevod.model.DeleteAssetResponse;
import software.amazon.awssdk.services.mediapackagevod.model.DeletePackagingConfigurationRequest;
import software.amazon.awssdk.services.mediapackagevod.model.DeletePackagingConfigurationResponse;
import software.amazon.awssdk.services.mediapackagevod.model.DeletePackagingGroupRequest;
import software.amazon.awssdk.services.mediapackagevod.model.DeletePackagingGroupResponse;
import software.amazon.awssdk.services.mediapackagevod.model.DescribeAssetRequest;
import software.amazon.awssdk.services.mediapackagevod.model.DescribeAssetResponse;
import software.amazon.awssdk.services.mediapackagevod.model.DescribePackagingConfigurationRequest;
import software.amazon.awssdk.services.mediapackagevod.model.DescribePackagingConfigurationResponse;
import software.amazon.awssdk.services.mediapackagevod.model.DescribePackagingGroupRequest;
import software.amazon.awssdk.services.mediapackagevod.model.DescribePackagingGroupResponse;
import software.amazon.awssdk.services.mediapackagevod.model.ForbiddenException;
import software.amazon.awssdk.services.mediapackagevod.model.InternalServerErrorException;
import software.amazon.awssdk.services.mediapackagevod.model.ListAssetsRequest;
import software.amazon.awssdk.services.mediapackagevod.model.ListAssetsResponse;
import software.amazon.awssdk.services.mediapackagevod.model.ListPackagingConfigurationsRequest;
import software.amazon.awssdk.services.mediapackagevod.model.ListPackagingConfigurationsResponse;
import software.amazon.awssdk.services.mediapackagevod.model.ListPackagingGroupsRequest;
import software.amazon.awssdk.services.mediapackagevod.model.ListPackagingGroupsResponse;
import software.amazon.awssdk.services.mediapackagevod.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.mediapackagevod.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.mediapackagevod.model.MediaPackageVodException;
import software.amazon.awssdk.services.mediapackagevod.model.MediaPackageVodRequest;
import software.amazon.awssdk.services.mediapackagevod.model.NotFoundException;
import software.amazon.awssdk.services.mediapackagevod.model.ServiceUnavailableException;
import software.amazon.awssdk.services.mediapackagevod.model.TagResourceRequest;
import software.amazon.awssdk.services.mediapackagevod.model.TagResourceResponse;
import software.amazon.awssdk.services.mediapackagevod.model.TooManyRequestsException;
import software.amazon.awssdk.services.mediapackagevod.model.UnprocessableEntityException;
import software.amazon.awssdk.services.mediapackagevod.model.UntagResourceRequest;
import software.amazon.awssdk.services.mediapackagevod.model.UntagResourceResponse;
import software.amazon.awssdk.services.mediapackagevod.model.UpdatePackagingGroupRequest;
import software.amazon.awssdk.services.mediapackagevod.model.UpdatePackagingGroupResponse;
import software.amazon.awssdk.services.mediapackagevod.paginators.ListAssetsIterable;
import software.amazon.awssdk.services.mediapackagevod.paginators.ListPackagingConfigurationsIterable;
import software.amazon.awssdk.services.mediapackagevod.paginators.ListPackagingGroupsIterable;
import software.amazon.awssdk.services.mediapackagevod.transform.CreateAssetRequestMarshaller;
import software.amazon.awssdk.services.mediapackagevod.transform.CreatePackagingConfigurationRequestMarshaller;
import software.amazon.awssdk.services.mediapackagevod.transform.CreatePackagingGroupRequestMarshaller;
import software.amazon.awssdk.services.mediapackagevod.transform.DeleteAssetRequestMarshaller;
import software.amazon.awssdk.services.mediapackagevod.transform.DeletePackagingConfigurationRequestMarshaller;
import software.amazon.awssdk.services.mediapackagevod.transform.DeletePackagingGroupRequestMarshaller;
import software.amazon.awssdk.services.mediapackagevod.transform.DescribeAssetRequestMarshaller;
import software.amazon.awssdk.services.mediapackagevod.transform.DescribePackagingConfigurationRequestMarshaller;
import software.amazon.awssdk.services.mediapackagevod.transform.DescribePackagingGroupRequestMarshaller;
import software.amazon.awssdk.services.mediapackagevod.transform.ListAssetsRequestMarshaller;
import software.amazon.awssdk.services.mediapackagevod.transform.ListPackagingConfigurationsRequestMarshaller;
import software.amazon.awssdk.services.mediapackagevod.transform.ListPackagingGroupsRequestMarshaller;
import software.amazon.awssdk.services.mediapackagevod.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.mediapackagevod.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.mediapackagevod.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.mediapackagevod.transform.UpdatePackagingGroupRequestMarshaller;

@SdkInternalApi
final class DefaultMediaPackageVodClient
implements MediaPackageVodClient {
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultMediaPackageVodClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    public final String serviceName() {
        return "mediapackage-vod";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateAssetResponse createAsset(CreateAssetRequest createAssetRequest) throws UnprocessableEntityException, InternalServerErrorException, ForbiddenException, NotFoundException, ServiceUnavailableException, TooManyRequestsException, AwsServiceException, SdkClientException, MediaPackageVodException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateAssetResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaPackage Vod");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateAsset");
            CreateAssetResponse createAssetResponse = (CreateAssetResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateAsset").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createAssetRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new CreateAssetRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createAssetResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultMediaPackageVodClient.resolveMetricPublishers(this.clientConfiguration, createAssetRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreatePackagingConfigurationResponse createPackagingConfiguration(CreatePackagingConfigurationRequest createPackagingConfigurationRequest) throws UnprocessableEntityException, InternalServerErrorException, ForbiddenException, NotFoundException, ServiceUnavailableException, TooManyRequestsException, AwsServiceException, SdkClientException, MediaPackageVodException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreatePackagingConfigurationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaPackage Vod");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreatePackagingConfiguration");
            CreatePackagingConfigurationResponse createPackagingConfigurationResponse = (CreatePackagingConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreatePackagingConfiguration").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createPackagingConfigurationRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new CreatePackagingConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createPackagingConfigurationResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultMediaPackageVodClient.resolveMetricPublishers(this.clientConfiguration, createPackagingConfigurationRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreatePackagingGroupResponse createPackagingGroup(CreatePackagingGroupRequest createPackagingGroupRequest) throws UnprocessableEntityException, InternalServerErrorException, ForbiddenException, NotFoundException, ServiceUnavailableException, TooManyRequestsException, AwsServiceException, SdkClientException, MediaPackageVodException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreatePackagingGroupResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaPackage Vod");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreatePackagingGroup");
            CreatePackagingGroupResponse createPackagingGroupResponse = (CreatePackagingGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreatePackagingGroup").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createPackagingGroupRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new CreatePackagingGroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createPackagingGroupResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultMediaPackageVodClient.resolveMetricPublishers(this.clientConfiguration, createPackagingGroupRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteAssetResponse deleteAsset(DeleteAssetRequest deleteAssetRequest) throws UnprocessableEntityException, InternalServerErrorException, ForbiddenException, NotFoundException, ServiceUnavailableException, TooManyRequestsException, AwsServiceException, SdkClientException, MediaPackageVodException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteAssetResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaPackage Vod");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteAsset");
            DeleteAssetResponse deleteAssetResponse = (DeleteAssetResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteAsset").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteAssetRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new DeleteAssetRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteAssetResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultMediaPackageVodClient.resolveMetricPublishers(this.clientConfiguration, deleteAssetRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeletePackagingConfigurationResponse deletePackagingConfiguration(DeletePackagingConfigurationRequest deletePackagingConfigurationRequest) throws UnprocessableEntityException, InternalServerErrorException, ForbiddenException, NotFoundException, ServiceUnavailableException, TooManyRequestsException, AwsServiceException, SdkClientException, MediaPackageVodException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeletePackagingConfigurationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaPackage Vod");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeletePackagingConfiguration");
            DeletePackagingConfigurationResponse deletePackagingConfigurationResponse = (DeletePackagingConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeletePackagingConfiguration").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deletePackagingConfigurationRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new DeletePackagingConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deletePackagingConfigurationResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultMediaPackageVodClient.resolveMetricPublishers(this.clientConfiguration, deletePackagingConfigurationRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeletePackagingGroupResponse deletePackagingGroup(DeletePackagingGroupRequest deletePackagingGroupRequest) throws UnprocessableEntityException, InternalServerErrorException, ForbiddenException, NotFoundException, ServiceUnavailableException, TooManyRequestsException, AwsServiceException, SdkClientException, MediaPackageVodException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeletePackagingGroupResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaPackage Vod");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeletePackagingGroup");
            DeletePackagingGroupResponse deletePackagingGroupResponse = (DeletePackagingGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeletePackagingGroup").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deletePackagingGroupRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new DeletePackagingGroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deletePackagingGroupResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultMediaPackageVodClient.resolveMetricPublishers(this.clientConfiguration, deletePackagingGroupRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeAssetResponse describeAsset(DescribeAssetRequest describeAssetRequest) throws UnprocessableEntityException, InternalServerErrorException, ForbiddenException, NotFoundException, ServiceUnavailableException, TooManyRequestsException, AwsServiceException, SdkClientException, MediaPackageVodException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeAssetResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaPackage Vod");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeAsset");
            DescribeAssetResponse describeAssetResponse = (DescribeAssetResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeAsset").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeAssetRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new DescribeAssetRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeAssetResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultMediaPackageVodClient.resolveMetricPublishers(this.clientConfiguration, describeAssetRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribePackagingConfigurationResponse describePackagingConfiguration(DescribePackagingConfigurationRequest describePackagingConfigurationRequest) throws UnprocessableEntityException, InternalServerErrorException, ForbiddenException, NotFoundException, ServiceUnavailableException, TooManyRequestsException, AwsServiceException, SdkClientException, MediaPackageVodException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribePackagingConfigurationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaPackage Vod");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribePackagingConfiguration");
            DescribePackagingConfigurationResponse describePackagingConfigurationResponse = (DescribePackagingConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribePackagingConfiguration").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describePackagingConfigurationRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new DescribePackagingConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describePackagingConfigurationResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultMediaPackageVodClient.resolveMetricPublishers(this.clientConfiguration, describePackagingConfigurationRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribePackagingGroupResponse describePackagingGroup(DescribePackagingGroupRequest describePackagingGroupRequest) throws UnprocessableEntityException, InternalServerErrorException, ForbiddenException, NotFoundException, ServiceUnavailableException, TooManyRequestsException, AwsServiceException, SdkClientException, MediaPackageVodException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribePackagingGroupResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaPackage Vod");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribePackagingGroup");
            DescribePackagingGroupResponse describePackagingGroupResponse = (DescribePackagingGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribePackagingGroup").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describePackagingGroupRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new DescribePackagingGroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describePackagingGroupResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultMediaPackageVodClient.resolveMetricPublishers(this.clientConfiguration, describePackagingGroupRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListAssetsResponse listAssets(ListAssetsRequest listAssetsRequest) throws UnprocessableEntityException, InternalServerErrorException, ForbiddenException, NotFoundException, ServiceUnavailableException, TooManyRequestsException, AwsServiceException, SdkClientException, MediaPackageVodException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListAssetsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaPackage Vod");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListAssets");
            ListAssetsResponse listAssetsResponse = (ListAssetsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListAssets").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listAssetsRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new ListAssetsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listAssetsResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultMediaPackageVodClient.resolveMetricPublishers(this.clientConfiguration, listAssetsRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    @Override
    public ListAssetsIterable listAssetsPaginator(ListAssetsRequest listAssetsRequest) throws UnprocessableEntityException, InternalServerErrorException, ForbiddenException, NotFoundException, ServiceUnavailableException, TooManyRequestsException, AwsServiceException, SdkClientException, MediaPackageVodException {
        return new ListAssetsIterable(this, this.applyPaginatorUserAgent(listAssetsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListPackagingConfigurationsResponse listPackagingConfigurations(ListPackagingConfigurationsRequest listPackagingConfigurationsRequest) throws UnprocessableEntityException, InternalServerErrorException, ForbiddenException, NotFoundException, ServiceUnavailableException, TooManyRequestsException, AwsServiceException, SdkClientException, MediaPackageVodException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListPackagingConfigurationsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaPackage Vod");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListPackagingConfigurations");
            ListPackagingConfigurationsResponse listPackagingConfigurationsResponse = (ListPackagingConfigurationsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListPackagingConfigurations").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listPackagingConfigurationsRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new ListPackagingConfigurationsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listPackagingConfigurationsResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultMediaPackageVodClient.resolveMetricPublishers(this.clientConfiguration, listPackagingConfigurationsRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    @Override
    public ListPackagingConfigurationsIterable listPackagingConfigurationsPaginator(ListPackagingConfigurationsRequest listPackagingConfigurationsRequest) throws UnprocessableEntityException, InternalServerErrorException, ForbiddenException, NotFoundException, ServiceUnavailableException, TooManyRequestsException, AwsServiceException, SdkClientException, MediaPackageVodException {
        return new ListPackagingConfigurationsIterable(this, this.applyPaginatorUserAgent(listPackagingConfigurationsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListPackagingGroupsResponse listPackagingGroups(ListPackagingGroupsRequest listPackagingGroupsRequest) throws UnprocessableEntityException, InternalServerErrorException, ForbiddenException, NotFoundException, ServiceUnavailableException, TooManyRequestsException, AwsServiceException, SdkClientException, MediaPackageVodException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListPackagingGroupsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaPackage Vod");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListPackagingGroups");
            ListPackagingGroupsResponse listPackagingGroupsResponse = (ListPackagingGroupsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListPackagingGroups").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listPackagingGroupsRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new ListPackagingGroupsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listPackagingGroupsResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultMediaPackageVodClient.resolveMetricPublishers(this.clientConfiguration, listPackagingGroupsRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    @Override
    public ListPackagingGroupsIterable listPackagingGroupsPaginator(ListPackagingGroupsRequest listPackagingGroupsRequest) throws UnprocessableEntityException, InternalServerErrorException, ForbiddenException, NotFoundException, ServiceUnavailableException, TooManyRequestsException, AwsServiceException, SdkClientException, MediaPackageVodException {
        return new ListPackagingGroupsIterable(this, this.applyPaginatorUserAgent(listPackagingGroupsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) throws AwsServiceException, SdkClientException, MediaPackageVodException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsForResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaPackage Vod");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTagsForResource");
            ListTagsForResourceResponse listTagsForResourceResponse = (ListTagsForResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listTagsForResourceRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new ListTagsForResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listTagsForResourceResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultMediaPackageVodClient.resolveMetricPublishers(this.clientConfiguration, listTagsForResourceRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws AwsServiceException, SdkClientException, MediaPackageVodException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TagResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaPackage Vod");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TagResource");
            TagResourceResponse tagResourceResponse = (TagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)tagResourceRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new TagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return tagResourceResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultMediaPackageVodClient.resolveMetricPublishers(this.clientConfiguration, tagResourceRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws AwsServiceException, SdkClientException, MediaPackageVodException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UntagResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaPackage Vod");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UntagResource");
            UntagResourceResponse untagResourceResponse = (UntagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)untagResourceRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new UntagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return untagResourceResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultMediaPackageVodClient.resolveMetricPublishers(this.clientConfiguration, untagResourceRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdatePackagingGroupResponse updatePackagingGroup(UpdatePackagingGroupRequest updatePackagingGroupRequest) throws UnprocessableEntityException, InternalServerErrorException, ForbiddenException, NotFoundException, ServiceUnavailableException, TooManyRequestsException, AwsServiceException, SdkClientException, MediaPackageVodException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdatePackagingGroupResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaPackage Vod");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdatePackagingGroup");
            UpdatePackagingGroupResponse updatePackagingGroupResponse = (UpdatePackagingGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdatePackagingGroup").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updatePackagingGroupRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new UpdatePackagingGroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updatePackagingGroupResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultMediaPackageVodClient.resolveMetricPublishers(this.clientConfiguration, updatePackagingGroupRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(MediaPackageVodException::builder).protocol(AwsJsonProtocol.REST_JSON).protocolVersion("1.1").registerModeledException(ExceptionMetadata.builder().errorCode("UnprocessableEntityException").exceptionBuilderSupplier(UnprocessableEntityException::builder).httpStatusCode(Integer.valueOf(422)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("NotFoundException").exceptionBuilderSupplier(NotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").exceptionBuilderSupplier(ServiceUnavailableException::builder).httpStatusCode(Integer.valueOf(503)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ForbiddenException").exceptionBuilderSupplier(ForbiddenException::builder).httpStatusCode(Integer.valueOf(403)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyRequestsException").exceptionBuilderSupplier(TooManyRequestsException::builder).httpStatusCode(Integer.valueOf(429)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InternalServerErrorException").exceptionBuilderSupplier(InternalServerErrorException::builder).httpStatusCode(Integer.valueOf(500)).build());
    }

    public void close() {
        this.clientHandler.close();
    }

    private <T extends MediaPackageVodRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("2.13.55").name("PAGINATED").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((MediaPackageVodRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }
}

