/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediapackagevod.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * An HTTP Live Streaming (HLS) manifest configuration.
 */
@Generated("software.amazon.awssdk:codegen")
public final class HlsManifest implements SdkPojo, Serializable, ToCopyableBuilder<HlsManifest.Builder, HlsManifest> {
    private static final SdkField<String> AD_MARKERS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(HlsManifest::adMarkersAsString)).setter(setter(Builder::adMarkers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("adMarkers").build()).build();

    private static final SdkField<Boolean> INCLUDE_IFRAME_ONLY_STREAM_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(HlsManifest::includeIframeOnlyStream)).setter(setter(Builder::includeIframeOnlyStream))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("includeIframeOnlyStream").build())
            .build();

    private static final SdkField<String> MANIFEST_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(HlsManifest::manifestName)).setter(setter(Builder::manifestName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("manifestName").build()).build();

    private static final SdkField<Integer> PROGRAM_DATE_TIME_INTERVAL_SECONDS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(HlsManifest::programDateTimeIntervalSeconds))
            .setter(setter(Builder::programDateTimeIntervalSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("programDateTimeIntervalSeconds")
                    .build()).build();

    private static final SdkField<Boolean> REPEAT_EXT_X_KEY_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(HlsManifest::repeatExtXKey)).setter(setter(Builder::repeatExtXKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repeatExtXKey").build()).build();

    private static final SdkField<StreamSelection> STREAM_SELECTION_FIELD = SdkField
            .<StreamSelection> builder(MarshallingType.SDK_POJO).getter(getter(HlsManifest::streamSelection))
            .setter(setter(Builder::streamSelection)).constructor(StreamSelection::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("streamSelection").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AD_MARKERS_FIELD,
            INCLUDE_IFRAME_ONLY_STREAM_FIELD, MANIFEST_NAME_FIELD, PROGRAM_DATE_TIME_INTERVAL_SECONDS_FIELD,
            REPEAT_EXT_X_KEY_FIELD, STREAM_SELECTION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String adMarkers;

    private final Boolean includeIframeOnlyStream;

    private final String manifestName;

    private final Integer programDateTimeIntervalSeconds;

    private final Boolean repeatExtXKey;

    private final StreamSelection streamSelection;

    private HlsManifest(BuilderImpl builder) {
        this.adMarkers = builder.adMarkers;
        this.includeIframeOnlyStream = builder.includeIframeOnlyStream;
        this.manifestName = builder.manifestName;
        this.programDateTimeIntervalSeconds = builder.programDateTimeIntervalSeconds;
        this.repeatExtXKey = builder.repeatExtXKey;
        this.streamSelection = builder.streamSelection;
    }

    /**
     * This setting controls how ad markers are included in the packaged OriginEndpoint. "NONE" will omit all SCTE-35 ad
     * markers from the output. "PASSTHROUGH" causes the manifest to contain a copy of the SCTE-35 ad markers (comments)
     * taken directly from the input HTTP Live Streaming (HLS) manifest. "SCTE35_ENHANCED" generates ad markers and
     * blackout tags based on SCTE-35 messages in the input source.
     *
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #adMarkers} will
     * return {@link AdMarkers#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #adMarkersAsString}.
     * </p>
     * 
     * @return This setting controls how ad markers are included in the packaged OriginEndpoint. "NONE" will omit all
     *         SCTE-35 ad markers from the output. "PASSTHROUGH" causes the manifest to contain a copy of the SCTE-35 ad
     *         markers (comments) taken directly from the input HTTP Live Streaming (HLS) manifest. "SCTE35_ENHANCED"
     *         generates ad markers and blackout tags based on SCTE-35 messages in the input source.
     * @see AdMarkers
     */
    public AdMarkers adMarkers() {
        return AdMarkers.fromValue(adMarkers);
    }

    /**
     * This setting controls how ad markers are included in the packaged OriginEndpoint. "NONE" will omit all SCTE-35 ad
     * markers from the output. "PASSTHROUGH" causes the manifest to contain a copy of the SCTE-35 ad markers (comments)
     * taken directly from the input HTTP Live Streaming (HLS) manifest. "SCTE35_ENHANCED" generates ad markers and
     * blackout tags based on SCTE-35 messages in the input source.
     *
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #adMarkers} will
     * return {@link AdMarkers#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #adMarkersAsString}.
     * </p>
     * 
     * @return This setting controls how ad markers are included in the packaged OriginEndpoint. "NONE" will omit all
     *         SCTE-35 ad markers from the output. "PASSTHROUGH" causes the manifest to contain a copy of the SCTE-35 ad
     *         markers (comments) taken directly from the input HTTP Live Streaming (HLS) manifest. "SCTE35_ENHANCED"
     *         generates ad markers and blackout tags based on SCTE-35 messages in the input source.
     * @see AdMarkers
     */
    public String adMarkersAsString() {
        return adMarkers;
    }

    /**
     * When enabled, an I-Frame only stream will be included in the output.
     * 
     * @return When enabled, an I-Frame only stream will be included in the output.
     */
    public Boolean includeIframeOnlyStream() {
        return includeIframeOnlyStream;
    }

    /**
     * An optional string to include in the name of the manifest.
     * 
     * @return An optional string to include in the name of the manifest.
     */
    public String manifestName() {
        return manifestName;
    }

    /**
     * The interval (in seconds) between each EXT-X-PROGRAM-DATE-TIME tag inserted into manifests. Additionally, when an
     * interval is specified ID3Timed Metadata messages will be generated every 5 seconds using the ingest time of the
     * content. If the interval is not specified, or set to 0, then no EXT-X-PROGRAM-DATE-TIME tags will be inserted
     * into manifests and no ID3Timed Metadata messages will be generated. Note that irrespective of this parameter, if
     * any ID3 Timed Metadata is found in HTTP Live Streaming (HLS) input, it will be passed through to HLS output.
     *
     * @return The interval (in seconds) between each EXT-X-PROGRAM-DATE-TIME tag inserted into manifests. Additionally,
     *         when an interval is specified ID3Timed Metadata messages will be generated every 5 seconds using the
     *         ingest time of the content. If the interval is not specified, or set to 0, then no
     *         EXT-X-PROGRAM-DATE-TIME tags will be inserted into manifests and no ID3Timed Metadata messages will be
     *         generated. Note that irrespective of this parameter, if any ID3 Timed Metadata is found in HTTP Live
     *         Streaming (HLS) input, it will be passed through to HLS output.
     */
    public Integer programDateTimeIntervalSeconds() {
        return programDateTimeIntervalSeconds;
    }

    /**
     * When enabled, the EXT-X-KEY tag will be repeated in output manifests.
     * 
     * @return When enabled, the EXT-X-KEY tag will be repeated in output manifests.
     */
    public Boolean repeatExtXKey() {
        return repeatExtXKey;
    }

    /**
     * Returns the value of the StreamSelection property for this object.
     * 
     * @return The value of the StreamSelection property for this object.
     */
    public StreamSelection streamSelection() {
        return streamSelection;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(adMarkersAsString());
        hashCode = 31 * hashCode + Objects.hashCode(includeIframeOnlyStream());
        hashCode = 31 * hashCode + Objects.hashCode(manifestName());
        hashCode = 31 * hashCode + Objects.hashCode(programDateTimeIntervalSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(repeatExtXKey());
        hashCode = 31 * hashCode + Objects.hashCode(streamSelection());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HlsManifest)) {
            return false;
        }
        HlsManifest other = (HlsManifest) obj;
        return Objects.equals(adMarkersAsString(), other.adMarkersAsString())
                && Objects.equals(includeIframeOnlyStream(), other.includeIframeOnlyStream())
                && Objects.equals(manifestName(), other.manifestName())
                && Objects.equals(programDateTimeIntervalSeconds(), other.programDateTimeIntervalSeconds())
                && Objects.equals(repeatExtXKey(), other.repeatExtXKey())
                && Objects.equals(streamSelection(), other.streamSelection());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("HlsManifest").add("AdMarkers", adMarkersAsString())
                .add("IncludeIframeOnlyStream", includeIframeOnlyStream()).add("ManifestName", manifestName())
                .add("ProgramDateTimeIntervalSeconds", programDateTimeIntervalSeconds()).add("RepeatExtXKey", repeatExtXKey())
                .add("StreamSelection", streamSelection()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AdMarkers":
            return Optional.ofNullable(clazz.cast(adMarkersAsString()));
        case "IncludeIframeOnlyStream":
            return Optional.ofNullable(clazz.cast(includeIframeOnlyStream()));
        case "ManifestName":
            return Optional.ofNullable(clazz.cast(manifestName()));
        case "ProgramDateTimeIntervalSeconds":
            return Optional.ofNullable(clazz.cast(programDateTimeIntervalSeconds()));
        case "RepeatExtXKey":
            return Optional.ofNullable(clazz.cast(repeatExtXKey()));
        case "StreamSelection":
            return Optional.ofNullable(clazz.cast(streamSelection()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<HlsManifest, T> g) {
        return obj -> g.apply((HlsManifest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, HlsManifest> {
        /**
         * This setting controls how ad markers are included in the packaged OriginEndpoint. "NONE" will omit all
         * SCTE-35 ad markers from the output. "PASSTHROUGH" causes the manifest to contain a copy of the SCTE-35 ad
         * markers (comments) taken directly from the input HTTP Live Streaming (HLS) manifest. "SCTE35_ENHANCED"
         * generates ad markers and blackout tags based on SCTE-35 messages in the input source.
         *
         * @param adMarkers
         *        This setting controls how ad markers are included in the packaged OriginEndpoint. "NONE" will omit all
         *        SCTE-35 ad markers from the output. "PASSTHROUGH" causes the manifest to contain a copy of the SCTE-35
         *        ad markers (comments) taken directly from the input HTTP Live Streaming (HLS) manifest.
         *        "SCTE35_ENHANCED" generates ad markers and blackout tags based on SCTE-35 messages in the input
         *        source.
         * @see AdMarkers
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AdMarkers
         */
        Builder adMarkers(String adMarkers);

        /**
         * This setting controls how ad markers are included in the packaged OriginEndpoint. "NONE" will omit all
         * SCTE-35 ad markers from the output. "PASSTHROUGH" causes the manifest to contain a copy of the SCTE-35 ad
         * markers (comments) taken directly from the input HTTP Live Streaming (HLS) manifest. "SCTE35_ENHANCED"
         * generates ad markers and blackout tags based on SCTE-35 messages in the input source.
         *
         * @param adMarkers
         *        This setting controls how ad markers are included in the packaged OriginEndpoint. "NONE" will omit all
         *        SCTE-35 ad markers from the output. "PASSTHROUGH" causes the manifest to contain a copy of the SCTE-35
         *        ad markers (comments) taken directly from the input HTTP Live Streaming (HLS) manifest.
         *        "SCTE35_ENHANCED" generates ad markers and blackout tags based on SCTE-35 messages in the input
         *        source.
         * @see AdMarkers
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AdMarkers
         */
        Builder adMarkers(AdMarkers adMarkers);

        /**
         * When enabled, an I-Frame only stream will be included in the output.
         * 
         * @param includeIframeOnlyStream
         *        When enabled, an I-Frame only stream will be included in the output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeIframeOnlyStream(Boolean includeIframeOnlyStream);

        /**
         * An optional string to include in the name of the manifest.
         * 
         * @param manifestName
         *        An optional string to include in the name of the manifest.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder manifestName(String manifestName);

        /**
         * The interval (in seconds) between each EXT-X-PROGRAM-DATE-TIME tag inserted into manifests. Additionally,
         * when an interval is specified ID3Timed Metadata messages will be generated every 5 seconds using the ingest
         * time of the content. If the interval is not specified, or set to 0, then no EXT-X-PROGRAM-DATE-TIME tags will
         * be inserted into manifests and no ID3Timed Metadata messages will be generated. Note that irrespective of
         * this parameter, if any ID3 Timed Metadata is found in HTTP Live Streaming (HLS) input, it will be passed
         * through to HLS output.
         *
         * @param programDateTimeIntervalSeconds
         *        The interval (in seconds) between each EXT-X-PROGRAM-DATE-TIME tag inserted into manifests.
         *        Additionally, when an interval is specified ID3Timed Metadata messages will be generated every 5
         *        seconds using the ingest time of the content. If the interval is not specified, or set to 0, then no
         *        EXT-X-PROGRAM-DATE-TIME tags will be inserted into manifests and no ID3Timed Metadata messages will be
         *        generated. Note that irrespective of this parameter, if any ID3 Timed Metadata is found in HTTP Live
         *        Streaming (HLS) input, it will be passed through to HLS output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder programDateTimeIntervalSeconds(Integer programDateTimeIntervalSeconds);

        /**
         * When enabled, the EXT-X-KEY tag will be repeated in output manifests.
         * 
         * @param repeatExtXKey
         *        When enabled, the EXT-X-KEY tag will be repeated in output manifests.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder repeatExtXKey(Boolean repeatExtXKey);

        /**
         * Sets the value of the StreamSelection property for this object.
         *
         * @param streamSelection
         *        The new value for the StreamSelection property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamSelection(StreamSelection streamSelection);

        /**
         * Sets the value of the StreamSelection property for this object.
         *
         * This is a convenience that creates an instance of the {@link StreamSelection.Builder} avoiding the need to
         * create one manually via {@link StreamSelection#builder()}.
         *
         * When the {@link Consumer} completes, {@link StreamSelection.Builder#build()} is called immediately and its
         * result is passed to {@link #streamSelection(StreamSelection)}.
         * 
         * @param streamSelection
         *        a consumer that will call methods on {@link StreamSelection.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #streamSelection(StreamSelection)
         */
        default Builder streamSelection(Consumer<StreamSelection.Builder> streamSelection) {
            return streamSelection(StreamSelection.builder().applyMutation(streamSelection).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String adMarkers;

        private Boolean includeIframeOnlyStream;

        private String manifestName;

        private Integer programDateTimeIntervalSeconds;

        private Boolean repeatExtXKey;

        private StreamSelection streamSelection;

        private BuilderImpl() {
        }

        private BuilderImpl(HlsManifest model) {
            adMarkers(model.adMarkers);
            includeIframeOnlyStream(model.includeIframeOnlyStream);
            manifestName(model.manifestName);
            programDateTimeIntervalSeconds(model.programDateTimeIntervalSeconds);
            repeatExtXKey(model.repeatExtXKey);
            streamSelection(model.streamSelection);
        }

        public final String getAdMarkers() {
            return adMarkers;
        }

        @Override
        public final Builder adMarkers(String adMarkers) {
            this.adMarkers = adMarkers;
            return this;
        }

        @Override
        public final Builder adMarkers(AdMarkers adMarkers) {
            this.adMarkers(adMarkers == null ? null : adMarkers.toString());
            return this;
        }

        public final void setAdMarkers(String adMarkers) {
            this.adMarkers = adMarkers;
        }

        public final Boolean getIncludeIframeOnlyStream() {
            return includeIframeOnlyStream;
        }

        @Override
        public final Builder includeIframeOnlyStream(Boolean includeIframeOnlyStream) {
            this.includeIframeOnlyStream = includeIframeOnlyStream;
            return this;
        }

        public final void setIncludeIframeOnlyStream(Boolean includeIframeOnlyStream) {
            this.includeIframeOnlyStream = includeIframeOnlyStream;
        }

        public final String getManifestName() {
            return manifestName;
        }

        @Override
        public final Builder manifestName(String manifestName) {
            this.manifestName = manifestName;
            return this;
        }

        public final void setManifestName(String manifestName) {
            this.manifestName = manifestName;
        }

        public final Integer getProgramDateTimeIntervalSeconds() {
            return programDateTimeIntervalSeconds;
        }

        @Override
        public final Builder programDateTimeIntervalSeconds(Integer programDateTimeIntervalSeconds) {
            this.programDateTimeIntervalSeconds = programDateTimeIntervalSeconds;
            return this;
        }

        public final void setProgramDateTimeIntervalSeconds(Integer programDateTimeIntervalSeconds) {
            this.programDateTimeIntervalSeconds = programDateTimeIntervalSeconds;
        }

        public final Boolean getRepeatExtXKey() {
            return repeatExtXKey;
        }

        @Override
        public final Builder repeatExtXKey(Boolean repeatExtXKey) {
            this.repeatExtXKey = repeatExtXKey;
            return this;
        }

        public final void setRepeatExtXKey(Boolean repeatExtXKey) {
            this.repeatExtXKey = repeatExtXKey;
        }

        public final StreamSelection.Builder getStreamSelection() {
            return streamSelection != null ? streamSelection.toBuilder() : null;
        }

        @Override
        public final Builder streamSelection(StreamSelection streamSelection) {
            this.streamSelection = streamSelection;
            return this;
        }

        public final void setStreamSelection(StreamSelection.BuilderImpl streamSelection) {
            this.streamSelection = streamSelection != null ? streamSelection.build() : null;
        }

        @Override
        public HlsManifest build() {
            return new HlsManifest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
