/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediapackagev2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetOriginEndpointPolicyResponse extends MediaPackageV2Response implements
        ToCopyableBuilder<GetOriginEndpointPolicyResponse.Builder, GetOriginEndpointPolicyResponse> {
    private static final SdkField<String> CHANNEL_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ChannelGroupName").getter(getter(GetOriginEndpointPolicyResponse::channelGroupName))
            .setter(setter(Builder::channelGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChannelGroupName").build()).build();

    private static final SdkField<String> CHANNEL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ChannelName").getter(getter(GetOriginEndpointPolicyResponse::channelName))
            .setter(setter(Builder::channelName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChannelName").build()).build();

    private static final SdkField<String> ORIGIN_ENDPOINT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OriginEndpointName").getter(getter(GetOriginEndpointPolicyResponse::originEndpointName))
            .setter(setter(Builder::originEndpointName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OriginEndpointName").build())
            .build();

    private static final SdkField<String> POLICY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Policy")
            .getter(getter(GetOriginEndpointPolicyResponse::policy)).setter(setter(Builder::policy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Policy").build()).build();

    private static final SdkField<CdnAuthConfiguration> CDN_AUTH_CONFIGURATION_FIELD = SdkField
            .<CdnAuthConfiguration> builder(MarshallingType.SDK_POJO).memberName("CdnAuthConfiguration")
            .getter(getter(GetOriginEndpointPolicyResponse::cdnAuthConfiguration)).setter(setter(Builder::cdnAuthConfiguration))
            .constructor(CdnAuthConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CdnAuthConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNEL_GROUP_NAME_FIELD,
            CHANNEL_NAME_FIELD, ORIGIN_ENDPOINT_NAME_FIELD, POLICY_FIELD, CDN_AUTH_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String channelGroupName;

    private final String channelName;

    private final String originEndpointName;

    private final String policy;

    private final CdnAuthConfiguration cdnAuthConfiguration;

    private GetOriginEndpointPolicyResponse(BuilderImpl builder) {
        super(builder);
        this.channelGroupName = builder.channelGroupName;
        this.channelName = builder.channelName;
        this.originEndpointName = builder.originEndpointName;
        this.policy = builder.policy;
        this.cdnAuthConfiguration = builder.cdnAuthConfiguration;
    }

    /**
     * <p>
     * The name that describes the channel group. The name is the primary identifier for the channel group, and must be
     * unique for your account in the AWS Region.
     * </p>
     * 
     * @return The name that describes the channel group. The name is the primary identifier for the channel group, and
     *         must be unique for your account in the AWS Region.
     */
    public final String channelGroupName() {
        return channelGroupName;
    }

    /**
     * <p>
     * The name that describes the channel. The name is the primary identifier for the channel, and must be unique for
     * your account in the AWS Region and channel group.
     * </p>
     * 
     * @return The name that describes the channel. The name is the primary identifier for the channel, and must be
     *         unique for your account in the AWS Region and channel group.
     */
    public final String channelName() {
        return channelName;
    }

    /**
     * <p>
     * The name that describes the origin endpoint. The name is the primary identifier for the origin endpoint, and and
     * must be unique for your account in the AWS Region and channel.
     * </p>
     * 
     * @return The name that describes the origin endpoint. The name is the primary identifier for the origin endpoint,
     *         and and must be unique for your account in the AWS Region and channel.
     */
    public final String originEndpointName() {
        return originEndpointName;
    }

    /**
     * <p>
     * The policy assigned to the origin endpoint.
     * </p>
     * 
     * @return The policy assigned to the origin endpoint.
     */
    public final String policy() {
        return policy;
    }

    /**
     * <p>
     * The settings for using authorization headers between the MediaPackage endpoint and your CDN.
     * </p>
     * <p>
     * For information about CDN authorization, see <a
     * href="https://docs.aws.amazon.com/mediapackage/latest/userguide/cdn-auth.html">CDN authorization in Elemental
     * MediaPackage</a> in the MediaPackage user guide.
     * </p>
     * 
     * @return The settings for using authorization headers between the MediaPackage endpoint and your CDN. </p>
     *         <p>
     *         For information about CDN authorization, see <a
     *         href="https://docs.aws.amazon.com/mediapackage/latest/userguide/cdn-auth.html">CDN authorization in
     *         Elemental MediaPackage</a> in the MediaPackage user guide.
     */
    public final CdnAuthConfiguration cdnAuthConfiguration() {
        return cdnAuthConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(channelGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(channelName());
        hashCode = 31 * hashCode + Objects.hashCode(originEndpointName());
        hashCode = 31 * hashCode + Objects.hashCode(policy());
        hashCode = 31 * hashCode + Objects.hashCode(cdnAuthConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetOriginEndpointPolicyResponse)) {
            return false;
        }
        GetOriginEndpointPolicyResponse other = (GetOriginEndpointPolicyResponse) obj;
        return Objects.equals(channelGroupName(), other.channelGroupName()) && Objects.equals(channelName(), other.channelName())
                && Objects.equals(originEndpointName(), other.originEndpointName()) && Objects.equals(policy(), other.policy())
                && Objects.equals(cdnAuthConfiguration(), other.cdnAuthConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetOriginEndpointPolicyResponse").add("ChannelGroupName", channelGroupName())
                .add("ChannelName", channelName()).add("OriginEndpointName", originEndpointName()).add("Policy", policy())
                .add("CdnAuthConfiguration", cdnAuthConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ChannelGroupName":
            return Optional.ofNullable(clazz.cast(channelGroupName()));
        case "ChannelName":
            return Optional.ofNullable(clazz.cast(channelName()));
        case "OriginEndpointName":
            return Optional.ofNullable(clazz.cast(originEndpointName()));
        case "Policy":
            return Optional.ofNullable(clazz.cast(policy()));
        case "CdnAuthConfiguration":
            return Optional.ofNullable(clazz.cast(cdnAuthConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ChannelGroupName", CHANNEL_GROUP_NAME_FIELD);
        map.put("ChannelName", CHANNEL_NAME_FIELD);
        map.put("OriginEndpointName", ORIGIN_ENDPOINT_NAME_FIELD);
        map.put("Policy", POLICY_FIELD);
        map.put("CdnAuthConfiguration", CDN_AUTH_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetOriginEndpointPolicyResponse, T> g) {
        return obj -> g.apply((GetOriginEndpointPolicyResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends MediaPackageV2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, GetOriginEndpointPolicyResponse> {
        /**
         * <p>
         * The name that describes the channel group. The name is the primary identifier for the channel group, and must
         * be unique for your account in the AWS Region.
         * </p>
         * 
         * @param channelGroupName
         *        The name that describes the channel group. The name is the primary identifier for the channel group,
         *        and must be unique for your account in the AWS Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelGroupName(String channelGroupName);

        /**
         * <p>
         * The name that describes the channel. The name is the primary identifier for the channel, and must be unique
         * for your account in the AWS Region and channel group.
         * </p>
         * 
         * @param channelName
         *        The name that describes the channel. The name is the primary identifier for the channel, and must be
         *        unique for your account in the AWS Region and channel group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelName(String channelName);

        /**
         * <p>
         * The name that describes the origin endpoint. The name is the primary identifier for the origin endpoint, and
         * and must be unique for your account in the AWS Region and channel.
         * </p>
         * 
         * @param originEndpointName
         *        The name that describes the origin endpoint. The name is the primary identifier for the origin
         *        endpoint, and and must be unique for your account in the AWS Region and channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder originEndpointName(String originEndpointName);

        /**
         * <p>
         * The policy assigned to the origin endpoint.
         * </p>
         * 
         * @param policy
         *        The policy assigned to the origin endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policy(String policy);

        /**
         * <p>
         * The settings for using authorization headers between the MediaPackage endpoint and your CDN.
         * </p>
         * <p>
         * For information about CDN authorization, see <a
         * href="https://docs.aws.amazon.com/mediapackage/latest/userguide/cdn-auth.html">CDN authorization in Elemental
         * MediaPackage</a> in the MediaPackage user guide.
         * </p>
         * 
         * @param cdnAuthConfiguration
         *        The settings for using authorization headers between the MediaPackage endpoint and your CDN. </p>
         *        <p>
         *        For information about CDN authorization, see <a
         *        href="https://docs.aws.amazon.com/mediapackage/latest/userguide/cdn-auth.html">CDN authorization in
         *        Elemental MediaPackage</a> in the MediaPackage user guide.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cdnAuthConfiguration(CdnAuthConfiguration cdnAuthConfiguration);

        /**
         * <p>
         * The settings for using authorization headers between the MediaPackage endpoint and your CDN.
         * </p>
         * <p>
         * For information about CDN authorization, see <a
         * href="https://docs.aws.amazon.com/mediapackage/latest/userguide/cdn-auth.html">CDN authorization in Elemental
         * MediaPackage</a> in the MediaPackage user guide.
         * </p>
         * This is a convenience method that creates an instance of the {@link CdnAuthConfiguration.Builder} avoiding
         * the need to create one manually via {@link CdnAuthConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CdnAuthConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #cdnAuthConfiguration(CdnAuthConfiguration)}.
         * 
         * @param cdnAuthConfiguration
         *        a consumer that will call methods on {@link CdnAuthConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cdnAuthConfiguration(CdnAuthConfiguration)
         */
        default Builder cdnAuthConfiguration(Consumer<CdnAuthConfiguration.Builder> cdnAuthConfiguration) {
            return cdnAuthConfiguration(CdnAuthConfiguration.builder().applyMutation(cdnAuthConfiguration).build());
        }
    }

    static final class BuilderImpl extends MediaPackageV2Response.BuilderImpl implements Builder {
        private String channelGroupName;

        private String channelName;

        private String originEndpointName;

        private String policy;

        private CdnAuthConfiguration cdnAuthConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(GetOriginEndpointPolicyResponse model) {
            super(model);
            channelGroupName(model.channelGroupName);
            channelName(model.channelName);
            originEndpointName(model.originEndpointName);
            policy(model.policy);
            cdnAuthConfiguration(model.cdnAuthConfiguration);
        }

        public final String getChannelGroupName() {
            return channelGroupName;
        }

        public final void setChannelGroupName(String channelGroupName) {
            this.channelGroupName = channelGroupName;
        }

        @Override
        public final Builder channelGroupName(String channelGroupName) {
            this.channelGroupName = channelGroupName;
            return this;
        }

        public final String getChannelName() {
            return channelName;
        }

        public final void setChannelName(String channelName) {
            this.channelName = channelName;
        }

        @Override
        public final Builder channelName(String channelName) {
            this.channelName = channelName;
            return this;
        }

        public final String getOriginEndpointName() {
            return originEndpointName;
        }

        public final void setOriginEndpointName(String originEndpointName) {
            this.originEndpointName = originEndpointName;
        }

        @Override
        public final Builder originEndpointName(String originEndpointName) {
            this.originEndpointName = originEndpointName;
            return this;
        }

        public final String getPolicy() {
            return policy;
        }

        public final void setPolicy(String policy) {
            this.policy = policy;
        }

        @Override
        public final Builder policy(String policy) {
            this.policy = policy;
            return this;
        }

        public final CdnAuthConfiguration.Builder getCdnAuthConfiguration() {
            return cdnAuthConfiguration != null ? cdnAuthConfiguration.toBuilder() : null;
        }

        public final void setCdnAuthConfiguration(CdnAuthConfiguration.BuilderImpl cdnAuthConfiguration) {
            this.cdnAuthConfiguration = cdnAuthConfiguration != null ? cdnAuthConfiguration.build() : null;
        }

        @Override
        public final Builder cdnAuthConfiguration(CdnAuthConfiguration cdnAuthConfiguration) {
            this.cdnAuthConfiguration = cdnAuthConfiguration;
            return this;
        }

        @Override
        public GetOriginEndpointPolicyResponse build() {
            return new GetOriginEndpointPolicyResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
