/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediapackagev2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Retrieve the DASH manifest configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetDashManifestConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<GetDashManifestConfiguration.Builder, GetDashManifestConfiguration> {
    private static final SdkField<String> MANIFEST_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ManifestName").getter(getter(GetDashManifestConfiguration::manifestName))
            .setter(setter(Builder::manifestName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManifestName").build()).build();

    private static final SdkField<String> URL_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Url")
            .getter(getter(GetDashManifestConfiguration::url)).setter(setter(Builder::url))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Url").build()).build();

    private static final SdkField<Integer> MANIFEST_WINDOW_SECONDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ManifestWindowSeconds").getter(getter(GetDashManifestConfiguration::manifestWindowSeconds))
            .setter(setter(Builder::manifestWindowSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManifestWindowSeconds").build())
            .build();

    private static final SdkField<FilterConfiguration> FILTER_CONFIGURATION_FIELD = SdkField
            .<FilterConfiguration> builder(MarshallingType.SDK_POJO).memberName("FilterConfiguration")
            .getter(getter(GetDashManifestConfiguration::filterConfiguration)).setter(setter(Builder::filterConfiguration))
            .constructor(FilterConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FilterConfiguration").build())
            .build();

    private static final SdkField<Integer> MIN_UPDATE_PERIOD_SECONDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MinUpdatePeriodSeconds").getter(getter(GetDashManifestConfiguration::minUpdatePeriodSeconds))
            .setter(setter(Builder::minUpdatePeriodSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinUpdatePeriodSeconds").build())
            .build();

    private static final SdkField<Integer> MIN_BUFFER_TIME_SECONDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MinBufferTimeSeconds").getter(getter(GetDashManifestConfiguration::minBufferTimeSeconds))
            .setter(setter(Builder::minBufferTimeSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinBufferTimeSeconds").build())
            .build();

    private static final SdkField<Integer> SUGGESTED_PRESENTATION_DELAY_SECONDS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("SuggestedPresentationDelaySeconds")
            .getter(getter(GetDashManifestConfiguration::suggestedPresentationDelaySeconds))
            .setter(setter(Builder::suggestedPresentationDelaySeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SuggestedPresentationDelaySeconds")
                    .build()).build();

    private static final SdkField<String> SEGMENT_TEMPLATE_FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SegmentTemplateFormat").getter(getter(GetDashManifestConfiguration::segmentTemplateFormatAsString))
            .setter(setter(Builder::segmentTemplateFormat))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SegmentTemplateFormat").build())
            .build();

    private static final SdkField<List<String>> PERIOD_TRIGGERS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("PeriodTriggers")
            .getter(getter(GetDashManifestConfiguration::periodTriggersAsStrings))
            .setter(setter(Builder::periodTriggersWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PeriodTriggers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<ScteDash> SCTE_DASH_FIELD = SdkField.<ScteDash> builder(MarshallingType.SDK_POJO)
            .memberName("ScteDash").getter(getter(GetDashManifestConfiguration::scteDash)).setter(setter(Builder::scteDash))
            .constructor(ScteDash::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScteDash").build()).build();

    private static final SdkField<String> DRM_SIGNALING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DrmSignaling").getter(getter(GetDashManifestConfiguration::drmSignalingAsString))
            .setter(setter(Builder::drmSignaling))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DrmSignaling").build()).build();

    private static final SdkField<DashUtcTiming> UTC_TIMING_FIELD = SdkField.<DashUtcTiming> builder(MarshallingType.SDK_POJO)
            .memberName("UtcTiming").getter(getter(GetDashManifestConfiguration::utcTiming)).setter(setter(Builder::utcTiming))
            .constructor(DashUtcTiming::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UtcTiming").build()).build();

    private static final SdkField<List<String>> PROFILES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Profiles")
            .getter(getter(GetDashManifestConfiguration::profilesAsStrings))
            .setter(setter(Builder::profilesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Profiles").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<DashBaseUrl>> BASE_URLS_FIELD = SdkField
            .<List<DashBaseUrl>> builder(MarshallingType.LIST)
            .memberName("BaseUrls")
            .getter(getter(GetDashManifestConfiguration::baseUrls))
            .setter(setter(Builder::baseUrls))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BaseUrls").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DashBaseUrl> builder(MarshallingType.SDK_POJO)
                                            .constructor(DashBaseUrl::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<DashProgramInformation> PROGRAM_INFORMATION_FIELD = SdkField
            .<DashProgramInformation> builder(MarshallingType.SDK_POJO).memberName("ProgramInformation")
            .getter(getter(GetDashManifestConfiguration::programInformation)).setter(setter(Builder::programInformation))
            .constructor(DashProgramInformation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProgramInformation").build())
            .build();

    private static final SdkField<DashDvbSettings> DVB_SETTINGS_FIELD = SdkField
            .<DashDvbSettings> builder(MarshallingType.SDK_POJO).memberName("DvbSettings")
            .getter(getter(GetDashManifestConfiguration::dvbSettings)).setter(setter(Builder::dvbSettings))
            .constructor(DashDvbSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DvbSettings").build()).build();

    private static final SdkField<String> COMPACTNESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Compactness").getter(getter(GetDashManifestConfiguration::compactnessAsString))
            .setter(setter(Builder::compactness))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Compactness").build()).build();

    private static final SdkField<DashSubtitleConfiguration> SUBTITLE_CONFIGURATION_FIELD = SdkField
            .<DashSubtitleConfiguration> builder(MarshallingType.SDK_POJO).memberName("SubtitleConfiguration")
            .getter(getter(GetDashManifestConfiguration::subtitleConfiguration)).setter(setter(Builder::subtitleConfiguration))
            .constructor(DashSubtitleConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubtitleConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MANIFEST_NAME_FIELD,
            URL_FIELD, MANIFEST_WINDOW_SECONDS_FIELD, FILTER_CONFIGURATION_FIELD, MIN_UPDATE_PERIOD_SECONDS_FIELD,
            MIN_BUFFER_TIME_SECONDS_FIELD, SUGGESTED_PRESENTATION_DELAY_SECONDS_FIELD, SEGMENT_TEMPLATE_FORMAT_FIELD,
            PERIOD_TRIGGERS_FIELD, SCTE_DASH_FIELD, DRM_SIGNALING_FIELD, UTC_TIMING_FIELD, PROFILES_FIELD, BASE_URLS_FIELD,
            PROGRAM_INFORMATION_FIELD, DVB_SETTINGS_FIELD, COMPACTNESS_FIELD, SUBTITLE_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String manifestName;

    private final String url;

    private final Integer manifestWindowSeconds;

    private final FilterConfiguration filterConfiguration;

    private final Integer minUpdatePeriodSeconds;

    private final Integer minBufferTimeSeconds;

    private final Integer suggestedPresentationDelaySeconds;

    private final String segmentTemplateFormat;

    private final List<String> periodTriggers;

    private final ScteDash scteDash;

    private final String drmSignaling;

    private final DashUtcTiming utcTiming;

    private final List<String> profiles;

    private final List<DashBaseUrl> baseUrls;

    private final DashProgramInformation programInformation;

    private final DashDvbSettings dvbSettings;

    private final String compactness;

    private final DashSubtitleConfiguration subtitleConfiguration;

    private GetDashManifestConfiguration(BuilderImpl builder) {
        this.manifestName = builder.manifestName;
        this.url = builder.url;
        this.manifestWindowSeconds = builder.manifestWindowSeconds;
        this.filterConfiguration = builder.filterConfiguration;
        this.minUpdatePeriodSeconds = builder.minUpdatePeriodSeconds;
        this.minBufferTimeSeconds = builder.minBufferTimeSeconds;
        this.suggestedPresentationDelaySeconds = builder.suggestedPresentationDelaySeconds;
        this.segmentTemplateFormat = builder.segmentTemplateFormat;
        this.periodTriggers = builder.periodTriggers;
        this.scteDash = builder.scteDash;
        this.drmSignaling = builder.drmSignaling;
        this.utcTiming = builder.utcTiming;
        this.profiles = builder.profiles;
        this.baseUrls = builder.baseUrls;
        this.programInformation = builder.programInformation;
        this.dvbSettings = builder.dvbSettings;
        this.compactness = builder.compactness;
        this.subtitleConfiguration = builder.subtitleConfiguration;
    }

    /**
     * <p>
     * A short string that's appended to the endpoint URL. The manifest name creates a unique path to this endpoint. If
     * you don't enter a value, MediaPackage uses the default manifest name, index.
     * </p>
     * 
     * @return A short string that's appended to the endpoint URL. The manifest name creates a unique path to this
     *         endpoint. If you don't enter a value, MediaPackage uses the default manifest name, index.
     */
    public final String manifestName() {
        return manifestName;
    }

    /**
     * <p>
     * The egress domain URL for stream delivery from MediaPackage.
     * </p>
     * 
     * @return The egress domain URL for stream delivery from MediaPackage.
     */
    public final String url() {
        return url;
    }

    /**
     * <p>
     * The total duration (in seconds) of the manifest's content.
     * </p>
     * 
     * @return The total duration (in seconds) of the manifest's content.
     */
    public final Integer manifestWindowSeconds() {
        return manifestWindowSeconds;
    }

    /**
     * Returns the value of the FilterConfiguration property for this object.
     * 
     * @return The value of the FilterConfiguration property for this object.
     */
    public final FilterConfiguration filterConfiguration() {
        return filterConfiguration;
    }

    /**
     * <p>
     * Minimum amount of time (in seconds) that the player should wait before requesting updates to the manifest.
     * </p>
     * 
     * @return Minimum amount of time (in seconds) that the player should wait before requesting updates to the
     *         manifest.
     */
    public final Integer minUpdatePeriodSeconds() {
        return minUpdatePeriodSeconds;
    }

    /**
     * <p>
     * Minimum amount of content (in seconds) that a player must keep available in the buffer.
     * </p>
     * 
     * @return Minimum amount of content (in seconds) that a player must keep available in the buffer.
     */
    public final Integer minBufferTimeSeconds() {
        return minBufferTimeSeconds;
    }

    /**
     * <p>
     * The amount of time (in seconds) that the player should be from the end of the manifest.
     * </p>
     * 
     * @return The amount of time (in seconds) that the player should be from the end of the manifest.
     */
    public final Integer suggestedPresentationDelaySeconds() {
        return suggestedPresentationDelaySeconds;
    }

    /**
     * <p>
     * Determines the type of variable used in the <code>media</code> URL of the <code>SegmentTemplate</code> tag in the
     * manifest. Also specifies if segment timeline information is included in <code>SegmentTimeline</code> or
     * <code>SegmentTemplate</code>.
     * </p>
     * <p>
     * Value description:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>NUMBER_WITH_TIMELINE</code> - The <code>$Number$</code> variable is used in the <code>media</code> URL. The
     * value of this variable is the sequential number of the segment. A full <code>SegmentTimeline</code> object is
     * presented in each <code>SegmentTemplate</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #segmentTemplateFormat} will return {@link DashSegmentTemplateFormat#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #segmentTemplateFormatAsString}.
     * </p>
     * 
     * @return Determines the type of variable used in the <code>media</code> URL of the <code>SegmentTemplate</code>
     *         tag in the manifest. Also specifies if segment timeline information is included in
     *         <code>SegmentTimeline</code> or <code>SegmentTemplate</code>.</p>
     *         <p>
     *         Value description:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>NUMBER_WITH_TIMELINE</code> - The <code>$Number$</code> variable is used in the <code>media</code>
     *         URL. The value of this variable is the sequential number of the segment. A full
     *         <code>SegmentTimeline</code> object is presented in each <code>SegmentTemplate</code>.
     *         </p>
     *         </li>
     * @see DashSegmentTemplateFormat
     */
    public final DashSegmentTemplateFormat segmentTemplateFormat() {
        return DashSegmentTemplateFormat.fromValue(segmentTemplateFormat);
    }

    /**
     * <p>
     * Determines the type of variable used in the <code>media</code> URL of the <code>SegmentTemplate</code> tag in the
     * manifest. Also specifies if segment timeline information is included in <code>SegmentTimeline</code> or
     * <code>SegmentTemplate</code>.
     * </p>
     * <p>
     * Value description:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>NUMBER_WITH_TIMELINE</code> - The <code>$Number$</code> variable is used in the <code>media</code> URL. The
     * value of this variable is the sequential number of the segment. A full <code>SegmentTimeline</code> object is
     * presented in each <code>SegmentTemplate</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #segmentTemplateFormat} will return {@link DashSegmentTemplateFormat#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #segmentTemplateFormatAsString}.
     * </p>
     * 
     * @return Determines the type of variable used in the <code>media</code> URL of the <code>SegmentTemplate</code>
     *         tag in the manifest. Also specifies if segment timeline information is included in
     *         <code>SegmentTimeline</code> or <code>SegmentTemplate</code>.</p>
     *         <p>
     *         Value description:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>NUMBER_WITH_TIMELINE</code> - The <code>$Number$</code> variable is used in the <code>media</code>
     *         URL. The value of this variable is the sequential number of the segment. A full
     *         <code>SegmentTimeline</code> object is presented in each <code>SegmentTemplate</code>.
     *         </p>
     *         </li>
     * @see DashSegmentTemplateFormat
     */
    public final String segmentTemplateFormatAsString() {
        return segmentTemplateFormat;
    }

    /**
     * <p>
     * A list of triggers that controls when AWS Elemental MediaPackage separates the MPEG-DASH manifest into multiple
     * periods. Leave this value empty to indicate that the manifest is contained all in one period. For more
     * information about periods in the DASH manifest, see <a
     * href="https://docs.aws.amazon.com/mediapackage/latest/userguide/multi-period.html">Multi-period DASH in AWS
     * Elemental MediaPackage</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPeriodTriggers} method.
     * </p>
     * 
     * @return A list of triggers that controls when AWS Elemental MediaPackage separates the MPEG-DASH manifest into
     *         multiple periods. Leave this value empty to indicate that the manifest is contained all in one period.
     *         For more information about periods in the DASH manifest, see <a
     *         href="https://docs.aws.amazon.com/mediapackage/latest/userguide/multi-period.html">Multi-period DASH in
     *         AWS Elemental MediaPackage</a>.
     */
    public final List<DashPeriodTrigger> periodTriggers() {
        return DashPeriodTriggersCopier.copyStringToEnum(periodTriggers);
    }

    /**
     * For responses, this returns true if the service returned a value for the PeriodTriggers property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPeriodTriggers() {
        return periodTriggers != null && !(periodTriggers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of triggers that controls when AWS Elemental MediaPackage separates the MPEG-DASH manifest into multiple
     * periods. Leave this value empty to indicate that the manifest is contained all in one period. For more
     * information about periods in the DASH manifest, see <a
     * href="https://docs.aws.amazon.com/mediapackage/latest/userguide/multi-period.html">Multi-period DASH in AWS
     * Elemental MediaPackage</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPeriodTriggers} method.
     * </p>
     * 
     * @return A list of triggers that controls when AWS Elemental MediaPackage separates the MPEG-DASH manifest into
     *         multiple periods. Leave this value empty to indicate that the manifest is contained all in one period.
     *         For more information about periods in the DASH manifest, see <a
     *         href="https://docs.aws.amazon.com/mediapackage/latest/userguide/multi-period.html">Multi-period DASH in
     *         AWS Elemental MediaPackage</a>.
     */
    public final List<String> periodTriggersAsStrings() {
        return periodTriggers;
    }

    /**
     * <p>
     * The SCTE configuration.
     * </p>
     * 
     * @return The SCTE configuration.
     */
    public final ScteDash scteDash() {
        return scteDash;
    }

    /**
     * <p>
     * Determines how the DASH manifest signals the DRM content.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #drmSignaling} will
     * return {@link DashDrmSignaling#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #drmSignalingAsString}.
     * </p>
     * 
     * @return Determines how the DASH manifest signals the DRM content.
     * @see DashDrmSignaling
     */
    public final DashDrmSignaling drmSignaling() {
        return DashDrmSignaling.fromValue(drmSignaling);
    }

    /**
     * <p>
     * Determines how the DASH manifest signals the DRM content.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #drmSignaling} will
     * return {@link DashDrmSignaling#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #drmSignalingAsString}.
     * </p>
     * 
     * @return Determines how the DASH manifest signals the DRM content.
     * @see DashDrmSignaling
     */
    public final String drmSignalingAsString() {
        return drmSignaling;
    }

    /**
     * <p>
     * Determines the type of UTC timing included in the DASH Media Presentation Description (MPD).
     * </p>
     * 
     * @return Determines the type of UTC timing included in the DASH Media Presentation Description (MPD).
     */
    public final DashUtcTiming utcTiming() {
        return utcTiming;
    }

    /**
     * <p>
     * The profile that the output is compliant with.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasProfiles} method.
     * </p>
     * 
     * @return The profile that the output is compliant with.
     */
    public final List<DashProfile> profiles() {
        return DashProfilesCopier.copyStringToEnum(profiles);
    }

    /**
     * For responses, this returns true if the service returned a value for the Profiles property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasProfiles() {
        return profiles != null && !(profiles instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The profile that the output is compliant with.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasProfiles} method.
     * </p>
     * 
     * @return The profile that the output is compliant with.
     */
    public final List<String> profilesAsStrings() {
        return profiles;
    }

    /**
     * For responses, this returns true if the service returned a value for the BaseUrls property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasBaseUrls() {
        return baseUrls != null && !(baseUrls instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The base URL to use for retrieving segments.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasBaseUrls} method.
     * </p>
     * 
     * @return The base URL to use for retrieving segments.
     */
    public final List<DashBaseUrl> baseUrls() {
        return baseUrls;
    }

    /**
     * <p>
     * Details about the content that you want MediaPackage to pass through in the manifest to the playback device.
     * </p>
     * 
     * @return Details about the content that you want MediaPackage to pass through in the manifest to the playback
     *         device.
     */
    public final DashProgramInformation programInformation() {
        return programInformation;
    }

    /**
     * <p>
     * For endpoints that use the DVB-DASH profile only. The font download and error reporting information that you want
     * MediaPackage to pass through to the manifest.
     * </p>
     * 
     * @return For endpoints that use the DVB-DASH profile only. The font download and error reporting information that
     *         you want MediaPackage to pass through to the manifest.
     */
    public final DashDvbSettings dvbSettings() {
        return dvbSettings;
    }

    /**
     * <p>
     * The layout of the DASH manifest that MediaPackage produces. <code>STANDARD</code> indicates a default manifest,
     * which is compacted. <code>NONE</code> indicates a full manifest.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #compactness} will
     * return {@link DashCompactness#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #compactnessAsString}.
     * </p>
     * 
     * @return The layout of the DASH manifest that MediaPackage produces. <code>STANDARD</code> indicates a default
     *         manifest, which is compacted. <code>NONE</code> indicates a full manifest.
     * @see DashCompactness
     */
    public final DashCompactness compactness() {
        return DashCompactness.fromValue(compactness);
    }

    /**
     * <p>
     * The layout of the DASH manifest that MediaPackage produces. <code>STANDARD</code> indicates a default manifest,
     * which is compacted. <code>NONE</code> indicates a full manifest.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #compactness} will
     * return {@link DashCompactness#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #compactnessAsString}.
     * </p>
     * 
     * @return The layout of the DASH manifest that MediaPackage produces. <code>STANDARD</code> indicates a default
     *         manifest, which is compacted. <code>NONE</code> indicates a full manifest.
     * @see DashCompactness
     */
    public final String compactnessAsString() {
        return compactness;
    }

    /**
     * <p>
     * The configuration for DASH subtitles.
     * </p>
     * 
     * @return The configuration for DASH subtitles.
     */
    public final DashSubtitleConfiguration subtitleConfiguration() {
        return subtitleConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(manifestName());
        hashCode = 31 * hashCode + Objects.hashCode(url());
        hashCode = 31 * hashCode + Objects.hashCode(manifestWindowSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(filterConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(minUpdatePeriodSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(minBufferTimeSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(suggestedPresentationDelaySeconds());
        hashCode = 31 * hashCode + Objects.hashCode(segmentTemplateFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasPeriodTriggers() ? periodTriggersAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(scteDash());
        hashCode = 31 * hashCode + Objects.hashCode(drmSignalingAsString());
        hashCode = 31 * hashCode + Objects.hashCode(utcTiming());
        hashCode = 31 * hashCode + Objects.hashCode(hasProfiles() ? profilesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasBaseUrls() ? baseUrls() : null);
        hashCode = 31 * hashCode + Objects.hashCode(programInformation());
        hashCode = 31 * hashCode + Objects.hashCode(dvbSettings());
        hashCode = 31 * hashCode + Objects.hashCode(compactnessAsString());
        hashCode = 31 * hashCode + Objects.hashCode(subtitleConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDashManifestConfiguration)) {
            return false;
        }
        GetDashManifestConfiguration other = (GetDashManifestConfiguration) obj;
        return Objects.equals(manifestName(), other.manifestName()) && Objects.equals(url(), other.url())
                && Objects.equals(manifestWindowSeconds(), other.manifestWindowSeconds())
                && Objects.equals(filterConfiguration(), other.filterConfiguration())
                && Objects.equals(minUpdatePeriodSeconds(), other.minUpdatePeriodSeconds())
                && Objects.equals(minBufferTimeSeconds(), other.minBufferTimeSeconds())
                && Objects.equals(suggestedPresentationDelaySeconds(), other.suggestedPresentationDelaySeconds())
                && Objects.equals(segmentTemplateFormatAsString(), other.segmentTemplateFormatAsString())
                && hasPeriodTriggers() == other.hasPeriodTriggers()
                && Objects.equals(periodTriggersAsStrings(), other.periodTriggersAsStrings())
                && Objects.equals(scteDash(), other.scteDash())
                && Objects.equals(drmSignalingAsString(), other.drmSignalingAsString())
                && Objects.equals(utcTiming(), other.utcTiming()) && hasProfiles() == other.hasProfiles()
                && Objects.equals(profilesAsStrings(), other.profilesAsStrings()) && hasBaseUrls() == other.hasBaseUrls()
                && Objects.equals(baseUrls(), other.baseUrls())
                && Objects.equals(programInformation(), other.programInformation())
                && Objects.equals(dvbSettings(), other.dvbSettings())
                && Objects.equals(compactnessAsString(), other.compactnessAsString())
                && Objects.equals(subtitleConfiguration(), other.subtitleConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetDashManifestConfiguration").add("ManifestName", manifestName()).add("Url", url())
                .add("ManifestWindowSeconds", manifestWindowSeconds()).add("FilterConfiguration", filterConfiguration())
                .add("MinUpdatePeriodSeconds", minUpdatePeriodSeconds()).add("MinBufferTimeSeconds", minBufferTimeSeconds())
                .add("SuggestedPresentationDelaySeconds", suggestedPresentationDelaySeconds())
                .add("SegmentTemplateFormat", segmentTemplateFormatAsString())
                .add("PeriodTriggers", hasPeriodTriggers() ? periodTriggersAsStrings() : null).add("ScteDash", scteDash())
                .add("DrmSignaling", drmSignalingAsString()).add("UtcTiming", utcTiming())
                .add("Profiles", hasProfiles() ? profilesAsStrings() : null).add("BaseUrls", hasBaseUrls() ? baseUrls() : null)
                .add("ProgramInformation", programInformation()).add("DvbSettings", dvbSettings())
                .add("Compactness", compactnessAsString()).add("SubtitleConfiguration", subtitleConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ManifestName":
            return Optional.ofNullable(clazz.cast(manifestName()));
        case "Url":
            return Optional.ofNullable(clazz.cast(url()));
        case "ManifestWindowSeconds":
            return Optional.ofNullable(clazz.cast(manifestWindowSeconds()));
        case "FilterConfiguration":
            return Optional.ofNullable(clazz.cast(filterConfiguration()));
        case "MinUpdatePeriodSeconds":
            return Optional.ofNullable(clazz.cast(minUpdatePeriodSeconds()));
        case "MinBufferTimeSeconds":
            return Optional.ofNullable(clazz.cast(minBufferTimeSeconds()));
        case "SuggestedPresentationDelaySeconds":
            return Optional.ofNullable(clazz.cast(suggestedPresentationDelaySeconds()));
        case "SegmentTemplateFormat":
            return Optional.ofNullable(clazz.cast(segmentTemplateFormatAsString()));
        case "PeriodTriggers":
            return Optional.ofNullable(clazz.cast(periodTriggersAsStrings()));
        case "ScteDash":
            return Optional.ofNullable(clazz.cast(scteDash()));
        case "DrmSignaling":
            return Optional.ofNullable(clazz.cast(drmSignalingAsString()));
        case "UtcTiming":
            return Optional.ofNullable(clazz.cast(utcTiming()));
        case "Profiles":
            return Optional.ofNullable(clazz.cast(profilesAsStrings()));
        case "BaseUrls":
            return Optional.ofNullable(clazz.cast(baseUrls()));
        case "ProgramInformation":
            return Optional.ofNullable(clazz.cast(programInformation()));
        case "DvbSettings":
            return Optional.ofNullable(clazz.cast(dvbSettings()));
        case "Compactness":
            return Optional.ofNullable(clazz.cast(compactnessAsString()));
        case "SubtitleConfiguration":
            return Optional.ofNullable(clazz.cast(subtitleConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ManifestName", MANIFEST_NAME_FIELD);
        map.put("Url", URL_FIELD);
        map.put("ManifestWindowSeconds", MANIFEST_WINDOW_SECONDS_FIELD);
        map.put("FilterConfiguration", FILTER_CONFIGURATION_FIELD);
        map.put("MinUpdatePeriodSeconds", MIN_UPDATE_PERIOD_SECONDS_FIELD);
        map.put("MinBufferTimeSeconds", MIN_BUFFER_TIME_SECONDS_FIELD);
        map.put("SuggestedPresentationDelaySeconds", SUGGESTED_PRESENTATION_DELAY_SECONDS_FIELD);
        map.put("SegmentTemplateFormat", SEGMENT_TEMPLATE_FORMAT_FIELD);
        map.put("PeriodTriggers", PERIOD_TRIGGERS_FIELD);
        map.put("ScteDash", SCTE_DASH_FIELD);
        map.put("DrmSignaling", DRM_SIGNALING_FIELD);
        map.put("UtcTiming", UTC_TIMING_FIELD);
        map.put("Profiles", PROFILES_FIELD);
        map.put("BaseUrls", BASE_URLS_FIELD);
        map.put("ProgramInformation", PROGRAM_INFORMATION_FIELD);
        map.put("DvbSettings", DVB_SETTINGS_FIELD);
        map.put("Compactness", COMPACTNESS_FIELD);
        map.put("SubtitleConfiguration", SUBTITLE_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetDashManifestConfiguration, T> g) {
        return obj -> g.apply((GetDashManifestConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GetDashManifestConfiguration> {
        /**
         * <p>
         * A short string that's appended to the endpoint URL. The manifest name creates a unique path to this endpoint.
         * If you don't enter a value, MediaPackage uses the default manifest name, index.
         * </p>
         * 
         * @param manifestName
         *        A short string that's appended to the endpoint URL. The manifest name creates a unique path to this
         *        endpoint. If you don't enter a value, MediaPackage uses the default manifest name, index.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder manifestName(String manifestName);

        /**
         * <p>
         * The egress domain URL for stream delivery from MediaPackage.
         * </p>
         * 
         * @param url
         *        The egress domain URL for stream delivery from MediaPackage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder url(String url);

        /**
         * <p>
         * The total duration (in seconds) of the manifest's content.
         * </p>
         * 
         * @param manifestWindowSeconds
         *        The total duration (in seconds) of the manifest's content.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder manifestWindowSeconds(Integer manifestWindowSeconds);

        /**
         * Sets the value of the FilterConfiguration property for this object.
         *
         * @param filterConfiguration
         *        The new value for the FilterConfiguration property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterConfiguration(FilterConfiguration filterConfiguration);

        /**
         * Sets the value of the FilterConfiguration property for this object.
         *
         * This is a convenience method that creates an instance of the {@link FilterConfiguration.Builder} avoiding the
         * need to create one manually via {@link FilterConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FilterConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #filterConfiguration(FilterConfiguration)}.
         * 
         * @param filterConfiguration
         *        a consumer that will call methods on {@link FilterConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filterConfiguration(FilterConfiguration)
         */
        default Builder filterConfiguration(Consumer<FilterConfiguration.Builder> filterConfiguration) {
            return filterConfiguration(FilterConfiguration.builder().applyMutation(filterConfiguration).build());
        }

        /**
         * <p>
         * Minimum amount of time (in seconds) that the player should wait before requesting updates to the manifest.
         * </p>
         * 
         * @param minUpdatePeriodSeconds
         *        Minimum amount of time (in seconds) that the player should wait before requesting updates to the
         *        manifest.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minUpdatePeriodSeconds(Integer minUpdatePeriodSeconds);

        /**
         * <p>
         * Minimum amount of content (in seconds) that a player must keep available in the buffer.
         * </p>
         * 
         * @param minBufferTimeSeconds
         *        Minimum amount of content (in seconds) that a player must keep available in the buffer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minBufferTimeSeconds(Integer minBufferTimeSeconds);

        /**
         * <p>
         * The amount of time (in seconds) that the player should be from the end of the manifest.
         * </p>
         * 
         * @param suggestedPresentationDelaySeconds
         *        The amount of time (in seconds) that the player should be from the end of the manifest.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder suggestedPresentationDelaySeconds(Integer suggestedPresentationDelaySeconds);

        /**
         * <p>
         * Determines the type of variable used in the <code>media</code> URL of the <code>SegmentTemplate</code> tag in
         * the manifest. Also specifies if segment timeline information is included in <code>SegmentTimeline</code> or
         * <code>SegmentTemplate</code>.
         * </p>
         * <p>
         * Value description:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>NUMBER_WITH_TIMELINE</code> - The <code>$Number$</code> variable is used in the <code>media</code> URL.
         * The value of this variable is the sequential number of the segment. A full <code>SegmentTimeline</code>
         * object is presented in each <code>SegmentTemplate</code>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param segmentTemplateFormat
         *        Determines the type of variable used in the <code>media</code> URL of the <code>SegmentTemplate</code>
         *        tag in the manifest. Also specifies if segment timeline information is included in
         *        <code>SegmentTimeline</code> or <code>SegmentTemplate</code>.</p>
         *        <p>
         *        Value description:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>NUMBER_WITH_TIMELINE</code> - The <code>$Number$</code> variable is used in the
         *        <code>media</code> URL. The value of this variable is the sequential number of the segment. A full
         *        <code>SegmentTimeline</code> object is presented in each <code>SegmentTemplate</code>.
         *        </p>
         *        </li>
         * @see DashSegmentTemplateFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DashSegmentTemplateFormat
         */
        Builder segmentTemplateFormat(String segmentTemplateFormat);

        /**
         * <p>
         * Determines the type of variable used in the <code>media</code> URL of the <code>SegmentTemplate</code> tag in
         * the manifest. Also specifies if segment timeline information is included in <code>SegmentTimeline</code> or
         * <code>SegmentTemplate</code>.
         * </p>
         * <p>
         * Value description:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>NUMBER_WITH_TIMELINE</code> - The <code>$Number$</code> variable is used in the <code>media</code> URL.
         * The value of this variable is the sequential number of the segment. A full <code>SegmentTimeline</code>
         * object is presented in each <code>SegmentTemplate</code>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param segmentTemplateFormat
         *        Determines the type of variable used in the <code>media</code> URL of the <code>SegmentTemplate</code>
         *        tag in the manifest. Also specifies if segment timeline information is included in
         *        <code>SegmentTimeline</code> or <code>SegmentTemplate</code>.</p>
         *        <p>
         *        Value description:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>NUMBER_WITH_TIMELINE</code> - The <code>$Number$</code> variable is used in the
         *        <code>media</code> URL. The value of this variable is the sequential number of the segment. A full
         *        <code>SegmentTimeline</code> object is presented in each <code>SegmentTemplate</code>.
         *        </p>
         *        </li>
         * @see DashSegmentTemplateFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DashSegmentTemplateFormat
         */
        Builder segmentTemplateFormat(DashSegmentTemplateFormat segmentTemplateFormat);

        /**
         * <p>
         * A list of triggers that controls when AWS Elemental MediaPackage separates the MPEG-DASH manifest into
         * multiple periods. Leave this value empty to indicate that the manifest is contained all in one period. For
         * more information about periods in the DASH manifest, see <a
         * href="https://docs.aws.amazon.com/mediapackage/latest/userguide/multi-period.html">Multi-period DASH in AWS
         * Elemental MediaPackage</a>.
         * </p>
         * 
         * @param periodTriggers
         *        A list of triggers that controls when AWS Elemental MediaPackage separates the MPEG-DASH manifest into
         *        multiple periods. Leave this value empty to indicate that the manifest is contained all in one period.
         *        For more information about periods in the DASH manifest, see <a
         *        href="https://docs.aws.amazon.com/mediapackage/latest/userguide/multi-period.html">Multi-period DASH
         *        in AWS Elemental MediaPackage</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder periodTriggersWithStrings(Collection<String> periodTriggers);

        /**
         * <p>
         * A list of triggers that controls when AWS Elemental MediaPackage separates the MPEG-DASH manifest into
         * multiple periods. Leave this value empty to indicate that the manifest is contained all in one period. For
         * more information about periods in the DASH manifest, see <a
         * href="https://docs.aws.amazon.com/mediapackage/latest/userguide/multi-period.html">Multi-period DASH in AWS
         * Elemental MediaPackage</a>.
         * </p>
         * 
         * @param periodTriggers
         *        A list of triggers that controls when AWS Elemental MediaPackage separates the MPEG-DASH manifest into
         *        multiple periods. Leave this value empty to indicate that the manifest is contained all in one period.
         *        For more information about periods in the DASH manifest, see <a
         *        href="https://docs.aws.amazon.com/mediapackage/latest/userguide/multi-period.html">Multi-period DASH
         *        in AWS Elemental MediaPackage</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder periodTriggersWithStrings(String... periodTriggers);

        /**
         * <p>
         * A list of triggers that controls when AWS Elemental MediaPackage separates the MPEG-DASH manifest into
         * multiple periods. Leave this value empty to indicate that the manifest is contained all in one period. For
         * more information about periods in the DASH manifest, see <a
         * href="https://docs.aws.amazon.com/mediapackage/latest/userguide/multi-period.html">Multi-period DASH in AWS
         * Elemental MediaPackage</a>.
         * </p>
         * 
         * @param periodTriggers
         *        A list of triggers that controls when AWS Elemental MediaPackage separates the MPEG-DASH manifest into
         *        multiple periods. Leave this value empty to indicate that the manifest is contained all in one period.
         *        For more information about periods in the DASH manifest, see <a
         *        href="https://docs.aws.amazon.com/mediapackage/latest/userguide/multi-period.html">Multi-period DASH
         *        in AWS Elemental MediaPackage</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder periodTriggers(Collection<DashPeriodTrigger> periodTriggers);

        /**
         * <p>
         * A list of triggers that controls when AWS Elemental MediaPackage separates the MPEG-DASH manifest into
         * multiple periods. Leave this value empty to indicate that the manifest is contained all in one period. For
         * more information about periods in the DASH manifest, see <a
         * href="https://docs.aws.amazon.com/mediapackage/latest/userguide/multi-period.html">Multi-period DASH in AWS
         * Elemental MediaPackage</a>.
         * </p>
         * 
         * @param periodTriggers
         *        A list of triggers that controls when AWS Elemental MediaPackage separates the MPEG-DASH manifest into
         *        multiple periods. Leave this value empty to indicate that the manifest is contained all in one period.
         *        For more information about periods in the DASH manifest, see <a
         *        href="https://docs.aws.amazon.com/mediapackage/latest/userguide/multi-period.html">Multi-period DASH
         *        in AWS Elemental MediaPackage</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder periodTriggers(DashPeriodTrigger... periodTriggers);

        /**
         * <p>
         * The SCTE configuration.
         * </p>
         * 
         * @param scteDash
         *        The SCTE configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scteDash(ScteDash scteDash);

        /**
         * <p>
         * The SCTE configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link ScteDash.Builder} avoiding the need to
         * create one manually via {@link ScteDash#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ScteDash.Builder#build()} is called immediately and its result is
         * passed to {@link #scteDash(ScteDash)}.
         * 
         * @param scteDash
         *        a consumer that will call methods on {@link ScteDash.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #scteDash(ScteDash)
         */
        default Builder scteDash(Consumer<ScteDash.Builder> scteDash) {
            return scteDash(ScteDash.builder().applyMutation(scteDash).build());
        }

        /**
         * <p>
         * Determines how the DASH manifest signals the DRM content.
         * </p>
         * 
         * @param drmSignaling
         *        Determines how the DASH manifest signals the DRM content.
         * @see DashDrmSignaling
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DashDrmSignaling
         */
        Builder drmSignaling(String drmSignaling);

        /**
         * <p>
         * Determines how the DASH manifest signals the DRM content.
         * </p>
         * 
         * @param drmSignaling
         *        Determines how the DASH manifest signals the DRM content.
         * @see DashDrmSignaling
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DashDrmSignaling
         */
        Builder drmSignaling(DashDrmSignaling drmSignaling);

        /**
         * <p>
         * Determines the type of UTC timing included in the DASH Media Presentation Description (MPD).
         * </p>
         * 
         * @param utcTiming
         *        Determines the type of UTC timing included in the DASH Media Presentation Description (MPD).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder utcTiming(DashUtcTiming utcTiming);

        /**
         * <p>
         * Determines the type of UTC timing included in the DASH Media Presentation Description (MPD).
         * </p>
         * This is a convenience method that creates an instance of the {@link DashUtcTiming.Builder} avoiding the need
         * to create one manually via {@link DashUtcTiming#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DashUtcTiming.Builder#build()} is called immediately and its
         * result is passed to {@link #utcTiming(DashUtcTiming)}.
         * 
         * @param utcTiming
         *        a consumer that will call methods on {@link DashUtcTiming.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #utcTiming(DashUtcTiming)
         */
        default Builder utcTiming(Consumer<DashUtcTiming.Builder> utcTiming) {
            return utcTiming(DashUtcTiming.builder().applyMutation(utcTiming).build());
        }

        /**
         * <p>
         * The profile that the output is compliant with.
         * </p>
         * 
         * @param profiles
         *        The profile that the output is compliant with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder profilesWithStrings(Collection<String> profiles);

        /**
         * <p>
         * The profile that the output is compliant with.
         * </p>
         * 
         * @param profiles
         *        The profile that the output is compliant with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder profilesWithStrings(String... profiles);

        /**
         * <p>
         * The profile that the output is compliant with.
         * </p>
         * 
         * @param profiles
         *        The profile that the output is compliant with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder profiles(Collection<DashProfile> profiles);

        /**
         * <p>
         * The profile that the output is compliant with.
         * </p>
         * 
         * @param profiles
         *        The profile that the output is compliant with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder profiles(DashProfile... profiles);

        /**
         * <p>
         * The base URL to use for retrieving segments.
         * </p>
         * 
         * @param baseUrls
         *        The base URL to use for retrieving segments.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder baseUrls(Collection<DashBaseUrl> baseUrls);

        /**
         * <p>
         * The base URL to use for retrieving segments.
         * </p>
         * 
         * @param baseUrls
         *        The base URL to use for retrieving segments.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder baseUrls(DashBaseUrl... baseUrls);

        /**
         * <p>
         * The base URL to use for retrieving segments.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.mediapackagev2.model.DashBaseUrl.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.mediapackagev2.model.DashBaseUrl#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.mediapackagev2.model.DashBaseUrl.Builder#build()} is called
         * immediately and its result is passed to {@link #baseUrls(List<DashBaseUrl>)}.
         * 
         * @param baseUrls
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.mediapackagev2.model.DashBaseUrl.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #baseUrls(java.util.Collection<DashBaseUrl>)
         */
        Builder baseUrls(Consumer<DashBaseUrl.Builder>... baseUrls);

        /**
         * <p>
         * Details about the content that you want MediaPackage to pass through in the manifest to the playback device.
         * </p>
         * 
         * @param programInformation
         *        Details about the content that you want MediaPackage to pass through in the manifest to the playback
         *        device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder programInformation(DashProgramInformation programInformation);

        /**
         * <p>
         * Details about the content that you want MediaPackage to pass through in the manifest to the playback device.
         * </p>
         * This is a convenience method that creates an instance of the {@link DashProgramInformation.Builder} avoiding
         * the need to create one manually via {@link DashProgramInformation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DashProgramInformation.Builder#build()} is called immediately and
         * its result is passed to {@link #programInformation(DashProgramInformation)}.
         * 
         * @param programInformation
         *        a consumer that will call methods on {@link DashProgramInformation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #programInformation(DashProgramInformation)
         */
        default Builder programInformation(Consumer<DashProgramInformation.Builder> programInformation) {
            return programInformation(DashProgramInformation.builder().applyMutation(programInformation).build());
        }

        /**
         * <p>
         * For endpoints that use the DVB-DASH profile only. The font download and error reporting information that you
         * want MediaPackage to pass through to the manifest.
         * </p>
         * 
         * @param dvbSettings
         *        For endpoints that use the DVB-DASH profile only. The font download and error reporting information
         *        that you want MediaPackage to pass through to the manifest.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dvbSettings(DashDvbSettings dvbSettings);

        /**
         * <p>
         * For endpoints that use the DVB-DASH profile only. The font download and error reporting information that you
         * want MediaPackage to pass through to the manifest.
         * </p>
         * This is a convenience method that creates an instance of the {@link DashDvbSettings.Builder} avoiding the
         * need to create one manually via {@link DashDvbSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DashDvbSettings.Builder#build()} is called immediately and its
         * result is passed to {@link #dvbSettings(DashDvbSettings)}.
         * 
         * @param dvbSettings
         *        a consumer that will call methods on {@link DashDvbSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dvbSettings(DashDvbSettings)
         */
        default Builder dvbSettings(Consumer<DashDvbSettings.Builder> dvbSettings) {
            return dvbSettings(DashDvbSettings.builder().applyMutation(dvbSettings).build());
        }

        /**
         * <p>
         * The layout of the DASH manifest that MediaPackage produces. <code>STANDARD</code> indicates a default
         * manifest, which is compacted. <code>NONE</code> indicates a full manifest.
         * </p>
         * 
         * @param compactness
         *        The layout of the DASH manifest that MediaPackage produces. <code>STANDARD</code> indicates a default
         *        manifest, which is compacted. <code>NONE</code> indicates a full manifest.
         * @see DashCompactness
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DashCompactness
         */
        Builder compactness(String compactness);

        /**
         * <p>
         * The layout of the DASH manifest that MediaPackage produces. <code>STANDARD</code> indicates a default
         * manifest, which is compacted. <code>NONE</code> indicates a full manifest.
         * </p>
         * 
         * @param compactness
         *        The layout of the DASH manifest that MediaPackage produces. <code>STANDARD</code> indicates a default
         *        manifest, which is compacted. <code>NONE</code> indicates a full manifest.
         * @see DashCompactness
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DashCompactness
         */
        Builder compactness(DashCompactness compactness);

        /**
         * <p>
         * The configuration for DASH subtitles.
         * </p>
         * 
         * @param subtitleConfiguration
         *        The configuration for DASH subtitles.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subtitleConfiguration(DashSubtitleConfiguration subtitleConfiguration);

        /**
         * <p>
         * The configuration for DASH subtitles.
         * </p>
         * This is a convenience method that creates an instance of the {@link DashSubtitleConfiguration.Builder}
         * avoiding the need to create one manually via {@link DashSubtitleConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DashSubtitleConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #subtitleConfiguration(DashSubtitleConfiguration)}.
         * 
         * @param subtitleConfiguration
         *        a consumer that will call methods on {@link DashSubtitleConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #subtitleConfiguration(DashSubtitleConfiguration)
         */
        default Builder subtitleConfiguration(Consumer<DashSubtitleConfiguration.Builder> subtitleConfiguration) {
            return subtitleConfiguration(DashSubtitleConfiguration.builder().applyMutation(subtitleConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String manifestName;

        private String url;

        private Integer manifestWindowSeconds;

        private FilterConfiguration filterConfiguration;

        private Integer minUpdatePeriodSeconds;

        private Integer minBufferTimeSeconds;

        private Integer suggestedPresentationDelaySeconds;

        private String segmentTemplateFormat;

        private List<String> periodTriggers = DefaultSdkAutoConstructList.getInstance();

        private ScteDash scteDash;

        private String drmSignaling;

        private DashUtcTiming utcTiming;

        private List<String> profiles = DefaultSdkAutoConstructList.getInstance();

        private List<DashBaseUrl> baseUrls = DefaultSdkAutoConstructList.getInstance();

        private DashProgramInformation programInformation;

        private DashDvbSettings dvbSettings;

        private String compactness;

        private DashSubtitleConfiguration subtitleConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDashManifestConfiguration model) {
            manifestName(model.manifestName);
            url(model.url);
            manifestWindowSeconds(model.manifestWindowSeconds);
            filterConfiguration(model.filterConfiguration);
            minUpdatePeriodSeconds(model.minUpdatePeriodSeconds);
            minBufferTimeSeconds(model.minBufferTimeSeconds);
            suggestedPresentationDelaySeconds(model.suggestedPresentationDelaySeconds);
            segmentTemplateFormat(model.segmentTemplateFormat);
            periodTriggersWithStrings(model.periodTriggers);
            scteDash(model.scteDash);
            drmSignaling(model.drmSignaling);
            utcTiming(model.utcTiming);
            profilesWithStrings(model.profiles);
            baseUrls(model.baseUrls);
            programInformation(model.programInformation);
            dvbSettings(model.dvbSettings);
            compactness(model.compactness);
            subtitleConfiguration(model.subtitleConfiguration);
        }

        public final String getManifestName() {
            return manifestName;
        }

        public final void setManifestName(String manifestName) {
            this.manifestName = manifestName;
        }

        @Override
        public final Builder manifestName(String manifestName) {
            this.manifestName = manifestName;
            return this;
        }

        public final String getUrl() {
            return url;
        }

        public final void setUrl(String url) {
            this.url = url;
        }

        @Override
        public final Builder url(String url) {
            this.url = url;
            return this;
        }

        public final Integer getManifestWindowSeconds() {
            return manifestWindowSeconds;
        }

        public final void setManifestWindowSeconds(Integer manifestWindowSeconds) {
            this.manifestWindowSeconds = manifestWindowSeconds;
        }

        @Override
        public final Builder manifestWindowSeconds(Integer manifestWindowSeconds) {
            this.manifestWindowSeconds = manifestWindowSeconds;
            return this;
        }

        public final FilterConfiguration.Builder getFilterConfiguration() {
            return filterConfiguration != null ? filterConfiguration.toBuilder() : null;
        }

        public final void setFilterConfiguration(FilterConfiguration.BuilderImpl filterConfiguration) {
            this.filterConfiguration = filterConfiguration != null ? filterConfiguration.build() : null;
        }

        @Override
        public final Builder filterConfiguration(FilterConfiguration filterConfiguration) {
            this.filterConfiguration = filterConfiguration;
            return this;
        }

        public final Integer getMinUpdatePeriodSeconds() {
            return minUpdatePeriodSeconds;
        }

        public final void setMinUpdatePeriodSeconds(Integer minUpdatePeriodSeconds) {
            this.minUpdatePeriodSeconds = minUpdatePeriodSeconds;
        }

        @Override
        public final Builder minUpdatePeriodSeconds(Integer minUpdatePeriodSeconds) {
            this.minUpdatePeriodSeconds = minUpdatePeriodSeconds;
            return this;
        }

        public final Integer getMinBufferTimeSeconds() {
            return minBufferTimeSeconds;
        }

        public final void setMinBufferTimeSeconds(Integer minBufferTimeSeconds) {
            this.minBufferTimeSeconds = minBufferTimeSeconds;
        }

        @Override
        public final Builder minBufferTimeSeconds(Integer minBufferTimeSeconds) {
            this.minBufferTimeSeconds = minBufferTimeSeconds;
            return this;
        }

        public final Integer getSuggestedPresentationDelaySeconds() {
            return suggestedPresentationDelaySeconds;
        }

        public final void setSuggestedPresentationDelaySeconds(Integer suggestedPresentationDelaySeconds) {
            this.suggestedPresentationDelaySeconds = suggestedPresentationDelaySeconds;
        }

        @Override
        public final Builder suggestedPresentationDelaySeconds(Integer suggestedPresentationDelaySeconds) {
            this.suggestedPresentationDelaySeconds = suggestedPresentationDelaySeconds;
            return this;
        }

        public final String getSegmentTemplateFormat() {
            return segmentTemplateFormat;
        }

        public final void setSegmentTemplateFormat(String segmentTemplateFormat) {
            this.segmentTemplateFormat = segmentTemplateFormat;
        }

        @Override
        public final Builder segmentTemplateFormat(String segmentTemplateFormat) {
            this.segmentTemplateFormat = segmentTemplateFormat;
            return this;
        }

        @Override
        public final Builder segmentTemplateFormat(DashSegmentTemplateFormat segmentTemplateFormat) {
            this.segmentTemplateFormat(segmentTemplateFormat == null ? null : segmentTemplateFormat.toString());
            return this;
        }

        public final Collection<String> getPeriodTriggers() {
            if (periodTriggers instanceof SdkAutoConstructList) {
                return null;
            }
            return periodTriggers;
        }

        public final void setPeriodTriggers(Collection<String> periodTriggers) {
            this.periodTriggers = DashPeriodTriggersCopier.copy(periodTriggers);
        }

        @Override
        public final Builder periodTriggersWithStrings(Collection<String> periodTriggers) {
            this.periodTriggers = DashPeriodTriggersCopier.copy(periodTriggers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder periodTriggersWithStrings(String... periodTriggers) {
            periodTriggersWithStrings(Arrays.asList(periodTriggers));
            return this;
        }

        @Override
        public final Builder periodTriggers(Collection<DashPeriodTrigger> periodTriggers) {
            this.periodTriggers = DashPeriodTriggersCopier.copyEnumToString(periodTriggers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder periodTriggers(DashPeriodTrigger... periodTriggers) {
            periodTriggers(Arrays.asList(periodTriggers));
            return this;
        }

        public final ScteDash.Builder getScteDash() {
            return scteDash != null ? scteDash.toBuilder() : null;
        }

        public final void setScteDash(ScteDash.BuilderImpl scteDash) {
            this.scteDash = scteDash != null ? scteDash.build() : null;
        }

        @Override
        public final Builder scteDash(ScteDash scteDash) {
            this.scteDash = scteDash;
            return this;
        }

        public final String getDrmSignaling() {
            return drmSignaling;
        }

        public final void setDrmSignaling(String drmSignaling) {
            this.drmSignaling = drmSignaling;
        }

        @Override
        public final Builder drmSignaling(String drmSignaling) {
            this.drmSignaling = drmSignaling;
            return this;
        }

        @Override
        public final Builder drmSignaling(DashDrmSignaling drmSignaling) {
            this.drmSignaling(drmSignaling == null ? null : drmSignaling.toString());
            return this;
        }

        public final DashUtcTiming.Builder getUtcTiming() {
            return utcTiming != null ? utcTiming.toBuilder() : null;
        }

        public final void setUtcTiming(DashUtcTiming.BuilderImpl utcTiming) {
            this.utcTiming = utcTiming != null ? utcTiming.build() : null;
        }

        @Override
        public final Builder utcTiming(DashUtcTiming utcTiming) {
            this.utcTiming = utcTiming;
            return this;
        }

        public final Collection<String> getProfiles() {
            if (profiles instanceof SdkAutoConstructList) {
                return null;
            }
            return profiles;
        }

        public final void setProfiles(Collection<String> profiles) {
            this.profiles = DashProfilesCopier.copy(profiles);
        }

        @Override
        public final Builder profilesWithStrings(Collection<String> profiles) {
            this.profiles = DashProfilesCopier.copy(profiles);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder profilesWithStrings(String... profiles) {
            profilesWithStrings(Arrays.asList(profiles));
            return this;
        }

        @Override
        public final Builder profiles(Collection<DashProfile> profiles) {
            this.profiles = DashProfilesCopier.copyEnumToString(profiles);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder profiles(DashProfile... profiles) {
            profiles(Arrays.asList(profiles));
            return this;
        }

        public final List<DashBaseUrl.Builder> getBaseUrls() {
            List<DashBaseUrl.Builder> result = DashBaseUrlsCopier.copyToBuilder(this.baseUrls);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBaseUrls(Collection<DashBaseUrl.BuilderImpl> baseUrls) {
            this.baseUrls = DashBaseUrlsCopier.copyFromBuilder(baseUrls);
        }

        @Override
        public final Builder baseUrls(Collection<DashBaseUrl> baseUrls) {
            this.baseUrls = DashBaseUrlsCopier.copy(baseUrls);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder baseUrls(DashBaseUrl... baseUrls) {
            baseUrls(Arrays.asList(baseUrls));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder baseUrls(Consumer<DashBaseUrl.Builder>... baseUrls) {
            baseUrls(Stream.of(baseUrls).map(c -> DashBaseUrl.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final DashProgramInformation.Builder getProgramInformation() {
            return programInformation != null ? programInformation.toBuilder() : null;
        }

        public final void setProgramInformation(DashProgramInformation.BuilderImpl programInformation) {
            this.programInformation = programInformation != null ? programInformation.build() : null;
        }

        @Override
        public final Builder programInformation(DashProgramInformation programInformation) {
            this.programInformation = programInformation;
            return this;
        }

        public final DashDvbSettings.Builder getDvbSettings() {
            return dvbSettings != null ? dvbSettings.toBuilder() : null;
        }

        public final void setDvbSettings(DashDvbSettings.BuilderImpl dvbSettings) {
            this.dvbSettings = dvbSettings != null ? dvbSettings.build() : null;
        }

        @Override
        public final Builder dvbSettings(DashDvbSettings dvbSettings) {
            this.dvbSettings = dvbSettings;
            return this;
        }

        public final String getCompactness() {
            return compactness;
        }

        public final void setCompactness(String compactness) {
            this.compactness = compactness;
        }

        @Override
        public final Builder compactness(String compactness) {
            this.compactness = compactness;
            return this;
        }

        @Override
        public final Builder compactness(DashCompactness compactness) {
            this.compactness(compactness == null ? null : compactness.toString());
            return this;
        }

        public final DashSubtitleConfiguration.Builder getSubtitleConfiguration() {
            return subtitleConfiguration != null ? subtitleConfiguration.toBuilder() : null;
        }

        public final void setSubtitleConfiguration(DashSubtitleConfiguration.BuilderImpl subtitleConfiguration) {
            this.subtitleConfiguration = subtitleConfiguration != null ? subtitleConfiguration.build() : null;
        }

        @Override
        public final Builder subtitleConfiguration(DashSubtitleConfiguration subtitleConfiguration) {
            this.subtitleConfiguration = subtitleConfiguration;
            return this;
        }

        @Override
        public GetDashManifestConfiguration build() {
            return new GetDashManifestConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
