/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediapackagev2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about the content that you want MediaPackage to pass through in the manifest to the playback device.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DashProgramInformation implements SdkPojo, Serializable,
        ToCopyableBuilder<DashProgramInformation.Builder, DashProgramInformation> {
    private static final SdkField<String> TITLE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Title")
            .getter(getter(DashProgramInformation::title)).setter(setter(Builder::title))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Title").build()).build();

    private static final SdkField<String> SOURCE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Source")
            .getter(getter(DashProgramInformation::source)).setter(setter(Builder::source))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Source").build()).build();

    private static final SdkField<String> COPYRIGHT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Copyright").getter(getter(DashProgramInformation::copyright)).setter(setter(Builder::copyright))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Copyright").build()).build();

    private static final SdkField<String> LANGUAGE_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LanguageCode").getter(getter(DashProgramInformation::languageCode))
            .setter(setter(Builder::languageCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LanguageCode").build()).build();

    private static final SdkField<String> MORE_INFORMATION_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MoreInformationUrl").getter(getter(DashProgramInformation::moreInformationUrl))
            .setter(setter(Builder::moreInformationUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MoreInformationUrl").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TITLE_FIELD, SOURCE_FIELD,
            COPYRIGHT_FIELD, LANGUAGE_CODE_FIELD, MORE_INFORMATION_URL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String title;

    private final String source;

    private final String copyright;

    private final String languageCode;

    private final String moreInformationUrl;

    private DashProgramInformation(BuilderImpl builder) {
        this.title = builder.title;
        this.source = builder.source;
        this.copyright = builder.copyright;
        this.languageCode = builder.languageCode;
        this.moreInformationUrl = builder.moreInformationUrl;
    }

    /**
     * <p>
     * The title for the manifest.
     * </p>
     * 
     * @return The title for the manifest.
     */
    public final String title() {
        return title;
    }

    /**
     * <p>
     * Information about the content provider.
     * </p>
     * 
     * @return Information about the content provider.
     */
    public final String source() {
        return source;
    }

    /**
     * <p>
     * A copyright statement about the content.
     * </p>
     * 
     * @return A copyright statement about the content.
     */
    public final String copyright() {
        return copyright;
    }

    /**
     * <p>
     * The language code for this manifest.
     * </p>
     * 
     * @return The language code for this manifest.
     */
    public final String languageCode() {
        return languageCode;
    }

    /**
     * <p>
     * An absolute URL that contains more information about this content.
     * </p>
     * 
     * @return An absolute URL that contains more information about this content.
     */
    public final String moreInformationUrl() {
        return moreInformationUrl;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(title());
        hashCode = 31 * hashCode + Objects.hashCode(source());
        hashCode = 31 * hashCode + Objects.hashCode(copyright());
        hashCode = 31 * hashCode + Objects.hashCode(languageCode());
        hashCode = 31 * hashCode + Objects.hashCode(moreInformationUrl());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DashProgramInformation)) {
            return false;
        }
        DashProgramInformation other = (DashProgramInformation) obj;
        return Objects.equals(title(), other.title()) && Objects.equals(source(), other.source())
                && Objects.equals(copyright(), other.copyright()) && Objects.equals(languageCode(), other.languageCode())
                && Objects.equals(moreInformationUrl(), other.moreInformationUrl());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DashProgramInformation").add("Title", title()).add("Source", source())
                .add("Copyright", copyright()).add("LanguageCode", languageCode())
                .add("MoreInformationUrl", moreInformationUrl()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Title":
            return Optional.ofNullable(clazz.cast(title()));
        case "Source":
            return Optional.ofNullable(clazz.cast(source()));
        case "Copyright":
            return Optional.ofNullable(clazz.cast(copyright()));
        case "LanguageCode":
            return Optional.ofNullable(clazz.cast(languageCode()));
        case "MoreInformationUrl":
            return Optional.ofNullable(clazz.cast(moreInformationUrl()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Title", TITLE_FIELD);
        map.put("Source", SOURCE_FIELD);
        map.put("Copyright", COPYRIGHT_FIELD);
        map.put("LanguageCode", LANGUAGE_CODE_FIELD);
        map.put("MoreInformationUrl", MORE_INFORMATION_URL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DashProgramInformation, T> g) {
        return obj -> g.apply((DashProgramInformation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DashProgramInformation> {
        /**
         * <p>
         * The title for the manifest.
         * </p>
         * 
         * @param title
         *        The title for the manifest.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder title(String title);

        /**
         * <p>
         * Information about the content provider.
         * </p>
         * 
         * @param source
         *        Information about the content provider.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder source(String source);

        /**
         * <p>
         * A copyright statement about the content.
         * </p>
         * 
         * @param copyright
         *        A copyright statement about the content.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder copyright(String copyright);

        /**
         * <p>
         * The language code for this manifest.
         * </p>
         * 
         * @param languageCode
         *        The language code for this manifest.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder languageCode(String languageCode);

        /**
         * <p>
         * An absolute URL that contains more information about this content.
         * </p>
         * 
         * @param moreInformationUrl
         *        An absolute URL that contains more information about this content.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder moreInformationUrl(String moreInformationUrl);
    }

    static final class BuilderImpl implements Builder {
        private String title;

        private String source;

        private String copyright;

        private String languageCode;

        private String moreInformationUrl;

        private BuilderImpl() {
        }

        private BuilderImpl(DashProgramInformation model) {
            title(model.title);
            source(model.source);
            copyright(model.copyright);
            languageCode(model.languageCode);
            moreInformationUrl(model.moreInformationUrl);
        }

        public final String getTitle() {
            return title;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final String getSource() {
            return source;
        }

        public final void setSource(String source) {
            this.source = source;
        }

        @Override
        public final Builder source(String source) {
            this.source = source;
            return this;
        }

        public final String getCopyright() {
            return copyright;
        }

        public final void setCopyright(String copyright) {
            this.copyright = copyright;
        }

        @Override
        public final Builder copyright(String copyright) {
            this.copyright = copyright;
            return this;
        }

        public final String getLanguageCode() {
            return languageCode;
        }

        public final void setLanguageCode(String languageCode) {
            this.languageCode = languageCode;
        }

        @Override
        public final Builder languageCode(String languageCode) {
            this.languageCode = languageCode;
            return this;
        }

        public final String getMoreInformationUrl() {
            return moreInformationUrl;
        }

        public final void setMoreInformationUrl(String moreInformationUrl) {
            this.moreInformationUrl = moreInformationUrl;
        }

        @Override
        public final Builder moreInformationUrl(String moreInformationUrl) {
            this.moreInformationUrl = moreInformationUrl;
            return this;
        }

        @Override
        public DashProgramInformation build() {
            return new DashProgramInformation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
