/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediapackagev2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The settings to enable CDN authorization headers in MediaPackage.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CdnAuthConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<CdnAuthConfiguration.Builder, CdnAuthConfiguration> {
    private static final SdkField<List<String>> CDN_IDENTIFIER_SECRET_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("CdnIdentifierSecretArns")
            .getter(getter(CdnAuthConfiguration::cdnIdentifierSecretArns))
            .setter(setter(Builder::cdnIdentifierSecretArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CdnIdentifierSecretArns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> SECRETS_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SecretsRoleArn").getter(getter(CdnAuthConfiguration::secretsRoleArn))
            .setter(setter(Builder::secretsRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecretsRoleArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CDN_IDENTIFIER_SECRET_ARNS_FIELD, SECRETS_ROLE_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<String> cdnIdentifierSecretArns;

    private final String secretsRoleArn;

    private CdnAuthConfiguration(BuilderImpl builder) {
        this.cdnIdentifierSecretArns = builder.cdnIdentifierSecretArns;
        this.secretsRoleArn = builder.secretsRoleArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the CdnIdentifierSecretArns property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasCdnIdentifierSecretArns() {
        return cdnIdentifierSecretArns != null && !(cdnIdentifierSecretArns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The ARN for the secret in Secrets Manager that your CDN uses for authorization to access the endpoint.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCdnIdentifierSecretArns} method.
     * </p>
     * 
     * @return The ARN for the secret in Secrets Manager that your CDN uses for authorization to access the endpoint.
     */
    public final List<String> cdnIdentifierSecretArns() {
        return cdnIdentifierSecretArns;
    }

    /**
     * <p>
     * The ARN for the IAM role that gives MediaPackage read access to Secrets Manager and KMS for CDN authorization.
     * </p>
     * 
     * @return The ARN for the IAM role that gives MediaPackage read access to Secrets Manager and KMS for CDN
     *         authorization.
     */
    public final String secretsRoleArn() {
        return secretsRoleArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasCdnIdentifierSecretArns() ? cdnIdentifierSecretArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(secretsRoleArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CdnAuthConfiguration)) {
            return false;
        }
        CdnAuthConfiguration other = (CdnAuthConfiguration) obj;
        return hasCdnIdentifierSecretArns() == other.hasCdnIdentifierSecretArns()
                && Objects.equals(cdnIdentifierSecretArns(), other.cdnIdentifierSecretArns())
                && Objects.equals(secretsRoleArn(), other.secretsRoleArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CdnAuthConfiguration")
                .add("CdnIdentifierSecretArns", hasCdnIdentifierSecretArns() ? cdnIdentifierSecretArns() : null)
                .add("SecretsRoleArn", secretsRoleArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CdnIdentifierSecretArns":
            return Optional.ofNullable(clazz.cast(cdnIdentifierSecretArns()));
        case "SecretsRoleArn":
            return Optional.ofNullable(clazz.cast(secretsRoleArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CdnIdentifierSecretArns", CDN_IDENTIFIER_SECRET_ARNS_FIELD);
        map.put("SecretsRoleArn", SECRETS_ROLE_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CdnAuthConfiguration, T> g) {
        return obj -> g.apply((CdnAuthConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CdnAuthConfiguration> {
        /**
         * <p>
         * The ARN for the secret in Secrets Manager that your CDN uses for authorization to access the endpoint.
         * </p>
         * 
         * @param cdnIdentifierSecretArns
         *        The ARN for the secret in Secrets Manager that your CDN uses for authorization to access the endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cdnIdentifierSecretArns(Collection<String> cdnIdentifierSecretArns);

        /**
         * <p>
         * The ARN for the secret in Secrets Manager that your CDN uses for authorization to access the endpoint.
         * </p>
         * 
         * @param cdnIdentifierSecretArns
         *        The ARN for the secret in Secrets Manager that your CDN uses for authorization to access the endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cdnIdentifierSecretArns(String... cdnIdentifierSecretArns);

        /**
         * <p>
         * The ARN for the IAM role that gives MediaPackage read access to Secrets Manager and KMS for CDN
         * authorization.
         * </p>
         * 
         * @param secretsRoleArn
         *        The ARN for the IAM role that gives MediaPackage read access to Secrets Manager and KMS for CDN
         *        authorization.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secretsRoleArn(String secretsRoleArn);
    }

    static final class BuilderImpl implements Builder {
        private List<String> cdnIdentifierSecretArns = DefaultSdkAutoConstructList.getInstance();

        private String secretsRoleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CdnAuthConfiguration model) {
            cdnIdentifierSecretArns(model.cdnIdentifierSecretArns);
            secretsRoleArn(model.secretsRoleArn);
        }

        public final Collection<String> getCdnIdentifierSecretArns() {
            if (cdnIdentifierSecretArns instanceof SdkAutoConstructList) {
                return null;
            }
            return cdnIdentifierSecretArns;
        }

        public final void setCdnIdentifierSecretArns(Collection<String> cdnIdentifierSecretArns) {
            this.cdnIdentifierSecretArns = CdnAuthConfigurationCdnIdentifierSecretArnsListCopier.copy(cdnIdentifierSecretArns);
        }

        @Override
        public final Builder cdnIdentifierSecretArns(Collection<String> cdnIdentifierSecretArns) {
            this.cdnIdentifierSecretArns = CdnAuthConfigurationCdnIdentifierSecretArnsListCopier.copy(cdnIdentifierSecretArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cdnIdentifierSecretArns(String... cdnIdentifierSecretArns) {
            cdnIdentifierSecretArns(Arrays.asList(cdnIdentifierSecretArns));
            return this;
        }

        public final String getSecretsRoleArn() {
            return secretsRoleArn;
        }

        public final void setSecretsRoleArn(String secretsRoleArn) {
            this.secretsRoleArn = secretsRoleArn;
        }

        @Override
        public final Builder secretsRoleArn(String secretsRoleArn) {
            this.secretsRoleArn = secretsRoleArn;
            return this;
        }

        @Override
        public CdnAuthConfiguration build() {
            return new CdnAuthConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
