/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediapackagev2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ValidationExceptionType {
    CONTAINER_TYPE_IMMUTABLE("CONTAINER_TYPE_IMMUTABLE"),
    INVALID_PAGINATION_TOKEN("INVALID_PAGINATION_TOKEN"),
    INVALID_PAGINATION_MAX_RESULTS("INVALID_PAGINATION_MAX_RESULTS"),
    INVALID_POLICY("INVALID_POLICY"),
    INVALID_ROLE_ARN("INVALID_ROLE_ARN"),
    MANIFEST_NAME_COLLISION("MANIFEST_NAME_COLLISION"),
    ENCRYPTION_METHOD_CONTAINER_TYPE_MISMATCH("ENCRYPTION_METHOD_CONTAINER_TYPE_MISMATCH"),
    CENC_IV_INCOMPATIBLE("CENC_IV_INCOMPATIBLE"),
    ENCRYPTION_CONTRACT_WITHOUT_AUDIO_RENDITION_INCOMPATIBLE("ENCRYPTION_CONTRACT_WITHOUT_AUDIO_RENDITION_INCOMPATIBLE"),
    ENCRYPTION_CONTRACT_WITH_ISM_CONTAINER_INCOMPATIBLE("ENCRYPTION_CONTRACT_WITH_ISM_CONTAINER_INCOMPATIBLE"),
    ENCRYPTION_CONTRACT_UNENCRYPTED("ENCRYPTION_CONTRACT_UNENCRYPTED"),
    ENCRYPTION_CONTRACT_SHARED("ENCRYPTION_CONTRACT_SHARED"),
    NUM_MANIFESTS_LOW("NUM_MANIFESTS_LOW"),
    NUM_MANIFESTS_HIGH("NUM_MANIFESTS_HIGH"),
    MANIFEST_DRM_SYSTEMS_INCOMPATIBLE("MANIFEST_DRM_SYSTEMS_INCOMPATIBLE"),
    DRM_SYSTEMS_ENCRYPTION_METHOD_INCOMPATIBLE("DRM_SYSTEMS_ENCRYPTION_METHOD_INCOMPATIBLE"),
    ROLE_ARN_NOT_ASSUMABLE("ROLE_ARN_NOT_ASSUMABLE"),
    ROLE_ARN_LENGTH_OUT_OF_RANGE("ROLE_ARN_LENGTH_OUT_OF_RANGE"),
    ROLE_ARN_INVALID_FORMAT("ROLE_ARN_INVALID_FORMAT"),
    URL_INVALID("URL_INVALID"),
    URL_SCHEME("URL_SCHEME"),
    URL_USER_INFO("URL_USER_INFO"),
    URL_PORT("URL_PORT"),
    URL_UNKNOWN_HOST("URL_UNKNOWN_HOST"),
    URL_LOCAL_ADDRESS("URL_LOCAL_ADDRESS"),
    URL_LOOPBACK_ADDRESS("URL_LOOPBACK_ADDRESS"),
    URL_LINK_LOCAL_ADDRESS("URL_LINK_LOCAL_ADDRESS"),
    URL_MULTICAST_ADDRESS("URL_MULTICAST_ADDRESS"),
    MEMBER_INVALID("MEMBER_INVALID"),
    MEMBER_MISSING("MEMBER_MISSING"),
    MEMBER_MIN_VALUE("MEMBER_MIN_VALUE"),
    MEMBER_MAX_VALUE("MEMBER_MAX_VALUE"),
    MEMBER_MIN_LENGTH("MEMBER_MIN_LENGTH"),
    MEMBER_MAX_LENGTH("MEMBER_MAX_LENGTH"),
    MEMBER_INVALID_ENUM_VALUE("MEMBER_INVALID_ENUM_VALUE"),
    MEMBER_DOES_NOT_MATCH_PATTERN("MEMBER_DOES_NOT_MATCH_PATTERN"),
    INVALID_MANIFEST_FILTER("INVALID_MANIFEST_FILTER"),
    INVALID_TIME_DELAY_SECONDS("INVALID_TIME_DELAY_SECONDS"),
    END_TIME_EARLIER_THAN_START_TIME("END_TIME_EARLIER_THAN_START_TIME"),
    TS_CONTAINER_TYPE_WITH_DASH_MANIFEST("TS_CONTAINER_TYPE_WITH_DASH_MANIFEST"),
    DIRECT_MODE_WITH_TIMING_SOURCE("DIRECT_MODE_WITH_TIMING_SOURCE"),
    NONE_MODE_WITH_TIMING_SOURCE("NONE_MODE_WITH_TIMING_SOURCE"),
    TIMING_SOURCE_MISSING("TIMING_SOURCE_MISSING"),
    UPDATE_PERIOD_SMALLER_THAN_SEGMENT_DURATION("UPDATE_PERIOD_SMALLER_THAN_SEGMENT_DURATION"),
    PERIOD_TRIGGERS_NONE_SPECIFIED_WITH_ADDITIONAL_VALUES("PERIOD_TRIGGERS_NONE_SPECIFIED_WITH_ADDITIONAL_VALUES"),
    DRM_SIGNALING_MISMATCH_SEGMENT_ENCRYPTION_STATUS("DRM_SIGNALING_MISMATCH_SEGMENT_ENCRYPTION_STATUS"),
    ONLY_CMAF_INPUT_TYPE_ALLOW_FORCE_ENDPOINT_ERROR_CONFIGURATION("ONLY_CMAF_INPUT_TYPE_ALLOW_FORCE_ENDPOINT_ERROR_CONFIGURATION"),
    SOURCE_DISRUPTIONS_ENABLED_INCORRECTLY("SOURCE_DISRUPTIONS_ENABLED_INCORRECTLY"),
    HARVESTED_MANIFEST_HAS_START_END_FILTER_CONFIGURATION("HARVESTED_MANIFEST_HAS_START_END_FILTER_CONFIGURATION"),
    HARVESTED_MANIFEST_NOT_FOUND_ON_ENDPOINT("HARVESTED_MANIFEST_NOT_FOUND_ON_ENDPOINT"),
    TOO_MANY_IN_PROGRESS_HARVEST_JOBS("TOO_MANY_IN_PROGRESS_HARVEST_JOBS"),
    HARVEST_JOB_INELIGIBLE_FOR_CANCELLATION("HARVEST_JOB_INELIGIBLE_FOR_CANCELLATION"),
    INVALID_HARVEST_JOB_DURATION("INVALID_HARVEST_JOB_DURATION"),
    HARVEST_JOB_S3_DESTINATION_MISSING_OR_INCOMPLETE("HARVEST_JOB_S3_DESTINATION_MISSING_OR_INCOMPLETE"),
    HARVEST_JOB_UNABLE_TO_WRITE_TO_S3_DESTINATION("HARVEST_JOB_UNABLE_TO_WRITE_TO_S3_DESTINATION"),
    HARVEST_JOB_CUSTOMER_ENDPOINT_READ_ACCESS_DENIED("HARVEST_JOB_CUSTOMER_ENDPOINT_READ_ACCESS_DENIED"),
    CLIP_START_TIME_WITH_START_OR_END("CLIP_START_TIME_WITH_START_OR_END"),
    START_TAG_TIME_OFFSET_INVALID("START_TAG_TIME_OFFSET_INVALID"),
    INCOMPATIBLE_DASH_PROFILE_DVB_DASH_CONFIGURATION("INCOMPATIBLE_DASH_PROFILE_DVB_DASH_CONFIGURATION"),
    DASH_DVB_ATTRIBUTES_WITHOUT_DVB_DASH_PROFILE("DASH_DVB_ATTRIBUTES_WITHOUT_DVB_DASH_PROFILE"),
    INCOMPATIBLE_DASH_COMPACTNESS_CONFIGURATION("INCOMPATIBLE_DASH_COMPACTNESS_CONFIGURATION"),
    INCOMPATIBLE_XML_ENCODING("INCOMPATIBLE_XML_ENCODING"),
    CMAF_EXCLUDE_SEGMENT_DRM_METADATA_INCOMPATIBLE_CONTAINER_TYPE("CMAF_EXCLUDE_SEGMENT_DRM_METADATA_INCOMPATIBLE_CONTAINER_TYPE"),
    ONLY_CMAF_INPUT_TYPE_ALLOW_MQCS_INPUT_SWITCHING("ONLY_CMAF_INPUT_TYPE_ALLOW_MQCS_INPUT_SWITCHING"),
    ONLY_CMAF_INPUT_TYPE_ALLOW_MQCS_OUTPUT_CONFIGURATION("ONLY_CMAF_INPUT_TYPE_ALLOW_MQCS_OUTPUT_CONFIGURATION"),
    ONLY_CMAF_INPUT_TYPE_ALLOW_PREFERRED_INPUT_CONFIGURATION("ONLY_CMAF_INPUT_TYPE_ALLOW_PREFERRED_INPUT_CONFIGURATION"),
    TS_CONTAINER_TYPE_WITH_MSS_MANIFEST("TS_CONTAINER_TYPE_WITH_MSS_MANIFEST"),
    CMAF_CONTAINER_TYPE_WITH_MSS_MANIFEST("CMAF_CONTAINER_TYPE_WITH_MSS_MANIFEST"),
    ISM_CONTAINER_TYPE_WITH_HLS_MANIFEST("ISM_CONTAINER_TYPE_WITH_HLS_MANIFEST"),
    ISM_CONTAINER_TYPE_WITH_LL_HLS_MANIFEST("ISM_CONTAINER_TYPE_WITH_LL_HLS_MANIFEST"),
    ISM_CONTAINER_TYPE_WITH_DASH_MANIFEST("ISM_CONTAINER_TYPE_WITH_DASH_MANIFEST"),
    ISM_CONTAINER_TYPE_WITH_SCTE("ISM_CONTAINER_TYPE_WITH_SCTE"),
    ISM_CONTAINER_WITH_KEY_ROTATION("ISM_CONTAINER_WITH_KEY_ROTATION"),
    BATCH_GET_SECRET_VALUE_DENIED("BATCH_GET_SECRET_VALUE_DENIED"),
    GET_SECRET_VALUE_DENIED("GET_SECRET_VALUE_DENIED"),
    DESCRIBE_SECRET_DENIED("DESCRIBE_SECRET_DENIED"),
    INVALID_SECRET_FORMAT("INVALID_SECRET_FORMAT"),
    SECRET_IS_NOT_ONE_KEY_VALUE_PAIR("SECRET_IS_NOT_ONE_KEY_VALUE_PAIR"),
    INVALID_SECRET_KEY("INVALID_SECRET_KEY"),
    INVALID_SECRET_VALUE("INVALID_SECRET_VALUE"),
    SECRET_ARN_RESOURCE_NOT_FOUND("SECRET_ARN_RESOURCE_NOT_FOUND"),
    DECRYPT_SECRET_FAILED("DECRYPT_SECRET_FAILED"),
    TOO_MANY_SECRETS("TOO_MANY_SECRETS"),
    DUPLICATED_SECRET("DUPLICATED_SECRET"),
    MALFORMED_SECRET_ARN("MALFORMED_SECRET_ARN"),
    SECRET_FROM_DIFFERENT_ACCOUNT("SECRET_FROM_DIFFERENT_ACCOUNT"),
    SECRET_FROM_DIFFERENT_REGION("SECRET_FROM_DIFFERENT_REGION"),
    INVALID_SECRET("INVALID_SECRET"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ValidationExceptionType> VALUE_MAP;
    private final String value;

    private ValidationExceptionType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ValidationExceptionType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ValidationExceptionType> knownValues() {
        EnumSet<ValidationExceptionType> knownValues = EnumSet.allOf(ValidationExceptionType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ValidationExceptionType.class, ValidationExceptionType::toString);
    }
}

