/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediapackagev2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.mediapackagev2.model.DashDvbErrorMetricsCopier;
import software.amazon.awssdk.services.mediapackagev2.model.DashDvbFontDownload;
import software.amazon.awssdk.services.mediapackagev2.model.DashDvbMetricsReporting;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DashDvbSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DashDvbSettings> {
    private static final SdkField<DashDvbFontDownload> FONT_DOWNLOAD_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("FontDownload").getter(DashDvbSettings.getter(DashDvbSettings::fontDownload)).setter(DashDvbSettings.setter(Builder::fontDownload)).constructor(DashDvbFontDownload::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FontDownload").build()}).build();
    private static final SdkField<List<DashDvbMetricsReporting>> ERROR_METRICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ErrorMetrics").getter(DashDvbSettings.getter(DashDvbSettings::errorMetrics)).setter(DashDvbSettings.setter(Builder::errorMetrics)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorMetrics").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DashDvbMetricsReporting::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FONT_DOWNLOAD_FIELD, ERROR_METRICS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DashDvbSettings.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final DashDvbFontDownload fontDownload;
    private final List<DashDvbMetricsReporting> errorMetrics;

    private DashDvbSettings(BuilderImpl builder) {
        this.fontDownload = builder.fontDownload;
        this.errorMetrics = builder.errorMetrics;
    }

    public final DashDvbFontDownload fontDownload() {
        return this.fontDownload;
    }

    public final boolean hasErrorMetrics() {
        return this.errorMetrics != null && !(this.errorMetrics instanceof SdkAutoConstructList);
    }

    public final List<DashDvbMetricsReporting> errorMetrics() {
        return this.errorMetrics;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.fontDownload());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasErrorMetrics() ? this.errorMetrics() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DashDvbSettings)) {
            return false;
        }
        DashDvbSettings other = (DashDvbSettings)obj;
        return Objects.equals(this.fontDownload(), other.fontDownload()) && this.hasErrorMetrics() == other.hasErrorMetrics() && Objects.equals(this.errorMetrics(), other.errorMetrics());
    }

    public final String toString() {
        return ToString.builder((String)"DashDvbSettings").add("FontDownload", (Object)this.fontDownload()).add("ErrorMetrics", this.hasErrorMetrics() ? this.errorMetrics() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FontDownload": {
                return Optional.ofNullable(clazz.cast(this.fontDownload()));
            }
            case "ErrorMetrics": {
                return Optional.ofNullable(clazz.cast(this.errorMetrics()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("FontDownload", FONT_DOWNLOAD_FIELD);
        map.put("ErrorMetrics", ERROR_METRICS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DashDvbSettings, T> g) {
        return obj -> g.apply((DashDvbSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private DashDvbFontDownload fontDownload;
        private List<DashDvbMetricsReporting> errorMetrics = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DashDvbSettings model) {
            this.fontDownload(model.fontDownload);
            this.errorMetrics(model.errorMetrics);
        }

        public final DashDvbFontDownload.Builder getFontDownload() {
            return this.fontDownload != null ? this.fontDownload.toBuilder() : null;
        }

        public final void setFontDownload(DashDvbFontDownload.BuilderImpl fontDownload) {
            this.fontDownload = fontDownload != null ? fontDownload.build() : null;
        }

        @Override
        public final Builder fontDownload(DashDvbFontDownload fontDownload) {
            this.fontDownload = fontDownload;
            return this;
        }

        public final List<DashDvbMetricsReporting.Builder> getErrorMetrics() {
            List<DashDvbMetricsReporting.Builder> result = DashDvbErrorMetricsCopier.copyToBuilder(this.errorMetrics);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setErrorMetrics(Collection<DashDvbMetricsReporting.BuilderImpl> errorMetrics) {
            this.errorMetrics = DashDvbErrorMetricsCopier.copyFromBuilder(errorMetrics);
        }

        @Override
        public final Builder errorMetrics(Collection<DashDvbMetricsReporting> errorMetrics) {
            this.errorMetrics = DashDvbErrorMetricsCopier.copy(errorMetrics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errorMetrics(DashDvbMetricsReporting ... errorMetrics) {
            this.errorMetrics(Arrays.asList(errorMetrics));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errorMetrics(Consumer<DashDvbMetricsReporting.Builder> ... errorMetrics) {
            this.errorMetrics(Stream.of(errorMetrics).map(c -> (DashDvbMetricsReporting)((DashDvbMetricsReporting.Builder)DashDvbMetricsReporting.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public DashDvbSettings build() {
            return new DashDvbSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DashDvbSettings> {
        public Builder fontDownload(DashDvbFontDownload var1);

        default public Builder fontDownload(Consumer<DashDvbFontDownload.Builder> fontDownload) {
            return this.fontDownload((DashDvbFontDownload)((DashDvbFontDownload.Builder)DashDvbFontDownload.builder().applyMutation(fontDownload)).build());
        }

        public Builder errorMetrics(Collection<DashDvbMetricsReporting> var1);

        public Builder errorMetrics(DashDvbMetricsReporting ... var1);

        public Builder errorMetrics(Consumer<DashDvbMetricsReporting.Builder> ... var1);
    }
}

