/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediapackagev2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mediapackagev2.model.Encryption;
import software.amazon.awssdk.services.mediapackagev2.model.Scte;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Segment
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Segment> {
    private static final SdkField<Integer> SEGMENT_DURATION_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("SegmentDurationSeconds").getter(Segment.getter(Segment::segmentDurationSeconds)).setter(Segment.setter(Builder::segmentDurationSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SegmentDurationSeconds").build()}).build();
    private static final SdkField<String> SEGMENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SegmentName").getter(Segment.getter(Segment::segmentName)).setter(Segment.setter(Builder::segmentName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SegmentName").build()}).build();
    private static final SdkField<Boolean> TS_USE_AUDIO_RENDITION_GROUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("TsUseAudioRenditionGroup").getter(Segment.getter(Segment::tsUseAudioRenditionGroup)).setter(Segment.setter(Builder::tsUseAudioRenditionGroup)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TsUseAudioRenditionGroup").build()}).build();
    private static final SdkField<Boolean> INCLUDE_IFRAME_ONLY_STREAMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IncludeIframeOnlyStreams").getter(Segment.getter(Segment::includeIframeOnlyStreams)).setter(Segment.setter(Builder::includeIframeOnlyStreams)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludeIframeOnlyStreams").build()}).build();
    private static final SdkField<Boolean> TS_INCLUDE_DVB_SUBTITLES_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("TsIncludeDvbSubtitles").getter(Segment.getter(Segment::tsIncludeDvbSubtitles)).setter(Segment.setter(Builder::tsIncludeDvbSubtitles)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TsIncludeDvbSubtitles").build()}).build();
    private static final SdkField<Scte> SCTE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Scte").getter(Segment.getter(Segment::scte)).setter(Segment.setter(Builder::scte)).constructor(Scte::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Scte").build()}).build();
    private static final SdkField<Encryption> ENCRYPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Encryption").getter(Segment.getter(Segment::encryption)).setter(Segment.setter(Builder::encryption)).constructor(Encryption::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Encryption").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SEGMENT_DURATION_SECONDS_FIELD, SEGMENT_NAME_FIELD, TS_USE_AUDIO_RENDITION_GROUP_FIELD, INCLUDE_IFRAME_ONLY_STREAMS_FIELD, TS_INCLUDE_DVB_SUBTITLES_FIELD, SCTE_FIELD, ENCRYPTION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Segment.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Integer segmentDurationSeconds;
    private final String segmentName;
    private final Boolean tsUseAudioRenditionGroup;
    private final Boolean includeIframeOnlyStreams;
    private final Boolean tsIncludeDvbSubtitles;
    private final Scte scte;
    private final Encryption encryption;

    private Segment(BuilderImpl builder) {
        this.segmentDurationSeconds = builder.segmentDurationSeconds;
        this.segmentName = builder.segmentName;
        this.tsUseAudioRenditionGroup = builder.tsUseAudioRenditionGroup;
        this.includeIframeOnlyStreams = builder.includeIframeOnlyStreams;
        this.tsIncludeDvbSubtitles = builder.tsIncludeDvbSubtitles;
        this.scte = builder.scte;
        this.encryption = builder.encryption;
    }

    public final Integer segmentDurationSeconds() {
        return this.segmentDurationSeconds;
    }

    public final String segmentName() {
        return this.segmentName;
    }

    public final Boolean tsUseAudioRenditionGroup() {
        return this.tsUseAudioRenditionGroup;
    }

    public final Boolean includeIframeOnlyStreams() {
        return this.includeIframeOnlyStreams;
    }

    public final Boolean tsIncludeDvbSubtitles() {
        return this.tsIncludeDvbSubtitles;
    }

    public final Scte scte() {
        return this.scte;
    }

    public final Encryption encryption() {
        return this.encryption;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.segmentDurationSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.segmentName());
        hashCode = 31 * hashCode + Objects.hashCode(this.tsUseAudioRenditionGroup());
        hashCode = 31 * hashCode + Objects.hashCode(this.includeIframeOnlyStreams());
        hashCode = 31 * hashCode + Objects.hashCode(this.tsIncludeDvbSubtitles());
        hashCode = 31 * hashCode + Objects.hashCode(this.scte());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryption());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Segment)) {
            return false;
        }
        Segment other = (Segment)obj;
        return Objects.equals(this.segmentDurationSeconds(), other.segmentDurationSeconds()) && Objects.equals(this.segmentName(), other.segmentName()) && Objects.equals(this.tsUseAudioRenditionGroup(), other.tsUseAudioRenditionGroup()) && Objects.equals(this.includeIframeOnlyStreams(), other.includeIframeOnlyStreams()) && Objects.equals(this.tsIncludeDvbSubtitles(), other.tsIncludeDvbSubtitles()) && Objects.equals(this.scte(), other.scte()) && Objects.equals(this.encryption(), other.encryption());
    }

    public final String toString() {
        return ToString.builder((String)"Segment").add("SegmentDurationSeconds", (Object)this.segmentDurationSeconds()).add("SegmentName", (Object)this.segmentName()).add("TsUseAudioRenditionGroup", (Object)this.tsUseAudioRenditionGroup()).add("IncludeIframeOnlyStreams", (Object)this.includeIframeOnlyStreams()).add("TsIncludeDvbSubtitles", (Object)this.tsIncludeDvbSubtitles()).add("Scte", (Object)this.scte()).add("Encryption", (Object)this.encryption()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SegmentDurationSeconds": {
                return Optional.ofNullable(clazz.cast(this.segmentDurationSeconds()));
            }
            case "SegmentName": {
                return Optional.ofNullable(clazz.cast(this.segmentName()));
            }
            case "TsUseAudioRenditionGroup": {
                return Optional.ofNullable(clazz.cast(this.tsUseAudioRenditionGroup()));
            }
            case "IncludeIframeOnlyStreams": {
                return Optional.ofNullable(clazz.cast(this.includeIframeOnlyStreams()));
            }
            case "TsIncludeDvbSubtitles": {
                return Optional.ofNullable(clazz.cast(this.tsIncludeDvbSubtitles()));
            }
            case "Scte": {
                return Optional.ofNullable(clazz.cast(this.scte()));
            }
            case "Encryption": {
                return Optional.ofNullable(clazz.cast(this.encryption()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("SegmentDurationSeconds", SEGMENT_DURATION_SECONDS_FIELD);
        map.put("SegmentName", SEGMENT_NAME_FIELD);
        map.put("TsUseAudioRenditionGroup", TS_USE_AUDIO_RENDITION_GROUP_FIELD);
        map.put("IncludeIframeOnlyStreams", INCLUDE_IFRAME_ONLY_STREAMS_FIELD);
        map.put("TsIncludeDvbSubtitles", TS_INCLUDE_DVB_SUBTITLES_FIELD);
        map.put("Scte", SCTE_FIELD);
        map.put("Encryption", ENCRYPTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Segment, T> g) {
        return obj -> g.apply((Segment)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer segmentDurationSeconds;
        private String segmentName;
        private Boolean tsUseAudioRenditionGroup;
        private Boolean includeIframeOnlyStreams;
        private Boolean tsIncludeDvbSubtitles;
        private Scte scte;
        private Encryption encryption;

        private BuilderImpl() {
        }

        private BuilderImpl(Segment model) {
            this.segmentDurationSeconds(model.segmentDurationSeconds);
            this.segmentName(model.segmentName);
            this.tsUseAudioRenditionGroup(model.tsUseAudioRenditionGroup);
            this.includeIframeOnlyStreams(model.includeIframeOnlyStreams);
            this.tsIncludeDvbSubtitles(model.tsIncludeDvbSubtitles);
            this.scte(model.scte);
            this.encryption(model.encryption);
        }

        public final Integer getSegmentDurationSeconds() {
            return this.segmentDurationSeconds;
        }

        public final void setSegmentDurationSeconds(Integer segmentDurationSeconds) {
            this.segmentDurationSeconds = segmentDurationSeconds;
        }

        @Override
        public final Builder segmentDurationSeconds(Integer segmentDurationSeconds) {
            this.segmentDurationSeconds = segmentDurationSeconds;
            return this;
        }

        public final String getSegmentName() {
            return this.segmentName;
        }

        public final void setSegmentName(String segmentName) {
            this.segmentName = segmentName;
        }

        @Override
        public final Builder segmentName(String segmentName) {
            this.segmentName = segmentName;
            return this;
        }

        public final Boolean getTsUseAudioRenditionGroup() {
            return this.tsUseAudioRenditionGroup;
        }

        public final void setTsUseAudioRenditionGroup(Boolean tsUseAudioRenditionGroup) {
            this.tsUseAudioRenditionGroup = tsUseAudioRenditionGroup;
        }

        @Override
        public final Builder tsUseAudioRenditionGroup(Boolean tsUseAudioRenditionGroup) {
            this.tsUseAudioRenditionGroup = tsUseAudioRenditionGroup;
            return this;
        }

        public final Boolean getIncludeIframeOnlyStreams() {
            return this.includeIframeOnlyStreams;
        }

        public final void setIncludeIframeOnlyStreams(Boolean includeIframeOnlyStreams) {
            this.includeIframeOnlyStreams = includeIframeOnlyStreams;
        }

        @Override
        public final Builder includeIframeOnlyStreams(Boolean includeIframeOnlyStreams) {
            this.includeIframeOnlyStreams = includeIframeOnlyStreams;
            return this;
        }

        public final Boolean getTsIncludeDvbSubtitles() {
            return this.tsIncludeDvbSubtitles;
        }

        public final void setTsIncludeDvbSubtitles(Boolean tsIncludeDvbSubtitles) {
            this.tsIncludeDvbSubtitles = tsIncludeDvbSubtitles;
        }

        @Override
        public final Builder tsIncludeDvbSubtitles(Boolean tsIncludeDvbSubtitles) {
            this.tsIncludeDvbSubtitles = tsIncludeDvbSubtitles;
            return this;
        }

        public final Scte.Builder getScte() {
            return this.scte != null ? this.scte.toBuilder() : null;
        }

        public final void setScte(Scte.BuilderImpl scte) {
            this.scte = scte != null ? scte.build() : null;
        }

        @Override
        public final Builder scte(Scte scte) {
            this.scte = scte;
            return this;
        }

        public final Encryption.Builder getEncryption() {
            return this.encryption != null ? this.encryption.toBuilder() : null;
        }

        public final void setEncryption(Encryption.BuilderImpl encryption) {
            this.encryption = encryption != null ? encryption.build() : null;
        }

        @Override
        public final Builder encryption(Encryption encryption) {
            this.encryption = encryption;
            return this;
        }

        public Segment build() {
            return new Segment(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Segment> {
        public Builder segmentDurationSeconds(Integer var1);

        public Builder segmentName(String var1);

        public Builder tsUseAudioRenditionGroup(Boolean var1);

        public Builder includeIframeOnlyStreams(Boolean var1);

        public Builder tsIncludeDvbSubtitles(Boolean var1);

        public Builder scte(Scte var1);

        default public Builder scte(Consumer<Scte.Builder> scte) {
            return this.scte((Scte)((Scte.Builder)Scte.builder().applyMutation(scte)).build());
        }

        public Builder encryption(Encryption var1);

        default public Builder encryption(Consumer<Encryption.Builder> encryption) {
            return this.encryption((Encryption)((Encryption.Builder)Encryption.builder().applyMutation(encryption)).build());
        }
    }
}

