/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediapackagev2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mediapackagev2.model.CmafEncryptionMethod;
import software.amazon.awssdk.services.mediapackagev2.model.TsEncryptionMethod;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EncryptionMethod
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EncryptionMethod> {
    private static final SdkField<String> TS_ENCRYPTION_METHOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TsEncryptionMethod").getter(EncryptionMethod.getter(EncryptionMethod::tsEncryptionMethodAsString)).setter(EncryptionMethod.setter(Builder::tsEncryptionMethod)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TsEncryptionMethod").build()}).build();
    private static final SdkField<String> CMAF_ENCRYPTION_METHOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CmafEncryptionMethod").getter(EncryptionMethod.getter(EncryptionMethod::cmafEncryptionMethodAsString)).setter(EncryptionMethod.setter(Builder::cmafEncryptionMethod)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CmafEncryptionMethod").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TS_ENCRYPTION_METHOD_FIELD, CMAF_ENCRYPTION_METHOD_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = EncryptionMethod.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String tsEncryptionMethod;
    private final String cmafEncryptionMethod;

    private EncryptionMethod(BuilderImpl builder) {
        this.tsEncryptionMethod = builder.tsEncryptionMethod;
        this.cmafEncryptionMethod = builder.cmafEncryptionMethod;
    }

    public final TsEncryptionMethod tsEncryptionMethod() {
        return TsEncryptionMethod.fromValue(this.tsEncryptionMethod);
    }

    public final String tsEncryptionMethodAsString() {
        return this.tsEncryptionMethod;
    }

    public final CmafEncryptionMethod cmafEncryptionMethod() {
        return CmafEncryptionMethod.fromValue(this.cmafEncryptionMethod);
    }

    public final String cmafEncryptionMethodAsString() {
        return this.cmafEncryptionMethod;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.tsEncryptionMethodAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.cmafEncryptionMethodAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EncryptionMethod)) {
            return false;
        }
        EncryptionMethod other = (EncryptionMethod)obj;
        return Objects.equals(this.tsEncryptionMethodAsString(), other.tsEncryptionMethodAsString()) && Objects.equals(this.cmafEncryptionMethodAsString(), other.cmafEncryptionMethodAsString());
    }

    public final String toString() {
        return ToString.builder((String)"EncryptionMethod").add("TsEncryptionMethod", (Object)this.tsEncryptionMethodAsString()).add("CmafEncryptionMethod", (Object)this.cmafEncryptionMethodAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TsEncryptionMethod": {
                return Optional.ofNullable(clazz.cast(this.tsEncryptionMethodAsString()));
            }
            case "CmafEncryptionMethod": {
                return Optional.ofNullable(clazz.cast(this.cmafEncryptionMethodAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("TsEncryptionMethod", TS_ENCRYPTION_METHOD_FIELD);
        map.put("CmafEncryptionMethod", CMAF_ENCRYPTION_METHOD_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EncryptionMethod, T> g) {
        return obj -> g.apply((EncryptionMethod)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String tsEncryptionMethod;
        private String cmafEncryptionMethod;

        private BuilderImpl() {
        }

        private BuilderImpl(EncryptionMethod model) {
            this.tsEncryptionMethod(model.tsEncryptionMethod);
            this.cmafEncryptionMethod(model.cmafEncryptionMethod);
        }

        public final String getTsEncryptionMethod() {
            return this.tsEncryptionMethod;
        }

        public final void setTsEncryptionMethod(String tsEncryptionMethod) {
            this.tsEncryptionMethod = tsEncryptionMethod;
        }

        @Override
        public final Builder tsEncryptionMethod(String tsEncryptionMethod) {
            this.tsEncryptionMethod = tsEncryptionMethod;
            return this;
        }

        @Override
        public final Builder tsEncryptionMethod(TsEncryptionMethod tsEncryptionMethod) {
            this.tsEncryptionMethod(tsEncryptionMethod == null ? null : tsEncryptionMethod.toString());
            return this;
        }

        public final String getCmafEncryptionMethod() {
            return this.cmafEncryptionMethod;
        }

        public final void setCmafEncryptionMethod(String cmafEncryptionMethod) {
            this.cmafEncryptionMethod = cmafEncryptionMethod;
        }

        @Override
        public final Builder cmafEncryptionMethod(String cmafEncryptionMethod) {
            this.cmafEncryptionMethod = cmafEncryptionMethod;
            return this;
        }

        @Override
        public final Builder cmafEncryptionMethod(CmafEncryptionMethod cmafEncryptionMethod) {
            this.cmafEncryptionMethod(cmafEncryptionMethod == null ? null : cmafEncryptionMethod.toString());
            return this;
        }

        public EncryptionMethod build() {
            return new EncryptionMethod(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EncryptionMethod> {
        public Builder tsEncryptionMethod(String var1);

        public Builder tsEncryptionMethod(TsEncryptionMethod var1);

        public Builder cmafEncryptionMethod(String var1);

        public Builder cmafEncryptionMethod(CmafEncryptionMethod var1);
    }
}

