/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediapackagev2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.mediapackagev2.model.DrmSystem;
import software.amazon.awssdk.services.mediapackagev2.model.EncryptionContractConfiguration;
import software.amazon.awssdk.services.mediapackagev2.model.SpekeKeyProviderDrmSystemsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SpekeKeyProvider
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SpekeKeyProvider> {
    private static final SdkField<EncryptionContractConfiguration> ENCRYPTION_CONTRACT_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EncryptionContractConfiguration").getter(SpekeKeyProvider.getter(SpekeKeyProvider::encryptionContractConfiguration)).setter(SpekeKeyProvider.setter(Builder::encryptionContractConfiguration)).constructor(EncryptionContractConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionContractConfiguration").build()}).build();
    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceId").getter(SpekeKeyProvider.getter(SpekeKeyProvider::resourceId)).setter(SpekeKeyProvider.setter(Builder::resourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceId").build()}).build();
    private static final SdkField<List<String>> DRM_SYSTEMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DrmSystems").getter(SpekeKeyProvider.getter(SpekeKeyProvider::drmSystemsAsStrings)).setter(SpekeKeyProvider.setter(Builder::drmSystemsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DrmSystems").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoleArn").getter(SpekeKeyProvider.getter(SpekeKeyProvider::roleArn)).setter(SpekeKeyProvider.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()}).build();
    private static final SdkField<String> URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Url").getter(SpekeKeyProvider.getter(SpekeKeyProvider::url)).setter(SpekeKeyProvider.setter(Builder::url)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Url").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENCRYPTION_CONTRACT_CONFIGURATION_FIELD, RESOURCE_ID_FIELD, DRM_SYSTEMS_FIELD, ROLE_ARN_FIELD, URL_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SpekeKeyProvider.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final EncryptionContractConfiguration encryptionContractConfiguration;
    private final String resourceId;
    private final List<String> drmSystems;
    private final String roleArn;
    private final String url;

    private SpekeKeyProvider(BuilderImpl builder) {
        this.encryptionContractConfiguration = builder.encryptionContractConfiguration;
        this.resourceId = builder.resourceId;
        this.drmSystems = builder.drmSystems;
        this.roleArn = builder.roleArn;
        this.url = builder.url;
    }

    public final EncryptionContractConfiguration encryptionContractConfiguration() {
        return this.encryptionContractConfiguration;
    }

    public final String resourceId() {
        return this.resourceId;
    }

    public final List<DrmSystem> drmSystems() {
        return SpekeKeyProviderDrmSystemsListCopier.copyStringToEnum(this.drmSystems);
    }

    public final boolean hasDrmSystems() {
        return this.drmSystems != null && !(this.drmSystems instanceof SdkAutoConstructList);
    }

    public final List<String> drmSystemsAsStrings() {
        return this.drmSystems;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final String url() {
        return this.url;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionContractConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDrmSystems() ? this.drmSystemsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.url());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SpekeKeyProvider)) {
            return false;
        }
        SpekeKeyProvider other = (SpekeKeyProvider)obj;
        return Objects.equals(this.encryptionContractConfiguration(), other.encryptionContractConfiguration()) && Objects.equals(this.resourceId(), other.resourceId()) && this.hasDrmSystems() == other.hasDrmSystems() && Objects.equals(this.drmSystemsAsStrings(), other.drmSystemsAsStrings()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.url(), other.url());
    }

    public final String toString() {
        return ToString.builder((String)"SpekeKeyProvider").add("EncryptionContractConfiguration", (Object)this.encryptionContractConfiguration()).add("ResourceId", (Object)this.resourceId()).add("DrmSystems", this.hasDrmSystems() ? this.drmSystemsAsStrings() : null).add("RoleArn", (Object)this.roleArn()).add("Url", (Object)this.url()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EncryptionContractConfiguration": {
                return Optional.ofNullable(clazz.cast(this.encryptionContractConfiguration()));
            }
            case "ResourceId": {
                return Optional.ofNullable(clazz.cast(this.resourceId()));
            }
            case "DrmSystems": {
                return Optional.ofNullable(clazz.cast(this.drmSystemsAsStrings()));
            }
            case "RoleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "Url": {
                return Optional.ofNullable(clazz.cast(this.url()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("EncryptionContractConfiguration", ENCRYPTION_CONTRACT_CONFIGURATION_FIELD);
        map.put("ResourceId", RESOURCE_ID_FIELD);
        map.put("DrmSystems", DRM_SYSTEMS_FIELD);
        map.put("RoleArn", ROLE_ARN_FIELD);
        map.put("Url", URL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SpekeKeyProvider, T> g) {
        return obj -> g.apply((SpekeKeyProvider)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private EncryptionContractConfiguration encryptionContractConfiguration;
        private String resourceId;
        private List<String> drmSystems = DefaultSdkAutoConstructList.getInstance();
        private String roleArn;
        private String url;

        private BuilderImpl() {
        }

        private BuilderImpl(SpekeKeyProvider model) {
            this.encryptionContractConfiguration(model.encryptionContractConfiguration);
            this.resourceId(model.resourceId);
            this.drmSystemsWithStrings(model.drmSystems);
            this.roleArn(model.roleArn);
            this.url(model.url);
        }

        public final EncryptionContractConfiguration.Builder getEncryptionContractConfiguration() {
            return this.encryptionContractConfiguration != null ? this.encryptionContractConfiguration.toBuilder() : null;
        }

        public final void setEncryptionContractConfiguration(EncryptionContractConfiguration.BuilderImpl encryptionContractConfiguration) {
            this.encryptionContractConfiguration = encryptionContractConfiguration != null ? encryptionContractConfiguration.build() : null;
        }

        @Override
        public final Builder encryptionContractConfiguration(EncryptionContractConfiguration encryptionContractConfiguration) {
            this.encryptionContractConfiguration = encryptionContractConfiguration;
            return this;
        }

        public final String getResourceId() {
            return this.resourceId;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final Collection<String> getDrmSystems() {
            if (this.drmSystems instanceof SdkAutoConstructList) {
                return null;
            }
            return this.drmSystems;
        }

        public final void setDrmSystems(Collection<String> drmSystems) {
            this.drmSystems = SpekeKeyProviderDrmSystemsListCopier.copy(drmSystems);
        }

        @Override
        public final Builder drmSystemsWithStrings(Collection<String> drmSystems) {
            this.drmSystems = SpekeKeyProviderDrmSystemsListCopier.copy(drmSystems);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder drmSystemsWithStrings(String ... drmSystems) {
            this.drmSystemsWithStrings(Arrays.asList(drmSystems));
            return this;
        }

        @Override
        public final Builder drmSystems(Collection<DrmSystem> drmSystems) {
            this.drmSystems = SpekeKeyProviderDrmSystemsListCopier.copyEnumToString(drmSystems);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder drmSystems(DrmSystem ... drmSystems) {
            this.drmSystems(Arrays.asList(drmSystems));
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getUrl() {
            return this.url;
        }

        public final void setUrl(String url) {
            this.url = url;
        }

        @Override
        public final Builder url(String url) {
            this.url = url;
            return this;
        }

        public SpekeKeyProvider build() {
            return new SpekeKeyProvider(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SpekeKeyProvider> {
        public Builder encryptionContractConfiguration(EncryptionContractConfiguration var1);

        default public Builder encryptionContractConfiguration(Consumer<EncryptionContractConfiguration.Builder> encryptionContractConfiguration) {
            return this.encryptionContractConfiguration((EncryptionContractConfiguration)((EncryptionContractConfiguration.Builder)EncryptionContractConfiguration.builder().applyMutation(encryptionContractConfiguration)).build());
        }

        public Builder resourceId(String var1);

        public Builder drmSystemsWithStrings(Collection<String> var1);

        public Builder drmSystemsWithStrings(String ... var1);

        public Builder drmSystems(Collection<DrmSystem> var1);

        public Builder drmSystems(DrmSystem ... var1);

        public Builder roleArn(String var1);

        public Builder url(String var1);
    }
}

