/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediapackagev2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum InputType {
    HLS("HLS"),
    CMAF("CMAF"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, InputType> VALUE_MAP;
    private final String value;

    private InputType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static InputType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<InputType> knownValues() {
        EnumSet<InputType> knownValues = EnumSet.allOf(InputType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(InputType.class, InputType::toString);
    }
}

