/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediapackagev2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ConflictExceptionType {
    RESOURCE_IN_USE("RESOURCE_IN_USE"),
    RESOURCE_ALREADY_EXISTS("RESOURCE_ALREADY_EXISTS"),
    IDEMPOTENT_PARAMETER_MISMATCH("IDEMPOTENT_PARAMETER_MISMATCH"),
    CONFLICTING_OPERATION("CONFLICTING_OPERATION"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ConflictExceptionType> VALUE_MAP;
    private final String value;

    private ConflictExceptionType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ConflictExceptionType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ConflictExceptionType> knownValues() {
        EnumSet<ConflictExceptionType> knownValues = EnumSet.allOf(ConflictExceptionType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ConflictExceptionType.class, ConflictExceptionType::toString);
    }
}

